with  Reps, CoBalls, CoNumbers, Numerics, Intervals;
use Reps, CoBalls, CoNumbers, Numerics, Intervals;

generic

   Size: in Positive;
   Dho: in Natural;
   type Comp is private;
   type Scalar is private;


   --intervals
   with function IsNumeric(S: Scalar) return Boolean is <>;
   with function Scal(K: Integer) return Scalar is <>;
   with function Scal(R: Rep) return Scalar is <>;
   with function Err0(S: Scalar) return Boolean is <>;
   with function Approx(S: Scalar) return Rep is <>;
   with function "-"(S: Scalar) return Scalar is <>;
   with function Center(S: Scalar) return Scalar is <>;
   with procedure ResetCenter(S: in out Scalar) is <>;
   with function ResetCenter(S: Scalar) return Scalar is <>;

   with function Scal(R1,R2: Rep) return Scalar is <>;
   with function Ball(S: Scalar) return Scalar is <>;
   with function Inf(S: Scalar) return Rep is <>;
   with function Sup(S: Scalar) return Rep is <>;
   with function SupAbs(S: Scalar) return Rep is <>;
   with function "<"(S1,S2: Scalar) return Boolean is <>;
   with function IntFloor(S: Scalar) return Integer is <>;
   with function IntCeiling(S: Scalar) return Integer is <>;
   with function "abs"(S: Scalar) return Scalar is <>;
   with function Min(S1,S2: Scalar) return Scalar is <>;
   with function Max(S1,S2: Scalar) return Scalar is <>;
   with function Cap(R: Radius; S: Scalar) return Scalar is <>;
   with function Up(R: Rep; Dummy: Scalar) return Rep is <>;
   with procedure ErrMult(R: in Rep; S: in out Scalar) is <>;

   with function "+"(S,T: Scalar) return Scalar is <>;
   with function "-"(S,T: Scalar) return Scalar is <>;
   with function "*"(R: Rep; S: Scalar) return Scalar is <>;
   with function "/"(R: Rep; S: Scalar) return Scalar is <>;
   with function "/"(S: Scalar; R: Rep) return Scalar is <>;
   with function Sqr(S: Scalar) return Scalar is <>;
   with function "*"(S,T: Scalar) return Scalar is <>;
   with function Inv(S: Scalar) return Scalar is <>;
   with function "/"(S,T: Scalar) return Scalar is <>;
   with function "**"(S: Scalar; I: Integer) return Scalar is <>;
   with function Short_Exp(R: Scalar; Iter: Integer) return Scalar is <>;

   with function MinusPi_Pi(S: Scalar) return Scalar is <>;
   with function Cosh(S: Scalar) return Scalar is <>;
   with function Sinh(S: Scalar) return Scalar is <>;
   with function Sin(S: Scalar) return Scalar is <>;
   with function Cos(S: Scalar) return Scalar is <>;
   with function Exp(S: Scalar) return Scalar is <>;
   with function Log(S: Scalar) return Scalar is <>;
   with function Sqrt(S: Scalar) return Scalar is <>;
   --  with function ArcTan(S: Scalar; S1: Scalar; Cycle: Scalar) return Scalar is <>;
   --   with function Pouer(S: Rep; I: Integer) return Rep is <>;

   --balls

   with function Conj(C: Comp) return Comp is <>;
   with function SetBall(C: Comp; R: Rep:=Zero) return Comp is <>;
   with function IsCoNumber(S: Comp) return Boolean is <>;
   with function IsBall(S: Comp) return Boolean is <>;
   with function Complecs(Re,Im: Rep) return Comp is <>;
   with procedure ResetCenter(S: in out Comp) is <>;
   with function ResetCenter(S: Comp) return Comp is <>;
   with procedure Split(S: in Comp; Sr,Se: out Comp) is <>;
   with procedure ResetErr(S: in out Comp) is <>;
   with function ResetErr(S: Comp) return Comp is <>;
   with function CenterBall(S: Comp) return Comp is <>;
   with function Ball0(R: Rep) return Comp is <>;
   with function Ball0(R: Comp) return Comp is <>;
   with function ErrPart(S: Comp) return Rep is <>;


   with function RePart(S: Comp) return Scalar is <>;
   with function ImPart(S: Comp) return Scalar is <>;
   with function InfRe(S: Comp) return Rep is <>;
   with function SupRe(S: Comp) return Rep is <>;
   with function InfIm(S: Comp) return Rep is <>;
   with function SupIm(S: Comp) return Rep is <>;
   with function SupMod(S: Comp) return Rep is <>;
   with function InfMod(S: Comp) return Rep is <>;
   with function AbsBall(S: Comp) return Comp is <>;
   with function AbsVal(S: Comp) return Scalar is <>;
   with function Arg(C: Comp) return Scalar is <>;
   with procedure ErrMult(R: in Rep; S: in out Comp) is <>;
   with function Neg(S: Comp) return Comp is <>;
   with procedure RandomBall(Seed: in out Long_Integer; S: out Comp) is <>;

   with function Contains(S: Comp; C: Comp) return Boolean is <>;
   with function Intersects(S: Comp; T: Comp) return Boolean is <>;
   with function "+"(S,T: Comp) return Comp is <>;
   with function "-"(S,T: Comp) return Comp is <>;
   with function "*"(R: Rep; S: Comp) return Comp is <>;
   with function "*"(R: Scalar; S: Comp) return Comp is <>;
   with function "/"(S: Comp; R: Rep) return Comp is <>;
   with function "/"(S: Comp; R: Scalar) return Comp is <>;
   with function Sqr(S: Comp) return Comp is <>;
   with function "*"(S,T: Comp) return Comp is <>;
   with function Inv(S: Comp) return Comp is <>;
   with function Long_Inv(S: Comp) return Comp is <>;
   with function "/"(S,T: Comp) return Comp is <>;
   with function "**"(S: Comp; I: Integer) return Comp is <>;
   with function Cap(R: Radius; S: Comp) return Comp  is <>; --very shaky
   with function MaxMod(S1,S2: Comp) return Comp is <>;

   with function Cosh(S: Comp) return Comp is <>;
   with function Sinh(S: Comp) return Comp is <>;
   with function Exp(S: Comp) return Comp is <>;
   with function EiExp(S1,S2: Comp; NumErr: Rep:=Rep(1.0E-15)) return Comp is <>;
   with function Cos(S: Comp) return Comp is <>;
   with function Sin(S: Comp) return Comp is <>;
   with function Log(S: Comp) return Comp is <>;
   with function Sqrt(S: Comp) return Comp is <>;
   --   with function PiBall return Comp is <>;







package Taylors is

   pragma Pure;
   subtype Power is Integer range 0 .. Size;
   subtype Degree is Integer range -1 .. Size;
   type Taylor is private;

   type CompVec is array(Integer range <>) of Comp;
   type CompVector is array(Long_Long_Integer range <>) of Comp;
   type CompMat is array(Integer range <>, Integer range <>) of Comp;
   type TayVec is array(Integer range <>) of Taylor;
   type TayMat is array(Integer range <>, Integer range <>) of Taylor;

   function Deg(P: Taylor) return Degree;                                -- Deg
   function EffDeg(P: Taylor) return Degree;                             -- Effective Deg
   procedure SetDeg(D: in Degree; P: in out Taylor);                     -- Set Deg (try to avoid)
   procedure SetZero(P: out Taylor);                                     -- P := 0
   function IsZero(P: Taylor) return Boolean;                            -- True if P=0
   procedure Cleanup(P: in out Taylor);                                  -- Lower Deg if possible
   procedure Copy(P1: in Taylor; P2: out Taylor);                        -- P2 := P1

   function Component(K: Power; P: Taylor) return Comp;                  -- P[K]
   procedure Component(K: in Power; P1: in Taylor; P2: out Taylor);      -- P2[0] := P1[K]
   procedure SetComponent(D: in Power; S: in Comp; P: in out Taylor);    -- P[D] := S
   procedure ResetComponent(P: in out Taylor;
                            Kmin: in Natural := 0;
                            Kmax: in Integer := Size);                   -- Set P.C[Kmin .. Kmax] := 0
   function ErrComp(P: Taylor) return Rep;                               -- general error
   procedure SetErrComp(S: in Rep; P: in out Taylor);                    -- general error := |S|
   procedure ResetErrComp(P: in out Taylor);                             -- general error := 0

private

   type Taylor is
      record
         D: Degree;          --- C(D+1 .. Size) considered 0; function=0 if D<0
         E: Rep;             --- general error term; ignored if using numeric, or if D<0
         C: CompVec(Power);  --- C(Dho .. Size) may include higher order errors
      end record;

   CompZero: constant Comp:=Complecs(Zero,Zero);
   CompOne: constant Comp:=Complecs(One,Zero);
   Trunc: constant Boolean := IsCoNumber(CompZero);
end Taylors;
