with  Messages,Intervals.IO;
use Messages;

pragma Elaborate_All (Messages);

package body Taylors.Ops is


   function IMin(I1,I2: Integer) return Integer renames Integer'Min;
   function IMax(I1,I2: Integer) return Integer renames Integer'Max;

   pragma Inline (Imin,Imax);
   pragma Suppress(Storage_Check);

   procedure AddComponent(D: in Power; S: in Comp; P: in out Taylor) is --FINE
   begin
      if S=Complecs(Zero,Zero) then return; end if;
      if D > P.D then
         for K in P.D+1 .. D-1 loop
            P.C(K) := Complecs(Zero,Zero);
         end loop;
         P.C(D) := S;
         if P.D<0 then P.E := Zero; end if;
         P.D := D;
      else
         P.C(D) := P.C(D)+S;
      end if;
   end AddComponent;


   procedure MultComponent(D: in Power; S: in Comp; P: in out Taylor) is  --FINE
   begin
      if D <= P.D then
         P.C(D) := S*P.C(D);
      end if;
   end MultComponent;


  procedure AddErrComp(S: in Comp; P: in out Taylor) is --FINE
  begin
    if Trunc or else S=Complecs(Zero,Zero) then return; end if;
    if P.D >= 0 then
      P.E := P.E+SupMod(S);
    else
      P.C(0) := Complecs(Zero,Zero);
      P.D := 0;
      P.E := SupMod(S);
    end if;
  end AddErrComp;

  procedure AddErrComp(S: in Rep; P: in out Taylor) is --FINE
  begin
     if Trunc or else S=Zero then return; end if;
     if P.D >= 0 then
        P.E := P.E+S;
     else
        P.C(0) := Complecs(Zero,Zero);
        P.D := 0;
        P.E := abs(S);
     end if;
  end AddErrComp;


  procedure MultErrComp(S: in Comp; P: in out Taylor) is --FINE
  begin
    if Trunc or else P.D<0 then return; end if;
    P.E := SupMod(S)*P.E;
  end MultErrComp;


  procedure MultErrComp(S: in Rep; P: in out Taylor) is --FINE
  begin
     if Trunc or else P.D<0 then return; end if;
     P.E := abs(S)*P.E;
  end MultErrComp;


  function Coeff(R: Radius; K: Power; P: Taylor) return Comp is  --FINE, a ball containing contributions of the components and errors
  begin
     if Dho<3 then
        Message("Taylors.Ops.Coeff",Domain_Violation);
     end if;
     if P.D<0 then
        return Complecs(Zero,Zero);
     elsif Trunc or K<1 then   --NEW HERE
        return Component(K,P);
     elsif K < Dho then
        return Component(K,P)+Ball0(P.E)/Scal(R)**(K-1); --NEW HERE
     end if;
     declare
        K1: constant Integer := IMin(K-1,P.D);
        E: Comp := Ball0(P.E)/Scal(R)**(Dho-2); --NEW HERE
     begin
        for N in Dho .. K1 loop
           E := E/R+ResetCenter(P.C(N));
        end loop;
        return Component(K,P)+E/R**(K-K1);
     end;
  end Coeff;




  procedure ResetCenter(P: in out Taylor; Kmin: in Natural := 0; Kmax: in Integer := Size) is --FINE
  begin
    if Trunc then
      ResetComponent(P,Kmin,Kmax);
    else
      for K in Kmin .. Imin(Kmax,P.D) loop
        ResetCenter(P.C(K));
      end loop;
    end if;
  end ResetCenter;




  function Val(N: Integer; R: Radius; Z: Comp; P: Taylor) return Comp is --FINE
     S: Comp;
     Z1: Comp:=Z;
  begin
     if  Deg(P)<0 then
        Message("Taylors.Ops.Val",Not_Implemented);
     end if;
     for I in 1..N loop
        if SupMod(Z1)>R then
           Message("Taylors.Ops.Val",Domain_Violation);
        end if;
        S:= Complecs(Zero,Zero);
        for K in reverse 0..Deg(P) loop
           S := Z1*S+P.C(K);
        end loop;
        if not Trunc then
           S:=S+Z1*Ball0(P.E);
        end if;
        Z1:=ResetErr(S);
     end loop;
     return S;
  end Val;


  function Norm(R: Radius; P: Taylor) return Rep is --FINE
     E: Rep := Zero;
  begin
     for K in reverse 0 .. P.D loop
        E := R*E+SupMod(P.C(K));
     end loop;
     if Trunc or else P.D<0 then return E; end if;
     return E+P.E*R; --NEW HERE
  end Norm;


  procedure Neg(P1: in Taylor; P2: out Taylor) is --FINE
  begin
     P2.D := P1.D;
     for K in 0 .. P1.D loop
        P2.C(K) := Neg(P1.C(K));
     end loop;
     P2.E := P1.E;                  -- garbage if Trunc
  end Neg;


  function "-"(P: Taylor) return Taylor is --FINE
     Pt: Taylor;
  begin
     Neg(P,Pt);
    return Pt;
  end "-";

  procedure Mult(S: in Comp; P: in out Taylor) is --FINE
  begin
     for K in 0 .. P.D loop
        P.C(K) := S*P.C(K);
     end loop;
     if Trunc or else P.D<0 then return; end if;
     P.E := SupMod(S)*P.E;
  end Mult;


  procedure Prod(S: in Comp; P1: in Taylor; P2: out Taylor) is --FINE
  begin
     P2.D := P1.D;
     for K in 0 .. P1.D loop
        P2.C(K) := S*P1.C(K);
     end loop;
     if Trunc or else P1.D<0 then return; end if;
     P2.E := SupMod(S)*P1.E;
  end Prod;


  function "*"(S: Comp; P: Taylor) return Taylor is --FINE
     Pt: Taylor;
  begin
     Prod(S,P,Pt);
     return Pt;
  end "*";


  procedure Add(P1: in Taylor; P2: in out Taylor) is --FINE
  begin
     if P1.D <= P2.D then
        if P1.D<0 then return; end if;
        for K in 0 .. P1.D loop
           P2.C(K) := P2.C(K)+P1.C(K);
        end loop;
     else
        if P2.D<0 then Copy(P1,P2); return; end if;
        for K in 0 .. P2.D loop
           P2.C(K) := P2.C(K)+P1.C(K);
        end loop;
        for K in P2.D+1 .. P1.D loop
           P2.C(K) := P1.C(K);
        end loop;
        P2.D := P1.D;
     end if;
     if Trunc then return; end if;
     P2.E := P2.E+P1.E;
  end Add;


  procedure Sum(P1,P2: in Taylor; P3: out Taylor) is --FINE
  begin
     if P1.D <= P2.D then
        if P1.D<0 then Copy(P2,P3); return; end if;
        for K in 0 .. P1.D loop
           P3.C(K) := P1.C(K)+P2.C(K);
        end loop;
        for K in P1.D+1 .. P2.D loop
           P3.C(K) := P2.C(K);
        end loop;
        P3.D := P2.D;
     else
        if P2.D<0 then Copy(P1,P3); return; end if;
        for K in 0 .. P2.D loop
           P3.C(K) := P1.C(K)+P2.C(K);
        end loop;
        for K in P2.D+1 .. P1.D loop
           P3.C(K) := P1.C(K);
        end loop;
        P3.D := P1.D;
     end if;
     if Trunc then return; end if;
     P3.E := P1.E+P2.E;
  end Sum;

  function "+"(P1,P2: Taylor) return Taylor is --FINE
     Pt: Taylor;
  begin
     Sum(P1,P2,Pt);
     return Pt;
  end "+";

  procedure Sub(P1: in Taylor; P2: in out Taylor) is --FINE
  begin
     if P1.D <= P2.D then
        if P1.D<0 then return; end if;
        for K in 0 .. P1.D loop
           P2.C(K) := P2.C(K)-P1.C(K);
        end loop;
     else
        if P2.D<0 then Neg(P1,P2); return; end if;
        for K in 0 .. P2.D loop
           P2.C(K) := P2.C(K)-P1.C(K);
        end loop;
        for K in P2.D+1 .. P1.D loop
           P2.C(K) := Neg(P1.C(K));
        end loop;
        P2.D := P1.D;
     end if;
     if Trunc then return; end if;
     P2.E := P2.E+P1.E;
  end Sub;

  procedure Diff(P1,P2: in Taylor; P3: out Taylor) is --FINE
  begin
     if P1.D <= P2.D then
        if P1.D<0 then Neg(P2,P3); return; end if;
        for K in 0 .. P1.D loop
           P3.C(K) := P1.C(K)-P2.C(K);
        end loop;
        for K in P1.D+1 .. P2.D loop
           P3.C(K) := Neg(P2.C(K));
        end loop;
        P3.D := P2.D;
     else
        if P2.D<0 then Copy(P1,P3); return; end if;
        for K in 0 .. P2.D loop
           P3.C(K) := P1.C(K)-P2.C(K);
        end loop;
        for K in P2.D+1 .. P1.D loop
           P3.C(K) := P1.C(K);
        end loop;
        P3.D := P1.D;
     end if;
     if Trunc then return; end if;
     P3.E := P1.E+P2.E;
  end Diff;

  function "-"(P1,P2: Taylor) return Taylor is --FINE
     Pt: Taylor;
  begin
     Diff(P1,P2,Pt);
     return Pt;
  end "-";

  procedure MultAdd(S: in Comp; P1: in Taylor; P2: in out Taylor) is --FINE
  begin
     if P1.D <= P2.D then
        if P1.D<0 or else S=Complecs(Zero,Zero) then return; end if;
        for K in 0 .. P1.D loop
           P2.C(K) := P2.C(K)+S*P1.C(K);
        end loop;
     else
        if P2.D<0 then Prod(S,P1,P2); return; end if;
        if S=Complecs(Zero,Zero) then return; end if;
        for K in 0 .. P2.D loop
           P2.C(K) := P2.C(K)+S*P1.C(K);
        end loop;
        for K in P2.D+1 .. P1.D loop
           P2.C(K) := S*P1.C(K);
        end loop;
        P2.D := P1.D;
     end if;
     if Trunc then return; end if;
     P2.E := P2.E+SupMod(S)*P1.E;
  end Multadd;


  procedure DegConvert(R: in Radius; D: in Degree; P: in out Taylor) is --FINE
  begin
     if D >= P.D then return; end if;
     if not Trunc then
        declare
           E: Comp := Complecs(Zero,Zero);
        begin
           for K in reverse D+1 .. P.D loop
              E := R*E+Ball0(P.C(K));
           end loop;
           if D<Dho then
              if D<0 then
                 Message("Taylors.Ops.DegConvert",Domain_Violation);
              end if;
              P.E := P.E+SupMod(E)*R**(D+1);
           else
              P.C(D) := P.C(D)+R*E;
           end if;
        end;
     end if;
     P.D := D;
  end DegConvert;


  procedure Mult(R: in Radius; P1: in Taylor; P2: in out Taylor; D: in Degree := Size) is
  begin
     if P2.D<0 then return; end if;
     if P1.D<0 then P2.D := -1; return; end if;

     if Trunc then
     declare
        D2: constant Natural := Imin(D,P1.D+P2.D);
        S: Comp;
     begin
        for K in reverse 0 .. D2 loop
           S := Complecs(Zero,Zero);
           for I in IMax(0,K-P1.D) .. IMin(K,P2.D) loop
              S := S+P2.C(I)*P1.C(K-I);
           end loop;
           P2.C(K) := S;
        end loop;
        P2.D := D2;
     end;
     return;
     end if;                    -- done with numeric case

     declare                    -- now continue the easy way
        Pt: Taylor;
     begin
        Copy(P2,Pt);
        Prod(R,P1,Pt,P2,D);
     end;
  end Mult;

  procedure Prod(R: in Radius; P1,P2: in Taylor; P3: out Taylor; D: in Degree := Size) is --FINE
  begin
     if P1.D<0 or else P2.D<0 then
      P3.D := -1;
      return;
     end if;

     if Trunc then
        if D<0 then P3.D := -1; return; end if;
     elsif D<Dho then
        Prod(R,P1,P2,P3,Dho);
        DegConvert(R,D,P3);
        return;
     end if;

     declare
        D1: constant Natural := P1.D+P2.D;
        St,B,A: Comp;
        E: Scalar;
     begin

        P3.D := IMin(D1,D);
        -- Compute l.o. terms
        for K in reverse 0 .. P3.D loop
           St := Complecs(Zero,Zero);
           for I in IMax(0,K-P1.D) .. IMin(K,P2.D) loop
              St := St+P2.C(I)*P1.C(K-I);
           end loop;
           P3.C(K) := St;
        end loop;
        if Trunc then return; end if;                       -- done with numeric case

        -- Collect h.o. terms
        if D1>D then                                        -- collect h.o. terms
           A := CompZero;
           for K in reverse P3.D+1 .. D1 loop
              St := Complecs(Zero,Zero);
              for I in IMax(0,K-P1.D) .. IMin(K,P2.D) loop
                 St := St+P2.C(I)*P1.C(K-I);
              end loop;
              A := R*A+AbsBall(St);
           end loop;
           P3.C(D) := P3.C(D)+R*Ball0(A);                      -- r, add them to P3.C(P3.D)
        end if;

        -- Contribution to g3: g1*g2
        P3.E := R*P1.E*P2.E;

        if P1.E /= Zero then
           --Contribution to g3: g1*p2(0)+R*g1*p2(1)+R^2*g1*p2(2)+...
           --                   +R^(Dho-3)*g1*p2(Dho-3)+R^(Dho-2)*g1*p2(Dho-2)
           E := Scal(Zero);
           for K in reverse 0..Dho-2 loop
              E := R*E+AbsVal(P2.C(K));
           end loop;
           P3.E := P3.E+Sup(P1.E*E);
           --Contribution to h3(K):  g1*h2(K-1)
           E := Scal(P1.E);
           P3.C(Dho) := P3.C(Dho)+Sup(E)*Ball0(P2.C(Dho-1));
           for K in Dho+1 .. P3.D loop
              P3.C(K) := P3.C(K)+Sup(E)*Ball0(P2.C(K-1));
           end loop;
           --Contribution to h3(P3.D):  R*g1*h2(P3.D)+R^2*g1*h2(P3.D+1)+R^3*g1*h2(P3.D+2)+...
           --                           + R^(P2.D-P3.D)*g1*h2(P2.D-1)+R^(P2.D-P3.D+1)*g1*h2(P2.D)
           B:=CompZero;
           for K in reverse P3.D+1 .. P2.D+1 loop
              B := R*B+Sup(R*E)*Ball0(P2.C(K-1));
           end loop;
           P3.C(P3.D):= P3.C(P3.D)+R*B;
        end if;

        if P2.E /= Zero then
           --Contribution to g3: g2*p1(0)+R*g2*p1(1)+R^2*g2*p1(2)+...
           --                   +R^(Dho-3)*g2*p1(Dho-3)+R^(Dho-2)*g2*p1(Dho-2)
           E := Scal(Zero);
           for K in reverse 0..Dho-2 loop
              E := R*E+AbsVal(P1.C(K));
           end loop;
           P3.E := P3.E+Sup(P2.E*E);
           --Contribution to h3(K):  g2*h1(K-1)
           E := Scal(P2.E);
           P3.C(Dho) := P3.C(Dho)+Sup(E)*Ball0(P1.C(Dho-1));
           for K in Dho+1 .. P3.D loop
              P3.C(K) := P3.C(K)+Sup(E)*Ball0(P1.C(K-1));
           end loop;
           --Contribution to h3(P3.d):  z*g2*h1(P3.D)+z^2*g2*h1(P3.D+1)+z^3*g2*h1(P3.D+2)+...
           --                           + z^(P1.D-P3.D)*g2*h1(P1.D-1)+z^(P1.D-P3.D+1)*g2*h1(P1.D)
           B:=CompZero;
           for K in reverse P3.D+1 .. P1.D+1 loop
              B := R*B+Sup(R*E)*Ball0(P1.C(K-1));
           end loop;
           P3.C(P3.D):= P3.C(P3.D)+R*B;
        end if;
     end;
  end Prod;


  function Prod(R: Radius; P1,P2: Taylor; D: Degree := Size) return Taylor is --FINE
     Pt: Taylor;
  begin
     Prod(R,P1,P2,Pt,D);
     return Pt;
  end Prod;


  function DerVal(N: Integer; R1,R2: Radius; Z: Comp; P: Taylor) return Comp is --FINE
     S,SS: Comp;
     G: Comp:=Z;
     GP: Comp:=Complecs(One,Zero);
     Mu: Scalar:=Scal(R2)/Scal(R1);
     LMu : Scalar:=Log(Mu);
     X2: constant Scalar:=(-One)/LMu;
     C2: constant Scalar:=X2*Exp(Scal(-One));
  begin
     if R2>=R1 then
        Message("Taylors.Ops.DerVal",Domain_Violation);
     end if;

     --(f o g(z))'=f'(g(z))*g'(z)
     for I in 1..N loop
        if SupMod(G)>R2 and not Trunc then
           Message("Taylors.Ops.DerVal",Domain_Violation);
        end if;
        S:= Complecs(Zero,Zero);
        SS:= Complecs(Zero,Zero);
        for K in reverse 1 .. Deg(P) loop
           SS := G*SS+Rep(K)*P.C(K);
           S := G*S+P.C(K);
        end loop;
        S:=G*S+P.C(0);
        if  not Trunc then
           S:=S+G*Ball0(P.E);
           SS:=SS+Ball0(P.E)+C2*Ball0(P.E)*G/R2;
        end if;
        G:=S;
        GP:=GP*SS;
     end loop;
     return GP;
  end DerVal;


  function DerDerVal(N: Integer; R1,R2: Radius; Z: Comp; P: Taylor) return Comp is --FINE
     S,SS,SSS: Comp;
     G: Comp:=Z;
     GP: Comp:=Complecs(One,Zero);
     GDP: Comp:=Complecs(Zero,Zero);
     Mu: Scalar:=Scal(R2)/Scal(R1);
     LMu : Scalar:=Log(Mu);
     X2: constant Scalar:=(-One)/LMu;
     C2: constant Scalar:=X2*Exp(-Scal(One));
     X3: constant Scalar:=Half*(Scal(One)-Scal(Two)/LMu+Sqrt(Scal(Four)/abs(LMu)+Scal(One)));
     C3:  Scalar:=X3*(X3-Scal(One))*Exp(X3*LMu);
     X4: constant Scalar:=Half*(Scal(One)-Scal(Two)/LMu-Sqrt(Scal(Four)/abs(LMu)+Scal(One)));
     C4:  Scalar:=X4*(X4-Scal(One))*Exp(X4*LMu);
  begin
     if Sup(C4)>Sup(C3) then
        C3:=C4;
     end if;
     if R2>=R1 then
        Message("Taylors.Ops.DerDerVal",Domain_Violation);
     end if;

     --(f o g(z))''=f''(g(z))*(g'(z))^2+f'(g(z)*g''(z)
     for I in 1..N loop
        if SupMod(G)>R2 and not Trunc then
           Message("Taylors.Ops.DerDerVal",Domain_Violation);
        end if;
        S:= Complecs(Zero,Zero);
        SS:= Complecs(Zero,Zero);
        SSS:= Complecs(Zero,Zero);
        for K in reverse 2 .. Deg(P) loop
           SSS:=G*SSS+Rep(K)*Rep(K-1)*P.C(K);
           SS := G*SS+Rep(K)*P.C(K);
           S := G*S+P.C(K);
        end loop;
        S:=G*(G*S+P.C(1))+P.C(0);
        SS:=G*SS+P.C(1);
        if  not Trunc then
           S:=S+G*Ball0(P.E);
           SS:=SS+C2*Ball0(P.E)*G/R2+Ball0(P.E);
           SSS:=SsS+(C3*Ball0(P.E)*G/R2)/R2+C2*Ball0(P.E)/R2;
        end if;
        GDP:=SSS*GP*GP+SS*GDP;
        G:=S;
        GP:=GP*SS;
     end loop;
     return GDP;
  end DerDerVal;


  procedure Fmax1(R: in Rep; M: out Natural; F: out Rep) is --NOT FINE
     X: constant Rep := One/(-Log(R));
  begin
     M := Integer(Rep'Ceiling(X));
     F := X*Exp(-One);
  end Fmax1;

  procedure Der(R1,R2: in Radius; P1: in Taylor; P2: out Taylor; IsPoly: in Boolean := False) is --NOT FINE
     --  error in P1.C(Dho) effectively doubles, but degree info is kept
     -- generally P2.C(Dho)=Rep(Dho+1)*P1.C(Dho+1) with the radius complemented by a reweighted norm of P1.C(Dho+1) - contribution of non-homogeneous terms.
     D1: Integer;
  begin
     SetZero(P2);
     D1:=Deg(P1);
     if D1<0 then SetDeg(-1,P2); return; end if;
     SetDeg(Deg(P1)-1,P2);
     for K in 1 .. D1 loop
        SetComponent(K-1,Rep(K)*P1.C(K),P2);
     end loop;
     if Trunc then return; end if;
     P2.E := Zero;
     if IsPoly then return; end if;
     if R2>=R1 then
        Message("Taylors.Ops.Der",Domain_Violation);
     end if;
     declare
        Ri: constant Rep := R1/R2;
        M: Natural;
        F: Rep;
     begin

        Fmax1(R2/R1,M,F);
        P2.E := P1.E*F/R2;-- FINE, z*g'(z)
        if P1.D <Dho then -- no high order errors
           return;
        end if;
        for K in Dho..P2.D loop
           AddComponent(K,F*ResetCenter(P1.C(K))/R2,P2);
        end loop;
        AddComponent(P2.D,F*ResetCenter(P1.C(D1)),P2);
     end;
  end Der;


  function Der(R1,R2: Radius; P: Taylor; IsPoly: in Boolean := False) return Taylor is --FINE
     Pt: Taylor;
  begin
     Der(R1,R2,P,Pt,IsPoly);
     return Pt;
  end Der;


  procedure Newton(N: in Integer; Rho: in Radius; P: in out Comp; Tay: in Taylor; E: in Comp; IsPoly: in Boolean:=False) is --FINE
                                                                                                                            --solves Tay(Z)=E
     Eps: Rep;
     DeV,C1,C2,Epsilon0,M,M0: Comp;
     Err,R: Rep;
     I: Integer:=1;
  begin

     Err:=Rep(1.0E-15);
     <<AGAIN>> Eps:=Rep(1.0E+100);
     --Approximation
     while Eps > Err loop
        C1:=ResetErr(P);
        C2:=CompOne;
        R:=SupMod(C1)+Rep(1.0E-3);
        --for K  in 1..N loop
        C2:=ResetErr(DerVal(N,Rho,R,C1,Tay)*C2);
        C1:=ResetErr(Val(N,R,C1,Tay));
        --end loop;
        C1:=(ResetErr(E)-ResetErr(C1))/ResetErr(C2);
        Eps:=SupMod(ResetErr(C1));
        P:=ResetErr(P+C1);
     end loop;
     if Trunc then return; end if;
     --Bound on Epsilon0
     R:=SupMod(P);
     DeV:=DerVal(N,Rho,R,P,Tay);
     Epsilon0:=(E-Val(N,R,P,Tay))/DeV;
     M0:=Epsilon0/DeV;
     --Bound on the solution
     P:=P+Epsilon0;
     P:=P+SetBall(CompZero,SupMod(Epsilon0));
     --Kantorovich inequality
     R:=SupMod(P);
     M:=DerDerVal(N,Rho,R,P,Tay);
     if SupMod(M0*M)>Half then
        New_Line;
        Put("Kantorovich criterion=");Txt_Put(Current_Output,SupMod(M0*M));
        Err:=Rep(0.1)*Err;
        if I>100 then
           Message("Taylors.Newton",Giving_Up);
        end if;
        I:=I+1;
        New_Line;Put("Continuing the Newton...");
        goto AGAIN;
     end if;
  end Newton;


  procedure Compose(P1,P2: in Taylor; P3: out Taylor) is
     R3: constant Radius := One;          --- arbitrary
     D1: Degree;
  begin
     if not Trunc then
        P3.E :=Zero;
        Message("Taylors.Ops.Comp",Numeric_Only);
     end if;
     if P1.D <= 0 then
        Copy(P1,P3);
     else
        D1:=EffDeg(P1);
        Prod(P1.C(D1),P2,P3);
        AddComponent(0,P1.C(D1-1),P3);
        for I in reverse 0..D1-2 loop
           Mult(R3,P2,P3);
           AddComponent(0,P1.C(I),P3);
        end loop;
     end if;
  end Compose;

  function Compose(P1,P2: Taylor) return Taylor is
     Pt: Taylor;
  begin
     Compose(P1,P2,Pt);
     return Pt;
  end Compose;

end Taylors.Ops;
