with Ada.Text_IO, Reps,Reps.Ops, Reps.IO;
use Ada.Text_IO, Reps,Reps.Ops, Reps.IO;
with Taylors, Taylors.Ops, Taylors.IO;
with Round_Up;
with Ada.Strings.Unbounded;
pragma Elaborate_All (Ada.Text_IO, Taylors.Ops, Taylors.IO);

generic

   Pdeg: in Positive;
   Dho: in Natural;
   type Scalar is private;
   type Comp is private;


   --intervals
   with function IsNumeric(S: Scalar) return Boolean is <>;
   with function Scal(K: Integer) return Scalar is <>;
   with function Scal(R: Rep) return Scalar is <>;
   with function Err0(S: Scalar) return Boolean is <>;
   with function Err(S: Scalar) return Rep is <>;
   with function Approx(S: Scalar) return Rep is <>;
   with function "-"(S: Scalar) return Scalar is <>;
   with function Center(S: Scalar) return Scalar is <>;
   with procedure ResetCenter(S: in out Scalar) is <>;
   with function ResetCenter(S: Scalar) return Scalar is <>;

   with function Scal(R1,R2: Rep) return Scalar is <>;
   with function Ball(S: Scalar) return Scalar is <>;
   with function Ball(S: Rep) return Scalar is <>;
   with function Inf(S: Scalar) return Rep is <>;
   with function Sup(S: Scalar) return Rep is <>;
   with function SupAbs(S: Scalar) return Rep is <>;
   with function "<"(S1,S2: Scalar) return Boolean is <>;
   with function IntFloor(S: Scalar) return Integer is <>;
   with function IntCeiling(S: Scalar) return Integer is <>;
   with function "abs"(S: Scalar) return Scalar is <>;
   with function Min(S1,S2: Scalar) return Scalar is <>;
   with function Max(S1,S2: Scalar) return Scalar is <>;
   with function Cap(R: Radius; S: Scalar) return Scalar is <>;
   with function Up(R: Rep; Dummy: Scalar) return Rep is <>;
   with procedure ErrMult(R: in Rep; S: in out Scalar) is <>;

   with function "+"(S,T: Scalar) return Scalar is <>;
   with function "-"(S,T: Scalar) return Scalar is <>;
   with function "*"(R: Rep; S: Scalar) return Scalar is <>;
   with function "*"(S: Scalar; R: Rep) return Scalar is <>;
   with function "*"(S,T: Scalar) return Scalar is <>;
   with function "/"(S: Scalar; R: Rep) return Scalar is <>;
   with function "/"(R: Rep; S: Scalar) return Scalar is <>;
   with function "/"(S,T: Scalar) return Scalar is <>;
   with function Sqr(S: Scalar) return Scalar is <>;
   with function Inv(S: Scalar) return Scalar is <>;
   with function "**"(S: Scalar; I: Integer) return Scalar is <>;
   with function Short_Exp(R: Scalar; Iter: Integer) return Scalar is <>;

   with function MinusPi_Pi(S: Scalar) return Scalar is <>;
   with function Cosh(S: Scalar) return Scalar is <>;
   with function Sinh(S: Scalar) return Scalar is <>;
   with function Sin(S: Scalar) return Scalar is <>;
   with function Cos(S: Scalar) return Scalar is <>;
   with function Exp(S: Scalar) return Scalar is <>;
   with function Log(S: Scalar) return Scalar is <>;
   with function Sqrt(S: Scalar) return Scalar is <>;
   with procedure CosSin(S: in Scalar; Sc,Ss: out Scalar) is <>;

   with procedure Show(S: in Scalar; NewLine: in Boolean := True) is <>;
   with procedure Get(F: in File_Type; S: out Scalar; Decimal: in Boolean := True) is <>;
   with procedure Put(F: in File_Type; S: in Scalar; Decimal: in Boolean := True) is <>;

   --balls

   with function RePart(C: Comp) return Scalar is <>;
   with function ImPart(C: Comp) return Scalar is <>;
   with function Conj(C: Comp) return Comp is <>;
   with function SetBall(C: Comp;R: Rep:=Zero) return Comp is <>;
   with function IsCoNumber(S: Comp) return Boolean is <>;
   with function IsBall(S: Comp) return Boolean is <>;
   with function Complecs(Re,Im: Rep) return Comp is <>;
   with procedure ResetCenter(S: in out Comp) is <>;
   with function ResetCenter(S: Comp) return Comp is <>;
   with procedure Split(S: in Comp; Sr,Se: out Comp) is <>;
   with procedure ResetErr(S: in out Comp) is <>;
   with function ResetErr(S: Comp) return Comp is <>;
   with function CenterBall(S: Comp) return Comp is <>;
   with function Ball0(R: Rep) return Comp is <>;
   with function Ball0(R: Comp) return Comp is <>;
   with function ErrPart(S: Comp) return Rep is <>;

   with function InfRe(S: Comp) return Rep is <>;
   with function SupRe(S: Comp) return Rep is <>;
   with function InfIm(S: Comp) return Rep is <>;
   with function SupIm(S: Comp) return Rep is <>;
   with function SupMod(S: Comp) return Rep is <>;
   with function InfMod(S: Comp) return Rep is <>;
   with function AbsBall(S: Comp) return Comp is <>;
   with function AbsVal(S: Comp) return Scalar is <>;
   with function Arg(C: Comp) return Scalar is <>;
   with procedure ErrMult(R: in Rep; S: in out Comp) is <>;
   with function Neg(S: Comp) return Comp is <>;
   with procedure RandomBall(Seed: in out Long_Integer; S: out Comp) is <>;

   with function Contains(S: Comp; C: Comp) return Boolean is <>;
   with function Intersects(S: Comp; T: Comp) return Boolean is <>;
   with function SetBall(R1,R2: Scalar) return Comp is <>;
   with function "+"(S,T: Comp) return Comp is <>;
   with function "-"(S,T: Comp) return Comp is <>;
   with function "*"(R: Rep; S: Comp) return Comp is <>;
   with function "/"(S: Comp; R: Rep) return Comp is <>;
   with function "*"(R: Scalar; S: Comp) return Comp is <>;
   with function "/"(S: Comp; R: Scalar) return Comp is <>;
   with function Sqr(S: Comp) return Comp is <>;
   with function "*"(S,T: Comp) return Comp is <>;
   with function Inv(S: Comp) return Comp is <>;
   with function Long_Inv(S: Comp) return Comp is <>;
   with function "/"(S,T: Comp) return Comp is <>;
   with function "**"(S: Comp; I: Integer) return Comp is <>;
   with function Cap(R: Radius; S: Comp) return Comp  is <>;
   with function MaxMod(S1,S2: Comp) return Comp is <>;

   with function Cosh(S: Comp) return Comp is <>;
   with function Sinh(S: Comp) return Comp is <>;
   with function Exp(S: Comp) return Comp is <>;
   with function EiExp(S1,S2: Comp; NumErr: Rep:=Rep(1.0E-15)) return Comp is <>;
   with function Cos(S: Comp) return Comp is <>;
   with function Sin(S: Comp) return Comp is <>;
   with function Log(S: Comp) return Comp is <>;
   with function Sqrt(S: Comp) return Comp is <>;
   --   with function PiBall return Comp is <>;

   with procedure Show(S: in Comp; Cut: in Rep:=Zero) is <>;
   with procedure Get(F: in File_Type; S: out Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is <>;
   with procedure Put(F: in File_Type; S: in Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is <>;

package RG_Ops is

   package RG_Tay is new Taylors (Pdeg,Dho,Comp,Scalar);
   package RG_Tay_Ops  is new RG_Tay.Ops;
   package Rg_Tay_IO is new RG_Tay.IO;
   use RG_Tay, RG_Tay_Ops,RG_Tay_IO;

   type RepArray is array (Integer range <>) of Rep;
   type ScalArray is array (Integer range <>) of Scalar;
   type RepMatrix is array (Integer range <>, Integer range <>) of Rep;
   type ScalMatrix is array (Integer range <>, Integer range <>) of Scalar;
   type CompArray is array (Integer range <>) of Comp;
   type CompMatrix is array (Integer range <>, Integer range <>) of Comp;


   --SOME LINEAR ALGEBRA PROCEDURES
   function "-"(B: CompArray) return CompArray;
   function Scal(R: RepArray) return ScalArray;--converts a rep array into a scalar array
   function "+"(B1,B2: CompArray) return CompArray;
   function "*"(C: Comp;B: CompArray) return CompArray;
   function "+"(A1,A2: in CompMatrix) return CompMatrix;
   function "-"(B1,B2: CompArray) return CompArray;
   function "-"(A1,A2: in CompMatrix) return CompMatrix;
   procedure DevelopInBasis(Rho: in Radius; P: in Taylor; A: out CompArray); --Develops a poplynomial in the basis e_j

   procedure SetZero(B: out CompArray);
   procedure SetZero(B: out ScalArray);
   procedure SetZero(A: out CompMatrix);
   procedure  PointsProdAdd(M: in CompMatrix; H: in out CompMatrix);--H=M*(H+1) pointwise
   procedure  ProdAdd(Pex: in Rep; Ro: in ScalArray; M: in CompMatrix; H: in out CompMatrix; PLpError: out Scalar);-- H=M*(H+1), PLpError=||trunc[M*(H+1)]-M*(H+1)||^p_p
   procedure  ProdAdd(M: in CompMatrix; H: in out CompMatrix);--H=M*(H+1) as Fourier series
   function NormInf(B: CompArray) return Rep; --returns an upper bound on \|B\|_infty
   function RoughLpNorm(Pex: Rep; Ro: ScalArray; B: CompMatrix) return Scalar;--returns a bound on \|B\|_p
   function UpperBoundLpNorm(Pex: Rep; Ro: ScalArray; B: CompMatrix) return Scalar; --returns an upper bound on \|B \|_p
   function EssSup(B: CompMatrix) return Scalar;--returns a bound on the esssup(B)
   procedure EssSup(B: in CompMatrix; E: out ScalArray);--E is the array of bounds of the ess sups of rows of B
   function RoughEssSup(B: CompMatrix) return Scalar;--essup(B) <= max_i sum_j |B_(i,j)|


   --SOME FFT ROUTINES
   procedure Glassman (A, B, C:   in  Integer; Data_Vector:   in out CompArray ;Inverse_Transform  :   in  Boolean:=False);--Glassman algorithm
   procedure FFT (FFT_Data:  in out CompArray; Inverse_Transform: in   Boolean:=False   );--FFT for a row
   procedure FT(H: in out CompMatrix; Inverse_Transform: in   Boolean:=False );--FFT for an array
   procedure FT_Mod(H: in out CompMatrix; Inverse_Transform: in   Boolean:=False );--FFT for the first machine


   --ROUTINES RELATED TO THE CONSTRUCTION OF THE FUNDAMENTAL CRESCENT
     function Tau(C: Comp) return Comp;--tau
   function TauInv(C: Comp) return Comp;--inverse tau
   procedure Parametrize_1(R: in Scalar; C:  out Comp; Der,RDer: out Comp);--Parametrization C(r) of one side of the fundamental crescent, Der=C'(r),RDer=r*C'(r)
   procedure Parametrize_2(R: in Scalar; C,Der,RDer,RDerDer,CC,DDer,RRDer,RRDerDer: out Comp);--Parametrization C(r) of one side of the fundamental crescent, Der=C'(r),RDer=r*C'(r),RDerDer=r*C''(r),RRDerDer=r^2*C''(r)
   procedure SInvH1(N: in Integer; FCAppr, Appr,C: in out Comp; Tay: in Taylor; Er: in Radius; IsPoly: in Boolean:=True);--inverse g_1
   function SH1(N: Integer; Appro: Comp; X,Y: Scalar; Tay: Taylor; IsPoly: Boolean:=True) return Comp;--g_1
   procedure GetRow(Num_Of_Machines: in Integer;
                    ThickRad: in ScalArray;
                    Input_File: in String;
                    C: in Comp;
                    Row: out CompArray;
                    Brackets: in Boolean:=False;
                    Decimal: in Boolean := True;
                    ShowErr: in  Boolean:=True);--gets a row for C from the solution of the Beltrami equation saved in Input_File.
   function G_Value(Pex: in Rep;
                    R,AEP,C: in Scalar;
                    V: in CompArray;
                    Val_At_Zero, Z: in Comp) return Comp; --g(Z),  V is the row from the solution of the Beltrami equation obtained in GetRow
   function G_Value(Pex: in Rep; R,AEP,C: in Scalar; V: in CompArray; Val_At_Zero: in Comp; Rad,Psi: in Scalar) return Comp;
   function ExpInv(C: in Comp) return Comp;--g(Rad*exp[I*Psi]

   --ROUTINES RELATED TO THE BELTRAMI EQUATUION
   procedure BeltramiF(Qn: in Integer; NumErr: in Rep; ThickRad: in ScalArray; Tay: in Taylor;Coeffs: out CompMatrix;IsPoly: in Boolean:=True);--forms the Beltrami differential, used on the first machine only
   procedure Beltrami(Qn: in Integer; NumErr: in Rep; ThickRad: in ScalArray; Tay: in Taylor;Coeffs: out CompMatrix;IsPoly: in Boolean:=True);--forms the Beltrami differential, used on all machines>1

   --Hilbert transforms for a linear data
   procedure Lin_T_Transform1(Iter: in Integer; R: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);--first machine
   procedure Lin_T_Transform2(Iter: in Integer; R: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);--other than first or last
   procedure Lin_T_Transform3(Iter: in Integer; R: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);--last machine

   --Hilbert transforms for a constant data
   procedure Const_T_Transform1(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Const_T_Transform2(Iter: in Integer; R,Ro,ThickR: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Const_T_Transform3(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);

   --Cauchy transforms for a linear data
   procedure Lin_P_Transform1(Iter: in Integer; Rad: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Lin_P_Transform2(Iter: in Integer; Rad: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Lin_P_Transform3(Iter: in Integer; Rad: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);

   --Cauchy transforms for a constant data
   procedure Const_P_Transform1(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Const_P_Transform2(Iter: in Integer; R,Ro,ThickR: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure Const_P_Transform3(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);

   procedure  Iter_Fixed_Point(Pex: in Rep; N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer;--h_(i+1)=T[mu*(h_i+1)], h_0=0
                                            F: in out CompMatrix;
                                            Rad: in ScalArray;
                                            ThickRad: in ScalArray;
                                            Ro: in ScalArray;
                                            Center: in Comp;
                                            Out_Dir: in String;
                                            Text_Output: in Boolean;
                                            Brackets: in Boolean:=False;
                                            Decimal: in Boolean := True;
                                            ShowErr: in  Boolean:=True);
   procedure  Iter_Cauchy(Pex: in Rep;N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer; --F=P[mu*(h+1)]+id
                                      F: out CompMatrix;
                                      FouErr: out Scalar;
                                      Rad: in ScalArray;
                                      ThickRad: in ScalArray;
                                      Ro: in ScalArray;
                                      Out_Dir: in String;
                                      Text_Output: in Boolean;
                                      Brackets: in Boolean:=False;
                                      Decimal: in Boolean := True;
                                      ShowErr: in  Boolean:=True);
   procedure  Iter_Approx_Sol(N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer;
                              Iter: in out Integer;
                              Belt: in out CompMatrix;
                              F:  out CompMatrix;
                              Rad: in ScalArray;
                              ThickRad: in ScalArray;
                              Ro: in ScalArray;
                              Center: in Comp;
                              Con_File,Out_Dir: in String;
                              Read_Approx: in Boolean;
                              Write_H: in Boolean;
                              Brackets: in Boolean:=False;
                              Decimal: in Boolean := True;
                              ShowErr: in  Boolean:=True);



   --REGULAR READ AND WRITE PROCEDURES
   procedure   Read_Integer(F_Name: in String; I: out Integer);
   procedure   Read_Int(F_Name: in String; I: out Integer);
   procedure   Read_Vector(F_Name: in String; V: out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure   Read_Vec(F_Name: in String; V: out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);


   --PARALLEL READ AND WRITE PROCEDURES
   procedure   Read(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure   Read_B(Write_Log,Comp_Read: in String; V: out Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure   Read_T(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure   Read_P(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Read_SB(H: out CompMatrix; File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Read_Part(H: out CompMatrix; File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Read_Renorm(H: out CompMatrix; N: in Integer;  File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Write(I: in Integer; Read_Log,Write_Log,Vec_Write: in String; V: in CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Write_B(Write_Log, Comp_Write: in String; V: in Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Write_T(I: in Integer; Read_Log,Write_Log, Vec_Write: in String; V: in CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);
   procedure  Write_SB(H: in CompMatrix; File_Name: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True);

   ScalPi: constant Scalar:= Scal(Rep(3.14159_26535_89793_23),Rep(3.14159_26535_89793_24));
   ScalZero:  constant Scalar:=Scal(Zero);
   ScalOne:  constant Scalar:=Scal(One);
   ScalTwo:  constant Scalar:=Scal(Two);
   ScalTheta:  constant Scalar:=Scal(Rep(6.18033988749894848E-001));
   CoZero: constant Comp:=Complecs(Zero,Zero);
   CoOne: constant Comp:=Complecs(One,Zero);
   CoTwo: constant Comp:=Complecs(Two,Zero);
   Theta: constant Comp:=Complecs(Rep(6.18033988749894848E-001),Zero);
   IBall: constant Comp:=Complecs(Zero,One);
   PiBall: constant Comp:=SetBall(ScalPi,ScalZero);
   NegIBall: constant Comp:=Complecs(Zero,-One);
   ITheta: constant Comp:=Complecs(Zero,Rep(6.18033988749894848E-001));
   ThetaSqr: constant Comp:=Sqr(Theta);
   IThetaSqr: constant Comp:=IBall*ThetaSqr;
   NumPi: constant Comp:=Complecs(Pi,Zero);
   NumIPi: constant Comp:=Complecs(Zero,Pi);
   TwoPiI: constant Comp:=Two*Complecs( Zero,Pi);
   TwoPi: constant Comp:=Two*Complecs(Pi,Zero);
   ExpTheta: constant Comp:=ResetErr(Exp(Two*(NumPi*ITheta)));
   ExpThetaSqr: constant Comp:=Sqr(ExpTheta);
   CrPoint: constant Comp:=(-Half)*ExpTheta;
   EX: Integer:=0;
   LogB,LogBB,Cn2,Cn2n,P, LogBPow,LogBBPow,Cn2Pow,Cn2nPow,PPow,PN,Twist,TayCenter: Comp;
   Pow,Rho: Rep;
   LogA,LogAPow: Scalar;
   Qn: Integer;
   Quad: Boolean;
private
   Trunc: constant Boolean := (IsNumeric(ScalZero) and IsCoNumber(CoZero));

end RG_Ops;
