with Messages,  Ada.Text_IO,Ada.Integer_Text_IO,Ada.IO_Exceptions,Intervals.IO, Ada.Real_Time, Ada.Calendar, Ada.Strings.Unbounded;
use Messages, Ada.Text_IO,Ada.Integer_Text_IO, Ada.Strings.Unbounded;

pragma Elaborate_All (Messages);
package body RG_Ops is

   pragma Suppress(Storage_Check);

   function IMin(I1,I2: Integer) return Integer renames Integer'Min;
   function IMax(I1,I2: Integer) return Integer renames Integer'Max;
   pragma Inline (Imin,Imax);
   pragma Suppress(Storage_Check);


   -- SOME LINAR ALGEBRA PROCEDURES
   function "-"(B: CompArray) return CompArray is
      Bt: CompArray(B'Range);
   begin
      for I in B'Range loop
         Bt(I) := Neg(B(I));
      end loop;
      return Bt;
   end "-";


   function Scal(R: RepArray) return ScalArray is
      S: ScalArray(R'Range);
   begin
      for I in R'Range loop
         S(I):=Scal(R(I));
      end loop;
      return S;
   end Scal;


   function "+"(B1,B2: CompArray) return CompArray is
      B: CompArray(B2'Range);
   begin
      for I in B'Range loop
         B(I) := B2(I)+B1(I);
      end loop;
      return B;
   end "+";


   function "*"(C: Comp; B: CompArray) return CompArray is
      A: CompArray(B'Range);
   begin
      for I in B'Range loop
         A(I) := C*B(I);
      end loop;
      return A;
   end "*";


   function "+"(A1,A2: in CompMatrix) return CompMatrix is
      A: CompMatrix(A2'Range(1),A2'Range(2));
   begin
      for I in A'Range(1) loop
         for J in A'Range(2) loop
            A(I,J) := A2(I,J)+A1(I,J);
         end loop;
      end loop;
      return A;
   end "+";


   function "-"(B1,B2: CompArray) return CompArray is
      B: CompArray(B2'Range);
   begin
      for I in B'Range loop
         B(I) := B2(I)-B1(I);
      end loop;
      return B;
   end "-";


   function "-"(A1,A2: in CompMatrix) return CompMatrix is
      A: CompMatrix(A2'Range(1),A2'Range(2));
   begin
      for I in A'Range(1) loop
         for J in A'Range(2) loop
            A(I,J) := A2(I,J)-A1(I,J);
         end loop;
      end loop;
      return A;
   end "-";


   procedure DevelopInBasis(Rho: in Radius; P: in Taylor; A: out CompArray) is --FINE
      Tmp,E: Taylor;
      C: Comp;
      Nr: Rep;
   begin
      Copy(P,Tmp);
      for I in 1..A'First-1 loop
         SetZero(E);
         SetComponent(I,CoOne,E);
         SetComponent(I+1,Neg(Complecs(Rep(I),Zero))/Rep(I+1),E);
         Nr:=Norm(Rho,E);
         E:=CoOne/Nr*E;
         C:=Nr*Component(I,Tmp);
         Tmp:=Tmp-C*E;
      end loop;

      for I in A'Range loop
         SetZero(E);
         SetComponent(I,CoOne,E);
         SetComponent(I+1,Neg(Complecs(Rep(I),Zero))/Rep(I+1),E);
         Nr:=Norm(Rho,E);
         E:=CoOne/Nr*E;
         A(I):=Nr*Component(I,Tmp);
         Tmp:=Tmp-A(I)*E;
      end loop;
   end DevelopInBasis;


   function NormInf(B: CompArray) return Rep is
      R: Rep;
   begin
      R := Zero;
      for I in B'Range loop
         if SupMod(B(I))>R then
            R:=SupMod(B(I));
         end if;
      end loop;
      return R;
   end NormInf;


   procedure SetZero(B: out CompArray) is
   begin
      for I in B'Range loop
         B(I) :=Complecs(Zero,Zero);
      end loop;
   end SetZero;


   procedure SetZero(B: out ScalArray) is
   begin
      for I in B'Range loop
         B(I) :=ScalZero;
      end loop;
   end SetZero;


   procedure SetZero(A: out CompMatrix) is
      pragma Suppress(Storage_Check);
   begin
      for I in A'Range(1) loop
         for J in A'Range(2) loop
            A(I,J) := Complecs(Zero,Zero);
         end loop;
      end loop;
   end SetZero;


   procedure  PointsProdAdd(M: in CompMatrix; H: in out CompMatrix)  is
   begin
      for I in M'Range(1) loop
         for J in M'Range(2) loop
            H(I,J):=M(I,J)*H(I,J)+M(I,J);
         end loop;
      end loop;
   end PointsProdAdd;


   procedure  ProdAdd(Pex: in Rep; Ro: in ScalArray; M: in CompMatrix; H: in out CompMatrix; PLpError: out Scalar)  is
      K1: constant Integer:=M'First(2);
      K2: constant Integer:=M'Last(2);
      RoDiff,EssSup,L2Sum: Scalar;
      EE: Comp;
      C: CompArray(H'Range(2));
   begin
      PLpError:=ScalZero;
      EssSup:=ScalZero;
      RoDiff:=ScalPi*(Ro(M'First(1))-Ro(M'First(1)-1))*(Ro(M'First(1))+Ro(M'First(1)-1));
      L2Sum:=ScalZero;
      if not Trunc then
         for J in 2*K1..K1-1 loop
            --Computing the J-th coeeficient of xi
            EE:=CoZero;
            for L in IMax(K1,J-K2).. IMin(K2,J-K1) loop
               EE:=EE+H(M'First(1),L)*M(M'First(1),J-L);
            end loop;
            EssSup:=EssSup+AbsVal(EE);
            L2Sum:=L2Sum+Sqr(AbsVal(EE));
         end loop;
      end if;

      for J in K1..K2 loop
         C(J):=CoZero;
         for K in IMax(J-K2,K1)..IMin(J-K1,K2) loop
            C(J):=C(J)+H(M'First(1),J-K)*M(M'First(1),K);
         end loop;
      end loop;

      if not Trunc  then
         for J in K2+1..2*K2 loop
            --Computing the J-th coeeficient of xi
            EE:=CoZero;
            for L in IMax(K1,J-K2).. IMin(K2,J-K1) loop
               EE:=EE+H(M'First(1),L)*M(M'First(1),J-L);
            end loop;
            EssSup:=EssSup+AbsVal(EE);
            L2Sum:=L2Sum+Sqr(AbsVal(EE));
         end loop;
         PLpError:=PLpError+ScalPi*Exp((Pex-Two)*Log(Scal(Sup(EssSup))))*RoDiff*L2Sum;
      end if;

      --I>M'First(1)
      for I in M'First(1)+1..M'Last(1) loop
         EssSup:=ScalZero;
         RoDiff:=ScalPi*(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
         L2Sum:=ScalZero;
         if not Trunc then
            for J in 2*K1..K1-1 loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(K1,J-K2).. IMin(K2,J-K1) loop
                  EE:=EE+H(I,L)*M(I,J-L);
               end loop;
               EssSup:=EssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
         end if;

         for J in K1..K2 loop
            H(I-1,J):=C(J)+M(I-1,J);
            C(J):=CoZero;
            for K in IMax(J-K2,K1)..IMin(J-K1,K2) loop
               C(J):=C(J)+H(I,J-K)*M(I,K);
            end loop;
         end loop;

         if not Trunc  then
            for J in K2+1..2*K2 loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(K1,J-K2).. IMin(K2,J-K1) loop
                  EE:=EE+H(I,L)*M(I,J-L);
               end loop;
               EssSup:=EssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
            PLpError:=PLpError+ScalPi*Exp((Pex-Two)*Log(Scal(Sup(EssSup))))*RoDiff*L2Sum;
         end if;
      end loop;
      for J in K1..K2 loop
         H(H'Last(1),J):=C(J)+M(H'Last(1),J);
      end loop;
   end ProdAdd;


   procedure  ProdAdd(M: in CompMatrix; H: in out CompMatrix)  is
      K1: constant Integer:=M'First(2);
      K2: constant Integer:=M'Last(2);
      C1: CompArray(M'Range(2));
   begin
      for I in M'Range(1) loop
         for J in K1..K2 loop
            if I>M'First(1) then
               H(I-1,J):=C1(J)+M(I-1,J);
            end if;
            C1(J):=CoZero;
            for K in IMax(J-K2,K1)..IMin(J-K1,K2) loop
               C1(J):=C1(J)+H(I,J-K)*M(I,K);
            end loop;
         end loop;
      end loop;
      for J in K1..K2 loop
         H(H'Last(1),J):=C1(J)+M(H'Last(1),J);
      end loop;
   end ProdAdd;


   function RoughLpNorm(Pex: Rep; Ro: ScalArray; B: CompMatrix) return Scalar is
      L2Norm,EssSup,EsSup,L2Sum,RadDiff,LpNorm,LqNorm: Scalar;
      II: Integer;
      L,R: Rep;
      Qex: constant Scalar:=Scal(Pex)/(Pex-One);
   begin
      EsSup:=ScalZero;
      L2Norm:=ScalZero;
      if (Ro'First+1)/=B'First(1) then
         II:=B'First(1);
      else
         EsSup:=AbsVal(B(B'First(1),0));
         L2Norm:=L2Norm+ScalPi*(Ro(B'First(1))-Ro(B'First(1)-1))*(Ro(B'First(1))+Ro(B'First(1)-1))*Sqr(AbsVal(B(B'First(1),0)));
         II:=  B'First(1)+1;
      end if;
      for I in II..B'Last(1) loop
         RadDiff:=ScalPi*(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
         L2Sum:=ScalZero;
         EssSup:=ScalZero;
         for J in B'Range(2) loop
            EssSup:=EssSup+AbsVal(B(I,J));
            --L2 norm
            L2Sum:=L2Sum+Sqr(AbsVal(B(I,J)));
         end loop;
         L2Norm:=L2Norm+L2Sum*RadDiff;
         if Sup(EssSup)>Sup(EsSup) then
            EsSup:=EssSup;
         end if;
      end loop;
      LpNorm:=Exp((Scal(Pex)-ScalTwo)*Log(Scal(Sup(EsSup)))/Pex)*Exp(Log(Scal(Sup(L2Norm)))/Pex);
      LqNorm:=Exp((Qex-ScalTwo)*Log(Scal(Sup(EsSup)))/Qex)*Exp(Log(Scal(Sup(L2Norm)))/Qex);
      R:=Sup(LpNorm);
      L:=Inf(L2Norm/LqNorm);
      return Scal(L,R);
   end RoughLpNorm;


   function UpperBoundLpNorm(Pex: Rep; Ro: ScalArray; B: CompMatrix) return Scalar is
      L2Norm,EssSupR,EsSupR: Scalar;
      II: Integer;
      L2Sum,RadDiff: Scalar;
      Qex: constant Scalar:=Scal(Pex)/(Pex-One);
   begin
      EsSupR:=ScalZero;
      L2Norm:=ScalZero;
      if (Ro'First+1)/=B'First(1) then
         II:=B'First(1);
      else
         EsSupR:=AbsVal(B(B'First(1),0));
         L2Norm:=L2Norm+ScalPi*(Ro(B'First(1))-Ro(B'First(1)-1))*(Ro(B'First(1))+Ro(B'First(1)-1))*Sqr(AbsVal(B(B'First(1),0)));
         II:=  B'First(1)+1;
      end if;
      for I in II..B'Last(1) loop
         RadDiff:=ScalPi*(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
         L2Sum:=Sqr(AbsVal(B(I,0)));
         EssSupR:=AbsVal(B(I,0));
         for J in 1..B'Last(2) loop
            EssSupR:=EssSupR+AbsVal(B(I,J));
            --L2 norm
            L2Sum:=L2Sum+Sqr(AbsVal(B(I,J)));
         end loop;
         for J in reverse -1..B'First(2) loop
            EssSupR:=EssSupR+AbsVal(B(I,J));
            --L2 norm
            L2Sum:=L2Sum+Sqr(AbsVal(B(I,J)));
         end loop;
         L2Norm:=L2Norm+L2Sum*RadDiff;
         if Sup(EssSupR)>Sup(EsSupR) then
            EsSupR:=EssSupR;
         end if;
      end loop;
      return Exp((Scal(Pex)-ScalTwo)*Log(Sup(EsSupR))/Pex)*Exp(Log(Sup(L2Norm))/Pex);
   end UpperBoundLpNorm;


   function EssSup(B: CompMatrix) return Scalar is
      --MM is the number of angles on which the esssup is evaluated.
      --N2 and N1 are the cut-off for the coefficients in the Fourier series. Absolute values of higher order coeffs are added to the esssup.
      Cex1,Cex2,Ess: Comp;
      EsSup,EsSupp,Res: Scalar;
      Psi: Scalar;
      MM: constant Integer:=5;--fine angle grid
      Del: Scalar:=Scal(Sup(ScalPi))/Rep(MM*B'Length(2));
      Ex1,Ex2: CompArray(1..MM*B'Length(2));
      N2: constant Integer:=-5;
      N1: constant Integer:=5;
      Count: Integer;
   begin
      EsSupp:=ScalZero;
      Count:=1;
      Psi:=-ScalPi;
      for J in B'Range(2) loop
         for L in 1..MM loop
            Ex1(Count):=Exp(Scal(Inf(Psi),Sup(Psi+Del))*IBall);
            Ex2(Count):=Inv(Ex1(Count));
            Psi:=Psi+Del;
            Count:=Count+1;
         end loop;
      end loop;

      for I in B'Range(1) loop
         EsSup:=ScalZero;
         Res:=ScalZero;
         for J in B'First(2)..(N1-1) loop
            Res:=Res+AbsVal(B(I,J));
         end loop;
         Count:=1;
         for J in B'Range(2) loop
            for L in 1..MM loop
               Cex1:=Ex1(Count);
               Ess:=B(I,0);
               for K in 1..N2 loop
                  Ess:=Ess+B(I,K)*Cex1;
                  Cex1:=Cex1*Ex1(Count);
               end loop;
               Cex2:=Ex2(Count);
               for K in reverse -1..N1 loop
                  Ess:=Ess+B(I,K)*Cex2;
                  Cex2:=Cex2*Ex2(Count);
               end loop;
               Count:=Count+1;
               if SupMod(Ess)>Sup(EsSup) then
                  EsSup:=AbsVal(Ess);
               end if;
            end loop;
         end loop;
         for J in N2+1..B'Last(2) loop
            Res:=Res+AbsVal(B(I,J));
         end loop;
         if Sup(EsSup+Res)>Sup(EsSupp) then
            EsSupp:=EsSup+Res;
         end if;
      end loop;
      return EsSupp;
   end EssSup;


   procedure EssSup(B: in CompMatrix; E: out ScalArray) is
      --MM is the number of angles on which the esssup is evaluated.
      --N2 and N1 are the cut-off for the coefficients in the Fourier series. Absolute values of higher order coeffs are added to the esssup
      Cex1,Cex2,Ess: Comp;
      EsSup,Res: Scalar;
      Psi: Scalar;
      MM: constant Integer:=100;--fine angle grid
      Del: Scalar:=ScalPi/Rep(MM);
      Ex1,Ex2: CompArray(1..MM);
      N2: constant Integer:=10;
      N1: constant Integer:=-10;
      Count: Integer;
   begin
      Count:=1;
      Psi:=-ScalPi;
      for L in 1..MM loop
         Ex1(Count):=Exp(Scal(Inf(Psi),Sup(Psi+Del))*IBall);
         Ex2(Count):=Exp(Neg(Scal(Inf(Psi),Sup(Psi+Del))*IBall));
         Psi:=Psi+Del;
         Count:=Count+1;
      end loop;
      for I in B'Range(1) loop
         EsSup:=ScalZero;
         Res:=ScalZero;
         for J in B'First(2)..(N1-1) loop
            Res:=Res+AbsVal(B(I,J));
         end loop;
         Count:=1;
         for L in 1..MM loop
            Cex1:=Ex1(Count);
            Ess:=B(I,0)+CoOne;
            for K in 1..N2 loop
               Ess:=Ess+B(I,K)*Cex1;
               Cex1:=Cex1*Ex1(Count);
            end loop;
            Cex2:=Ex2(Count);
            for K in reverse -1..N1 loop
               Ess:=Ess+B(I,K)*Cex2;
               Cex2:=Cex2*Ex2(Count);
            end loop;
            Count:=Count+1;
            if SupMod(Ess)>Sup(EsSup) then
               EsSup:=AbsVal(Ess);
            end if;
         end loop;
         for J in N2+1..B'Last(2) loop
            Res:=Res+AbsVal(B(I,J));
         end loop;
         E(I):=EsSup+Res;
      end loop;
   end EssSup;


   function  RoughEssSup(B: CompMatrix) return Scalar is
      Ess,EsSup: Scalar;
   begin
      EsSup:=ScalZero;
      for I in B'Range(1) loop
         Ess:=ScalZero;
         for J in B'Range(2) loop
            Ess:=Ess+AbsVal(B(I,J));
         end loop;
         if Sup(Ess)>Sup(EsSup) then
            EsSup:=Ess;
         end if;
      end loop;
      return EsSup;
   end RoughEssSup;


   --SOME PROCEDURES FOR FFT
   procedure Glassman (A, B, C:   in  Integer; Data_Vector:   in out CompArray ;Inverse_Transform  :   in  Boolean:=False   )  is
      Temp:  CompArray(1..Data_Vector'length);
      Counter:  Integer := Data_Vector'first;
      JC:  Integer := 0;
      Del, Omega, Sum:  Comp;
      Angle:  Rep;
      C_Plus_1:  Integer := C + 1; --=3 in the standard case
   begin
      Temp(1..Data_Vector'length) := Data_Vector;
      Angle:= Two*Pi/(Rep(A * C));
      Del:= Complecs(Cos(Angle),-Sin(Angle));
      Omega:=CoOne;
      if Inverse_Transform then
         Del := Conj(Del);
      end if;
      for IC in 1..C loop --executed tyewo times
         for IA in 1..A loop
            for IB in 1..B loop
               Sum      := Temp((((IA - 1)*C + (C-1))*B) + IB);--Temp[(N/2^k)*(2*(IA - 1)+1)+IB]
               for JCR in 2..C loop  -- executed once in the standard case, JCR=2
                  JC := C_Plus_1 - JCR; -- No need to add C + 1 each
                                        -- time through loop
                                        -- JC=1 in the standard case
                  Sum := Temp((((IA - 1) * C + (JC - 1)) * B)
                              + IB) + (Omega  *  Sum); --Temp[(N/2^k)*2*(IA-1)+IB]+W^(IC*IA)*Temp[(N/2^k)*(2*(IA - 1)+1)+IB]
               end loop; -- JCR
               Data_Vector(Counter) := Sum;
               Counter := Counter +   1;
            end loop;  -- IB
            Omega := Del  *  Omega;
         end loop; -- IA
      end loop; -- IC
   end Glassman;


   procedure FFT (FFT_Data:  in out CompArray; Inverse_Transform: in   Boolean:=False) is
      A: Integer   := 1;
      B: Integer   := FFT_Data'length;
      C: Integer   := 1;
   begin -- FFT
      while (B  >  1)  loop   -- define the integers A, B, and C
         A := C  *  A;       --  such that A * B * C = FFT_Data'length
         C := 2;
         while (B mod C) /= 0 loop
            C := C + 1;
         end loop;
         B := B/C;     -- B = 1 causes exit from while loop
         Glassman (A,B,C, FFT_Data, Inverse_Transform);
      end loop;
      if not Inverse_Transform  then
         for i in FFT_Data'range loop
            FFT_Data(i) := FFT_Data(i)/Rep(FFT_Data'length);
         end loop;
      end if;
   end FFT;


   procedure FT(H: in out CompMatrix; Inverse_Transform: in   Boolean:=False )  is
      -- The first row in the input is the value at the center if Inverse_Transform:=False; and zeros except for H(First,0), otherwise
      -- The i-th row in the input is the values at 2^N angles on the the circle of radius R_i if Inverse_Transform:=False; and Fourier components otherwise
      A,B,C: Integer;
      Temp: CompArray(H'Range(2));
      M,Div: Rep;
   begin
      if H'First(2)/=-H'Length(2)/2 then
         Message("RG_Ops.FT",Index_Error);
      end if;
      if not Inverse_Transform  then
         Div := Rep(H'Length(2));
      else
         Div:=One;
      end if;
      for I in H'Range(1) loop
         --tilde{U}_n=U_{n-N/2}(-1)^n
         --tilde{U}_m=U_{m-N/2}(-1)^m
         A:= 1;
         B:= H'Length(2);
         C:= 1;

         M:=One;
         for J in H'Range(2) loop
            Temp(J):=M*H(I,J);
            M:=-M;
         end loop;

         while (B  >  1)  loop   -- define the integers A, B, and C
            A := C  *  A;       --  such that A * B * C = FFT_Data'length
            C := 2;
            while (B mod C) /= 0 loop
               C := C + 1;
            end loop;
            B:=B/C;
            Glassman (A,B,C,Temp,Inverse_Transform);
         end loop;

         for J in Temp'Range loop
            H(I,J):=Temp(J)/Div;
            Div:=-Div;
         end loop;
      end loop;
   end FT;


   procedure FT_Mod(H: in out CompMatrix; Inverse_Transform: in   Boolean:=False )  is
      -- The first row in the input is the value at the center if Inverse_Transform:=False; and zeros except for H(First,0), otherwise
      -- The i-th row in the input is the values at 2^N angles on the the circle of radius R_i if Inverse_Transform:=False; and Fourier components otherwise
      A,B,C: Integer;
      Temp: CompArray(H'Range(2));
      M,Div: Rep;
      Com: Comp;
   begin
      if H'First(2)/=-H'Length(2)/2 then
         Message("RG_Ops.FT",Index_Error);
      end if;
      if not Inverse_Transform  then
         Div := Rep(H'Length(2));
      else
         Div:=One;
      end if;
      for I in H'First(1)+1..H'Last(1) loop
         --tilde{U}_n=U_{n-N/2}(-1)^n
         --tilde{U}_m=U_{m-N/2}(-1)^m
         A:= 1;
         B:= H'Length(2);
         C:= 1;
         M:=One;
         for J in H'Range(2) loop
            Temp(J):=M*H(I,J);
            M:=-M;
         end loop;
         while (B  >  1)  loop   -- define the integers A, B, and C
            A := C  *  A;       --  such that A * B * C = FFT_Data'length
            C := 2;
            while (B mod C) /= 0 loop
               C := C + 1;
            end loop;
            B:=B/C;
            Glassman (A,B,C,Temp,Inverse_Transform);
         end loop;
         for J in Temp'Range loop
            H(I,J):=Temp(J)/Div;
            Div:=-Div;
         end loop;
      end loop;
      Com:=H(H'First(1),0);
      if Inverse_Transform then --point values
         for J in H'Range(2) loop
            H(H'First(1),J):=Com;
         end loop;
      else
         for J in H'Range(2) loop
            H(H'First(1),J):=CoZero;
         end loop;
         H(H'First(1),0):=Com;
      end if;
   end FT_Mod;


   --ROUTINES RELATED TO THE CONSTRUCTION OF THE FUNDAMENTAL CRESCENT
   function TauInv(C: Comp) return Comp is
   begin
      return Neg(IBall)*Log(  (C-P)*Cn2/(C*(Cn2-P))   )/LogA;
   end TauInv;


   function Tau(C: Comp) return Comp is
   begin
      return  P/(CoOne-Exp(IBall*(LogA*C+LogBB)));
   end Tau;



   procedure Parametrize_1(R: in Scalar; C: out Comp; Der,RDer: out Comp) is --FINE
      R1,Der_T,RDer_T,S,T,A,B,G,D,E,SL1,SL2,Xc,Yc,Xp,Yp: Scalar;
   begin
      if Quad then
         --These are the tangents of the lines along which two parabolas, constituting a boundary of the fundamental crescent, meet. Adjust accordingly.
         SL1:=Scal(-1.0);
         SL2:=Scal(-1.0);
      else
         --These are the tangents of the lines along which two parabolas, constituting a boundary of the fundamental crescent, meet. Adjust accordingly.
         SL1:=Scal(1.1);
         SL2:=Scal(1.1);
      end if;
      Xc:=RePart(Cn2n);
      Xp:=RePart(P);
      Yc:=ImPart(Cn2n);
      Yp:=ImPart(P);
      R1:=Sqrt(R); --depends on R
      E:=AbsVal(Cn2n)+AbsVal(Cn2n-P);
      T:=E*R1/(R1+ScalOne); --depends on R
      Der_T:=Inv(R1)*E/(Two*(R1+ScalOne)*(R1+ScalOne)); --depends on R
      RDer_T:=R1*E/(Two*(R1+ScalOne)*(R1+ScalOne)); -- R*Der_T,  depends on R
      S:=AbsVal(Cn2n);
      if Approx(S)<Zero then
         New_Line;
         Message("RG_Ops.Parametrize",Parameter_Error);
      end if;
      if Approx(T)<Approx(S) then
         --Parametrization of the "bottom" with a parabola
         A:=(Xc*SL1-Yc)/Sqr(Xc);
         B:=-(Xc*SL1-Two*Yc)/Xc;
         G:=T*Xc/S;
         C:=SetBall(G,A*Sqr(G)+B*G);
         --         C:=SetBall(G,A*Sqr(G)+B*G);
         Der:=Xc/S*Der_T*SetBall(ScalOne,Two*A*G+B);
         RDer:=Xc/S*RDer_T*SetBall(ScalOne,Two*A*G+B);
      else
         --Parametrization of the "top" with a parabola
         A:=-(Yp+Xc*SL2-SL2*Xp-Yc)/(SL2*Sqr(Yp-Yc));
         B:=(Two*Yc*Xc*SL2-Two*Yc*Xp*SL2-Sqr(Yc)+Sqr(Yp))/(SL2*Sqr(Yp-Yc));
         D:=(Sqr(Yc)*Yp+Sqr(Yc)*Xp*SL2-Yc*Sqr(Yp)+Xc*Sqr(Yp)*SL2-Two*Xc*Yp*Yc*SL2)/(SL2*Sqr(Yp-Yc));
         G:=Yc*(E-T)/AbsVal(Cn2n-P)+Yp*(T-S)/AbsVal(Cn2n-P);
         C:=SetBall(A*Sqr(G)+B*G+D,G);
         --         C:=SetBall(A*Sqr(G)+B*G+D,G);
         Der:=(Yp-Yc)/AbsVal(Cn2n-P)*Der_T*SetBall(Two*A*G+B,ScalOne);
         RDer:=(Yp-Yc)/AbsVal(Cn2n-P)*RDer_T*SetBall(Two*A*G+B,ScalOne);
      end if;
   end Parametrize_1;


   procedure Parametrize_2(R: in Scalar; C,Der,RDer,RDerDer,CC,DDer,RRDer,RRDerDer: out Comp) is --FINE
      R1,RR1,Der_T,Der_TT,RDer_T,RDer_TT,RDerDer_T,RDerDer_TT,S,T,A,B,G,GG,TT,D,E,SL1,SL2,Xc,Yc,Xp,Yp: Scalar;
   begin
      if Quad then
         --These are the tangents of the lines along which two parabolas, constituting a boundary of the fundamental crescent, meet. Adjust accordingly.
         --Qn=3
         SL1:=Scal(-1.0);
         SL2:=Scal(-1.0);
      else
         --These are the tangents of the lines along which two parabolas, constituting a boundary of the fundamental crescent, meet. Adjust accordingly.
         SL1:=Scal(1.7);
         SL2:=Scal(1.7);
      end if;
      Xc:=RePart(Cn2n);
      Xp:=RePart(P);
      Yc:=ImPart(Cn2n);
      Yp:=ImPart(P);
      E:=AbsVal(Cn2n)+AbsVal(Cn2n-P);

      R1:=Sqrt(Scal(Approx(R),Approx(R)+Err(R))); --depends on R
      T:=E*R1/(R1+ScalOne); --depends on R
      Der_T:=Inv(R1)*E/(Two*(R1+ScalOne)*(R1+ScalOne)); --depends on R
      RDer_T:=R1*E/(Two*(R1+ScalOne)*(R1+ScalOne)); -- R*Der_T,  depends on R
      RDerDer_T:=(-E)*(ScalOne+Three*R1)/(Four*R1*Sqr(R1+ScalOne)*(R1+ScalOne));

      RR1:=Sqrt(Center(R)); --depends on R
      TT:=E*RR1/(RR1+ScalOne); --depends on R
      Der_TT:=Inv(RR1)*E/(Two*(RR1+ScalOne)*(RR1+ScalOne)); --depends on R
      RDer_TT:=RR1*E/(Two*(RR1+ScalOne)*(RR1+ScalOne)); -- R*Der_T,  depends on R
      RDerDer_TT:=(-E)*(ScalOne+Three*RR1)/(Four*RR1*Sqr(RR1+ScalOne)*(RR1+ScalOne));

      S:=AbsVal(Cn2n);
      if Inf(S)<Zero then
         New_Line;
         Message("RG_Ops.Parametrize",Parameter_Error);
      end if;
      if Approx(T)<Approx(S) then
         --Parametrization of the "bottom" with a parabola
         A:=(Xc*SL1-Yc)/Sqr(Xc);
         B:=-(Xc*SL1-Two*Yc)/Xc;
         G:=T*Xc/S;
         GG:=TT*Xc/S;
         C:=SetBall(GG,A*Sqr(GG)+B*GG);

         Der:=Xc/S*Der_TT*SetBall(ScalOne,Two*A*GG+B);
         RDer:=Xc/S*RDer_TT*SetBall(ScalOne,Two*A*GG+B);
         RDerDer:=Xc/S*(RDerDer_TT*SetBall(ScalOne,Two*A*GG+B)+Xc/S*RDer_TT*Der_TT*SetBall(ScalZero,Two*A));

         DDer:=Xc/S*Der_T*SetBall(ScalOne,Two*A*G+B);
         RRDer:=Xc/S*RDer_T*SetBall(ScalOne,Two*A*G+B);
         RRDerDer:=Xc/S*(RDerDer_T*SetBall(ScalOne,Two*A*G+B)+Xc/S*RDer_T*Der_T*SetBall(ScalZero,Two*A));
      else
         --Parametrization of the "top" with a parabola
         A:=-(Yp+Xc*SL2-SL2*Xp-Yc)/(SL2*Sqr(Yp-Yc));
         B:=(Two*Yc*Xc*SL2-Two*Yc*Xp*SL2-Sqr(Yc)+Sqr(Yp))/(SL2*Sqr(Yp-Yc));
         D:=(Sqr(Yc)*Yp+Sqr(Yc)*Xp*SL2-Yc*Sqr(Yp)+Xc*Sqr(Yp)*SL2-Two*Xc*Yp*Yc*SL2)/(SL2*Sqr(Yp-Yc));
         G:=Yc*(E-T)/AbsVal(Cn2n-P)+Yp*(T-S)/AbsVal(Cn2n-P);
         GG:=Yc*(E-TT)/AbsVal(Cn2n-P)+Yp*(TT-S)/AbsVal(Cn2n-P);
         C:=SetBall(A*Sqr(GG)+B*GG+D,GG);

         Der:=(Yp-Yc)/AbsVal(Cn2n-P)*Der_TT*SetBall(Two*A*GG+B,ScalOne);
         RDer:=(Yp-Yc)/AbsVal(Cn2n-P)*RDer_TT*SetBall(Two*A*GG+B,ScalOne);
         RDerDer:=(Yp-Yc)/AbsVal(Cn2n-P)*(RDerDer_TT*SetBall(Two*A*GG+B,ScalOne)+
                  (Yp-Yc)/AbsVal(Cn2n-P)*RDer_TT*Der_TT*SetBall(Two*A,ScalZero));

         DDer:=(Yp-Yc)/AbsVal(Cn2n-P)*Der_T*SetBall(Two*A*G+B,ScalOne);
         RRDer:=(Yp-Yc)/AbsVal(Cn2n-P)*RDer_T*SetBall(Two*A*G+B,ScalOne);
         RRDerDer:=(Yp-Yc)/AbsVal(Cn2n-P)*(RDerDer_T*SetBall(Two*A*G+B,ScalOne)+
                  (Yp-Yc)/AbsVal(Cn2n-P)*RDer_T*Der_T*SetBall(Two*A,ScalZero));
      end if;
      CC:=C+Scal(-Err(R),Err(R))*DDer;
   end Parametrize_2;


   procedure SInvH1(N: in Integer; FCAppr, Appr,C: in out Comp; Tay: in Taylor; Er: in Radius; IsPoly: in Boolean:=True) is
      C1PC1,C2PC2,DerIF,DerG,C1,C2,H1_y,H1_x,RDerG: Comp;
      IDh: ScalMatrix(1..2,1..2);
      V,X,Xold: ScalArray(1..2);
      Det,Y: Scalar;
      Diff: Rep;
      InvLogA: constant Scalar:=Inv(LogA);
   begin
      X(1):=RePart(Appr);
      X(2):=ImPart(Appr);
      Diff:=Two*Er;
      --Computing x_0 and x_1, see Kantorovich theorem
      while Diff > Er loop
         X(1):=Center(X(1));
         X(2):=Center(X(2));
         Y:=Exp(Two*ScalPi*X(2));

         Parametrize_1(Y,C2,DerG,RDerG);
         DerG:=Two*ScalPi*Y*DerG;
         C1:=C2;
         Newton(N,Rho,C1,Tay,C2,IsPoly);
         DerIF:=Inv(DerVal(N,Rho,SupMod(C1),C1,Tay));
         C2PC2:=(C2-P)*C2; C1PC1:=(C1-P)*C1;

         --derivatives
         H1_x:=InvLogA*Neg(IBall)*Log( (C2-P)*C1/((C1-P)*C2) ); --h_x
         H1_y:=InvLogA*DerG*P*Neg(IBall)*((ScalOne-X(1))*Inv(C1PC1)*DerIF+X(1)*Inv(C2PC2)); --h_y
         IDh(2,2):=RePart(H1_x); -- u_x
         IDh(2,1):=-ImPart(H1_x); -- -v_x
         IDh(1,2):=-RePart(H1_y);-- -u_y
         IDh(1,1):=ImPart(H1_y);--v_y
         Det:=IDh(1,1)*IDh(2,2)-IDh(2,1)*IDh(1,2);
         C1:=C-SH1(N,C1,X(1),X(2),Tay);
         Xold:=X;
         V(1):=RePart(C1);
         V(2):=ImPart(C1);
         X(1):=Scal(Approx(X(1)+(IDh(1,1)*V(1)+IDh(1,2)*V(2))/Det));
         X(2):=Scal(Approx(X(2)+(IDh(2,1)*V(1)+IDh(2,2)*V(2))/Det));
         Diff:=Max(Sup(abs( X(1)-Xold(1) )),Sup(abs(X(2)-Xold(2) )) );
      end loop;
      X(1):=Xold(1)+(IDh(1,1)*V(1)+IDh(1,2)*V(2))/Det;
      X(2):=Xold(2)+(IDh(2,1)*V(1)+IDh(2,2)*V(2))/Det;
      Appr:=SetBall(X(1),X(2));
   end SInvH1;


   function SH1(N: Integer; Appro: Comp; X,Y: Scalar; Tay: Taylor; IsPoly: Boolean:=True) return Comp is
      PP,RDerr,Derr,C1,C2,L1,L2: Comp;
   begin
      --Appro is an approximate C1 in Newton, not used right now
      Parametrize_1(Exp(Two*ScalPi*Y),C2,Derr,RDerr);
      C1:=C2;
      Newton(N,Rho,C1,Tay,C2,IsPoly);
      L1:=Neg(IBall)*Log( (C1-P)*Cn2/(C1*(Cn2-P)) )/LogA;
      L2:=Neg(IBall)*Log( (C2-P)*Cn2/(C2*(Cn2-P)) )/LogA;
      PP:=(ScalOne-X)*L1+X*L2;
      return PP;
   end SH1;


   procedure GetRow(Num_Of_Machines: in Integer;  ThickRad: in ScalArray; Input_File: in String; C: in Comp; Row: out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      use Ada.Strings.Unbounded;
      R: constant Scalar:=AbsVal(C);
      Int1,Int2,Ind,Np1,Np2,Machine_Number: Integer;
      H_File,CM:  Unbounded_String;
      C1: Comp;
      F: File_Type;
   begin
      for I in ThickRad'Range loop
         if Sup(ThickRad(I+1))>=Sup(R) and Inf(ThickRad(I))<=Inf(R) then
            Ind:=I;
            goto HERE;
         end if;
      end loop;
      <<HERE>> null;
      for J in 1..Num_Of_Machines loop
         if J/=Num_Of_Machines  then
            Np1:=ThickRad'First+(J-1)*Integer((-ThickRad'First)/Num_Of_Machines);
            Np2:=ThickRad'First+J*Integer((-ThickRad'First)/Num_Of_Machines)-1;
         else
            Np1:=ThickRad'First+(J-1)*Integer((-ThickRad'First)/Num_Of_Machines);
            Np2:=0;
         end if;
         if Np1<=Ind and Np2>=Ind then
            Machine_Number:=J;
            exit;
         end if;
      end loop;
      CM:=To_Unbounded_String(Integer'Image(Machine_Number)(2..Integer'Image(Machine_Number)'Last));
      Int1:= Integer'Image(Machine_Number)'Length ;
      Int2:=Integer'Image(Num_Of_Machines)'Length-1;
      for I in Int1..Int2 loop
         CM:=To_Unbounded_String("0") & CM;
      end loop;
      H_File:=To_Unbounded_String(Input_File) & CM;
      Open(F,In_File,To_String(H_File));
      Set_Line(F,Ada.Text_IO.Count(Ind-Np1+2));

      for J in Row'Range loop
         Get(F,C1,Brackets,Decimal,ShowErr);
         Row(J):=C1;
      end loop;
      Close(F);
   end GetRow;


   function G_Value(Pex: in Rep; R,AEP,C: in Scalar; V: in CompArray; Val_At_Zero, Z: in Comp) return Comp is
      --V(Arg(C))
      CC,E,Ex: Comp;
      B,AZ,AZP: Scalar;
   begin
      E:=Z/AbsVal(Z);
      CC:=V(0);
      Ex:=E;
      for I in 1..V'Last loop
         CC:=CC+V(I)*Ex;
         Ex:=Ex*E;
      end loop;
      Ex:=Inv(E);
      for I in reverse -1..V'First loop
         CC:=CC+V(I)*Ex;
         Ex:=Ex/E;
      end loop;
      if not Trunc then
         AZ:=AbsVal(Z);
         AZP:=Exp((Pex-Two)*Log(AZ)/Pex );
         B:=AEP*AZP+C*Exp((ScalOne+ScalTwo/Pex)*Log(AbsVal(CC)+AEP*AZP))/(Exp(Four*Log(R)/Pex)-C*Exp(Two*Log(AbsVal(CC)+AEP*AZP)/Pex));
      else
         B:=ScalZero;
      end if;
      CC:=CC+Ball0(SupAbs(B))+Z-Val_At_Zero;
      return CC;
   end G_Value;


   function G_Value(Pex: in Rep; R,AEP,C: in Scalar; V: in CompArray; Val_At_Zero: in Comp; Rad,Psi: in Scalar) return Comp is
      --V(Arg(C))
      CC,E,Ex: Comp;
      B,AZ,AZP: Scalar;
   begin
      E:=Exp(Psi*IBall);
      CC:=V(0);
      Ex:=E;
      for I in 1..V'Last loop
         CC:=CC+V(I)*Ex;
         Ex:=Ex*E;
      end loop;
      Ex:=Inv(E);
      for I in reverse -1..V'First loop
         CC:=CC+V(I)*Ex;
         Ex:=Ex/E;
      end loop;
      if not Trunc then
         AZ:=Rad;
         AZP:=Exp((Pex-Two)*Log(AZ)/Pex );
         B:=AEP*AZP+C*Exp((ScalOne+ScalTwo/Pex)*Log(AbsVal(CC)+AEP*AZP))/(Exp(Four*Log(R)/Pex)-C*Exp(Two*Log(AbsVal(CC)+AEP*AZP)/Pex));
      else
         B:=ScalZero;
      end if;
      CC:=CC+Ball0(SupAbs(B))+Rad*E-Val_At_Zero;
      return CC;
   end G_Value;


   function ExpInv(C: in Comp) return Comp is
   C1: Comp;
   RP: Scalar;
   begin
      C1:=IBall*Log(C)/TwoPi;
      RP:=RePart(C1);
      if Sup(RP)<Zero then
        C1:=SetBall(ScalOne+RP,ImPart(C1));
      end if;
      return C1;
   end ExpInv;




   --ROUTINES RELATED TO THE BELTRAMI EQUATUION
   procedure BeltramiF(Qn: in Integer; NumErr: in Rep; ThickRad: in ScalArray; Tay: in Taylor;Coeffs: out CompMatrix;IsPoly: in Boolean:=True) is
      use Ada.Calendar;
      --mu:=e^(2 I Ang)*(A*Ang+B+C)/(A*Ang+B-C)=e^(2 I Ang) -e^(2 I Ang)*(2*C/A)/(Ang+(B-C)/A)
      Den,Num,C1,C2,Appro,D,RD,DQ,L,C11,C22: Comp;
      Rho1: Rep:=Rep(0.8)*Rho;
      Ic,Ip: Integer;
      Psi,X: Scalar;
      Del: constant Scalar:=Two*ScalPi/Rep(Coeffs'Length(2));
      StartTime, EndTime: Time;
   begin
      StartTime:=Clock;
      Ic:=0;
      Ip:=0;
      for J in Coeffs'Range(2) loop
         Coeffs(Coeffs'First(1),J):=CoZero;
      end loop;

      for I in Coeffs'First(1)+1..Coeffs'Last(1) loop
         Parametrize_1(ThickRad(I),C2,D,RD); -- C2 is lambda(r), D is lambda'(r), RD is r*lambda'(r)
         if I=(Coeffs'First(1)+1) then
            if Quad then
               Appro:=ResetErr(C2);
               --Appro:=CoZero;
            else
               Appro:=Complecs(-Approx(RePart(C2)),Approx(ImPart(C2)));
            end if;
         end if;
         C1:=Appro;
         Newton(Qn,Rho,C1,Tay,C2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
         Appro:=ResetErr(C1);
         DQ:=DerVal(Qn,Rho,SupMod(C1),C1,Tay);--inverse of Df^{-q_n}(lambda(r))
         L:=Log(C1*(C2-P)/(C2*(C1-P)));
         Den:=(C2-P)*C2*(C1-P)*C1; --correct
         C11:=L/(Two*ScalPi);--x-derivative

         Psi:=-ScalPi;
         for J in Coeffs'First(2)..-1 loop
            X:=(-Psi)/(Two*ScalPi);
            Num:=(ScalOne-X)*(C2-P)*C2/DQ+X*(C1-P)*C1;
            C22:=D*Num*P/Den;--y-derivative
            Coeffs(I,J):=Exp(Two*Psi*IBall)*(C11+ThickRad(I)*IBall*C22)/(ThickRad(I)*IBall*C22-C11);
            Psi:=Psi+Del;
         end loop;
         for J in 0..Coeffs'Last(2) loop
            X:=(Two*ScalPi-Psi)/(Two*ScalPi);
            Num:=(ScalOne-X)*(C2-P)*C2/DQ+X*(C1-P)*C1;
            C22:=D*Num*P/Den;--y-derivative
            Coeffs(I,J):=Exp(Two*Psi*IBall)*(C11+ThickRad(I)*IBall*C22)/(ThickRad(I)*IBall*C22-C11);
            Psi:=Psi+Del;
         end loop;

         Ic:=(100*(I-Coeffs'First(1)))/Coeffs'Length(1);
         if Ic/=Ip then
            New_Line;
            Put("%");ShortPut(Ic);
            EndTime:=Clock;
            Put(" accomplished in ");Put(Item=>(Integer(Seconds(EndTime)-Seconds(StartTime))/60), Width =>4);Put(" minutes");
         end if;
         Ip:=Ic;
      end loop;
   end BeltramiF;


   procedure Beltrami(Qn: in Integer; NumErr: in Rep; ThickRad: in ScalArray; Tay: in Taylor;Coeffs: out CompMatrix;IsPoly: in Boolean:=True) is
      use Ada.Calendar;
      --mu:=e^(2 I Ang)*(A*Ang+B+C)/(A*Ang+B-C)=e^(2 I Ang) -e^(2 I Ang)*(2*C/A)/(Ang+(B-C)/A)
      Den,Num,C1,C2,Appro,D,RD,DQ,L,C11,C22: Comp;
      Rho1: Rep:=Rep(0.8)*Rho;
      Ic,Ip: Integer;
      Psi,X: Scalar;
      Del: constant Scalar:=Two*ScalPi/Rep(Coeffs'Length(2));
      StartTime, EndTime: Time;
   begin
      StartTime:=Clock;
      Ic:=0;
      Ip:=0;

      for I in Coeffs'Range(1) loop
         Parametrize_1(ThickRad(I),C2,D,RD); -- C2 is lambda(r), D is lambda'(r), RD is r*lambda'(r)
         if I=Coeffs'First(1) then
            if Quad then
               Appro:=ResetErr(C2);
            else
               Appro:=C2;
            end if;
         end if;
         C1:=Appro;
         Newton(Qn,Rho,C1,Tay,C2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
         Appro:=ResetErr(C1);
         DQ:=DerVal(Qn,Rho,SupMod(C1),C1,Tay);--inverse of Df^{-q_n}(lambda(r))
         L:=Log(C1*(C2-P)/(C2*(C1-P)));
         Den:=(C2-P)*C2*(C1-P)*C1; --correct
         C11:=L/(Two*ScalPi);--x-derivative

         Psi:=-ScalPi;
         for J in Coeffs'First(2)..-1 loop
            X:=(-Psi)/(Two*ScalPi);
            Num:=(ScalOne-X)*(C2-P)*C2/DQ+X*(C1-P)*C1;
            C22:=D*Num*P/Den;--y-derivative
            Coeffs(I,J):=Exp(Two*Psi*IBall)*(C11+ThickRad(I)*IBall*C22)/(ThickRad(I)*IBall*C22-C11);
            Psi:=Psi+Del;
         end loop;
         for J in 0..Coeffs'Last(2) loop
            X:=(Two*ScalPi-Psi)/(Two*ScalPi);
            Num:=(ScalOne-X)*(C2-P)*C2/DQ+X*(C1-P)*C1;
            C22:=D*Num*P/Den;--y-derivative
            Coeffs(I,J):=Exp(Two*Psi*IBall)*(C11+ThickRad(I)*IBall*C22)/(ThickRad(I)*IBall*C22-C11);
            Psi:=Psi+Del;
         end loop;

         Ic:=(100*(I-Coeffs'First(1)))/Coeffs'Length(1);
         if Ic/=Ip then
            New_Line;
            Put("%");ShortPut(Ic);
            EndTime:=Clock;
            Put(" accomplished in ");Put(Item=>(Integer(Seconds(EndTime)-Seconds(StartTime))/60), Width =>4);Put(" minutes");
         end if;
         Ip:=Ic;
      end loop;
   end Beltrami;


   procedure ProdAddBeltramiF(NumErr,Pex: in Rep; Ro,ThickRad: in ScalArray; Q: in Taylor;H: in out CompMatrix;
                             Delta1,Delta2: out ScalArray; EsSup,MultError: out Scalar; IsPoly: in Boolean:=True) is
      use Ada.Calendar;
      --mu:=e^(2 I Ang)*(A*Ang+B+C)/(A*Ang+B-C)=e^(2 I Ang) -e^(2 I Ang)*(2*C/A)/(Ang+(B-C)/A)
       AprA,AprB,AprC,AprD,AprE,CC1,CC2,C1,C2,Appro,D,DD,RD,RRD,RDD,RRDD,RDP,RDDP,DerF,DerIF,DerDerF,DerDerIF,InIAp,InIAm,IAp,IAm,XiOverKappa,C2PC2,C1PC1,L,Bp,Bm,AmOverAp,A,B,Mu_2,Co1,Co2,C,E,AlphaP,AlphaM,Di,EE: Comp;
      ZetaM,ZetaP,ZetaMP,ZetaPP,Xi,XiP,DerC,DerA,DerB,DerD,DerE,Kappa,KappaP,Der_Mu_2: Comp;
      ErrB,ErrA,ErrC,ErrD,ErrE,Psi,E0,E1,E2,E3,E4,E5,E6,E7,E8,E9,E10,E11,E12,E13,E14,E15,E16,E17,E18,E19: Scalar;
      Remain,Err_Mu_2,RoDiff,N2,CP,CM,EtaEsSup,EtaEssSup,EssSup,Sum2,Sum3,Sum4,Sum5,Sum6,Sum7,Sum8,Sum10,Sum12,S2,S3,S4,S5,S6,S7,S8,S10,S12,R5P,R5M,ErrRo,L2Sum,MultEssSup: Scalar;
      Rho1: Rep:=Rep(0.8)*Rho;
      M: constant Integer:=4101;
      Ic,Ip: Integer;
      Del: Scalar:=Two*ScalPi/Rep(M);
      StartTime, EndTime: Time;
      SPex: constant Scalar:=Scal(Pex);
      K1: Integer:=2-(M-1)/2;
      K2:  Integer:=(M-1)/2+2;
      Belt,BeltP: CompArray(K1..K2);
      Coeff: CompArray(H'Range(2));
   begin
      StartTime:=Clock;
      Ic:=0;
      Ip:=0;
      SetZero(Delta1);
      SetZero(Delta2);
      EsSup:=ScalZero;

      if not Trunc then
         Sum2:=ScalZero;
         Sum3:=ScalZero;
         Sum4:=ScalZero;
         Sum5:=ScalZero;
         Sum6:=ScalZero;
         Sum7:=ScalZero;
         Sum8:=ScalZero;
         Sum10:=ScalZero;
         Sum12:=ScalZero;
         for J in 1..M loop
            Sum2:=Sum2+ScalOne/Sqr(Scal(J));
            Sum3:=Sum3+ScalOne/Scal(J)**3;
            Sum4:=Sum4+ScalOne/Scal(J)**4;
            Sum5:=Sum5+ScalOne/Scal(J)**5;
            Sum6:=Sum6+ScalOne/Scal(J)**6;
            Sum7:=Sum7+ScalOne/Scal(J)**7;
            Sum8:=Sum8+ScalOne/Scal(J)**8;
            Sum10:=Sum10+ScalOne/Scal(J)**10;
            Sum12:=Sum12+ScalOne/Scal(J)**12;
         end loop;
         --Remainders of Riemann zeta functions: zeta_{M+1}(n)
         S2:=Sqr(ScalPi)/Rep(6.0)-Sum2;
         S3:=Scal(Rep(1.2020569033))-Sum3;
         S4:=ScalPi**4/Rep(90.0)-Sum4;
         S5:=ScalPi**5/Rep(295.0)-Sum5;
         S6:=ScalPi**6/Rep(945.0)-Sum6;
         S7:=ScalPi**7/Rep(2995.0)-Sum7;
         S8:=ScalPi**8/Rep(9450.0)-Sum8;
         S10:=ScalPi**10/Rep(93555.0)-Sum10;
         S12:=Rep(691.0)*ScalPi**12/Rep(638512875.0)-Sum12;
      end if;

      for J in H'Range(2) loop
         H(H'First(1),J):=CoZero;
      end loop;

      for I in H'First(1)+1..H'Last(1) loop
         EtaEsSup:=ScalZero;
         RoDiff:=(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
         ErrRo:=Scal(-Err(ThickRad(I)),Err(ThickRad(I)));
         Parametrize_2(ThickRad(I),C2,D,RD,RDD,CC2,DD,RRD,RRDD); -- C2 is lambda(r), D is lambda'(r), RD is r*lambda'(r)
         if I=(H'First(1)+1) then
            if Quad then
               Appro:=ResetErr(C2);
            else
               Appro:=Complecs(-Approx(RePart(C2)),Approx(ImPart(C2)));
            end if;
         end if;
         C1:=Appro;
         Newton(1,Rho,C1,Q,C2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
         DerF:=DerVal(1,Rho,SupMod(C1),C1,Q);--inverse of Df^{-q_n}(lambda(r))
         DerIF:=Inv(DerF);

         C2PC2:=(C2-P)*C2; C1PC1:=(C1-P)*C1;
         L:=Log((C1-P)*C2/(C1*(C2-P)));
         RDP:=RD*P;--r*lambda'(r)*p
         InIAp:=ResetErr((DerIF/C1PC1-Inv(C2PC2))/(Two*ScalPi*IBall/C2PC2+L/RDP)); --1/(i*alpha_+)
         InIAm:=ResetErr((Inv(C1PC1)-DerF/C2PC2)/(Two*ScalPi*IBall/C1PC1+DerF*L/RDP)); --1/(i*alpha_-)
         AlphaP:=(Two*ScalPi*Inv(C2PC2)-IBall*L/RDP)/(DerIF/C1PC1-Inv(C2PC2)); --i*alpha_+
         AlphaM:=(Two*ScalPi*Inv(C1PC1)-IBall*DerF*L/RDP)/(Inv(C1PC1)-DerF/C2PC2); --i*alpha_-
         IAp:=ResetErr(IBall*AlphaP); --i*alpha_+
         IAm:=ResetErr(IBall*AlphaM); --i*alpha_-
         AmOverAp:=(Two*ScalPi*DerIF/C1PC1-IBall*L/RDP)/(Two*ScalPi*Inv(C2PC2)-IBall*L/RDP);   --alpha_- / alpha_+
         XiOverKappa:= IBall*C2PC2*C1PC1*L/(RDP*(C2PC2*DerIF-C1PC1)); --xi/kappa

         --Stuff for L-p error and essential supremum
         if not Trunc then
            Bp:=Neg(Inv(CoOne+Two*ScalPi*IBall*RDP/(C2PC2*L))); --xi/(zeta_+ - xi)
            Bm:=Neg(Inv(CoOne+Two*ScalPi*IBall*RDP*DerIF/(C1PC1*L))); --xi/(zeta_- - xi)

            A:=Two*(Bp/AlphaP-Bm/AlphaM)/ScalPi;  --A(r)
            B:=Rep(6.0)*(Bm/(AlphaM**3)-Bp/(AlphaP**3))/ScalPi;  --B(r)
            C:=Two*(Bp-Bm)/ScalPi; --C(r)
            Di:=Four*(Bm/Sqr(AlphaM)-Bp/Sqr(AlphaP))/ScalPi; --D(r)
            E:=Rep(8.0)*(Bp/(AlphaP**4)-Bm/(AlphaM**4))/ScalPi;  --E(r)

            CC1:=Appro;
            Newton(1,Rho,CC1,Q,CC2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
            DerF:=DerVal(1,Rho,SupMod(CC1),CC1,Q);--inverse of Df^{-q_n}(lambda(r))
            DerIF:=Inv(DerF);
            DerDerF:=DerDerVal(1,Rho,SupMod(CC1),CC1,Q);
            DerDerIF:=Neg(DerDerF)*Inv(Sqr(DerF)*DerF);
            C2PC2:=(CC2-P)*CC2; C1PC1:=(CC1-P)*CC1;
            L:=Log((CC1-P)*CC2/(CC1*(CC2-P)));
            RDP:=RRD*P;--r*lambda'(r)*p
            RDDP:=RRDD*P;

            Xi:=IBall*L/(Two*ScalPi); --i*a*xi
            XiP:=IBall*DD*(P*DerIF/C1PC1-P/C2PC2)/(Two*ScalPi); --i*a*xi'
            ZetaP:=RDP/C2PC2;
            ZetaM:=RDP*DerIF/C1PC1;
            Kappa:=(ZetaM-ZetaP)/(Two*ScalPi);
            ZetaPP:=DD*P/C2PC2+RDDP/C2PC2+RDP*DD*(P-Two*CC2)/Sqr(C2PC2);
            ZetaMP:=DD*P*DerIF/C1PC1+RDDP*DerIF/C1PC1+RDP*DD*(P-Two*CC1)*Sqr(DerIF)/Sqr(C1PC1)+RDP*DD*DerDerIF/C1PC1;
            KappaP:=(ZetaMP-ZetaPP)/(Two*ScalPi);

            DerC:=Two*((XiP*ZetaP-Xi*ZetaPP)/Sqr(ZetaP-Xi)-(XiP*ZetaM-Xi*ZetaMP)/Sqr(ZetaM-Xi))/ScalPi; --C(r)'
            DerA:=Two*(XiP*Kappa+KappaP*Xi)*(Sqr(Inv(ZetaP-Xi))-Sqr(Inv(ZetaM-Xi)))/ScalPi-Four*Xi*Kappa*((ZetaPP-XiP)/(ZetaP-Xi)**3-(ZetaMP-XiP)/(ZetaM-Xi)**3)/ScalPi; --A(r)'
            DerB:=Rep(6.0)*(XiP*Kappa**3+Three*Sqr(Kappa)*KappaP*Xi)*(Inv(ZetaM-Xi)**4-Inv(ZetaP-Xi)**4)/ScalPi-Rep(24.0)*Xi*Kappa**3*((ZetaMP-XiP)/(ZetaM-Xi)**5-(ZetaPP-XiP)/(ZetaP-Xi)**5)/ScalPi; --B(r)'
            DerD:=Four*(XiP*Kappa**2+Two*Kappa*KappaP*Xi)*(Inv(ZetaM-Xi)**3-Inv(ZetaP-Xi)**3)/ScalPi-Rep(12.0)*Xi*Kappa**2*((ZetaMP-XiP)/(ZetaM-Xi)**4-(ZetaPP-XiP)/(ZetaP-Xi)**4)/ScalPi; --D(r)'
            DerE:=Rep(8.0)*(XiP*Kappa**4+Four*Kappa**3*KappaP*Xi)*(Inv(ZetaP-Xi)**5-Inv(ZetaM-Xi)**5)/ScalPi-Rep(40.0)*Xi*Kappa**4*((ZetaPP-XiP)/(ZetaP-Xi)**6-(ZetaMP-XiP)/(ZetaM-Xi)**6)/ScalPi; --E(r)'

            A:=A+ErrRo*DerA;
            B:=B+ErrRo*DerB;
            C:=C+ErrRo*DerC;
            Di:=Di+ErrRo*DerD;
            E:=E+ErrRo*DerE;

            ErrA:=Scal(ErrPart(A));
            AprA:=ResetErr(A);
            ErrB:=Scal(ErrPart(B));
            AprB:=ResetErr(B);
            ErrC:=Scal(ErrPart(C));
            AprC:=ResetErr(C);
            ErrD:=Scal(ErrPart(Di));
            AprD:=ResetErr(Di);
            ErrE:=Scal(ErrPart(E));
            AprE:=ResetErr(E);

            R5P:=Rep(720.0)*AbsVal(AlphaP)**(-6);--R_5(i alpha_+)
            R5M:=Rep(720.0)*AbsVal(AlphaM)**(-6);--R_5(i alpha_-)
            CP:=AbsVal(IAp)-abs(ImPart(IAp))+ScalTwo;
            CM:=AbsVal(IAm)-abs(ImPart(IAm))+ScalTwo;
            Remain:=AbsVal(CP*R5P*Bp+CM*R5M*Bm)/ScalPi; --|R_-(r)|+|R_+(r)|

            --||eta||^2_2
            E1:=RoDiff*Sqr(AbsVal(A));  --*S4
            E2:=RoDiff*Sqr(AbsVal(B));  --*S8
            E3:=Two*RoDiff*RePart(A*Conj(B)); --*S6

            E4:=RoDiff*Sqr(AbsVal(C)); --*S2
            E5:=RoDiff*Sqr(AbsVal(Di)); --*S6
            E6:=RoDiff*Sqr(AbsVal(E)); --*S10
            E7:=Two*RoDiff*RePart(C*Conj(Di)); --*S4
            E8:=Two*RoDiff*RePart(E*Conj(Di)); --*S8
            E9:=Two*RoDiff*RePart(C*Conj(E)); --*S6

            E10:=RoDiff*Sqr(ErrA);  --*S4
            E11:=RoDiff*Sqr(ErrB);  --*S8
            E12:=Two*RoDiff*ErrA*ErrB; --*S6

            E13:=RoDiff*Sqr(ErrC); --*S2
            E14:=RoDiff*Sqr(ErrD); --*S6
            E15:=RoDiff*Sqr(ErrE); --*S10
            E16:=Two*RoDiff*ErrC*ErrD; --*S4
            E17:=Two*RoDiff*ErrE*ErrD; --*S8
            E18:=Two*RoDiff*ErrC*ErrE; --*S6

            E19:=RoDiff*Sqr(Remain); --*S12
         end if;

         --mu_{2 +- k}, L-2 error and essential supremum
         Mu_2:=CoOne+XiOverKappa*Log(AmOverAp)/ScalPi;
         Der_Mu_2:=(((XiP*Kappa-Xi*KappaP)/Sqr(Kappa))*(Log(ZetaM-Xi)-Log(ZetaP-Xi))/ScalPi+
                    CoOne/Kappa*((ZetaMP-XiP)/(ZetaM/Xi-CoOne)-(ZetaPP-XiP)/(ZetaP/Xi-CoOne))/ScalPi);
         Mu_2:=Mu_2+ErrRo*Der_Mu_2;
         --         New_Line;
         --         Put("mu_2(r)="); Show(Mu_2);
         --         New_Line;
         --         Put("mu_2'(r)="); Show(Der_Mu_2);
         if not Trunc then
            E0:=RoDiff*Sqr(Scal(ErrPart(Mu_2)));
            Err_Mu_2:=Scal(-ErrPart(Mu_2),ErrPart(Mu_2));
            Psi:=ScalZero;
         end if;
         Belt(2):=ResetErr(Mu_2);
         for J in 1..K2-2 loop
            N2:=Scal(Rep(J));
            Co1:=XiOverKappa*(EiExp(InIAm/N2,N2*IAm,NumErr)-EiExp(InIAp/N2,N2*IAp,NumErr)); --pi*mu_(2+k)(r)
            Co2:=XiOverKappa*(EiExp(InIAm/(-N2),(-N2)*IAm,NumErr)-EiExp(InIAp/(-N2),(-N2)*IAp,NumErr)); --pi*mu_{2-k}(r)
            Belt(2-J):=ResetErr(Co1/ScalPi);
            Belt(J+2):=ResetErr(Co2/ScalPi);
            --bound on the essential supremum for I-th radius
            if not Trunc then
               EssSup:=AbsVal(Mu_2+(Sqr(ScalPi)/Rep(6.0)-ScalPi*Psi/Two+Sqr(Psi)/Four)*A
                              +(ScalPi**4/Rep(90.0)-Sqr(ScalPi)*Sqr(Psi)/Rep(12.0)+ScalPi*Psi**3/Rep(12.0)-Psi**4/Rep(48.0))*B
                              +(ScalPi-Psi)/Two*C
                              +(Sqr(ScalPi)*Psi/Rep(6.0)-ScalPi*Sqr(Psi)/Four+Psi**3/Rep(12.0))*Di
                              +((ScalPi**4)*Psi/Rep(90.0)-Sqr(ScalPi)*Psi**3/Rep(36.0)+ScalPi*Psi**4/Rep(48.0)-Psi**5/Rep(240.0))*E);
               EtaEssSup:=Abs(Err_Mu_2+(Sqr(ScalPi)/Rep(6.0)-ScalPi*Psi/Two+Sqr(Psi)/Four)*Scal(-Sup(ErrA),Sup(ErrA))
                              +(ScalPi**4/Rep(90.0)-Sqr(ScalPi)*Sqr(Psi)/Rep(12.0)+ScalPi*Psi**3/Rep(12.0)-Psi**4/Rep(48.0))*Scal(-Sup(ErrB),Sup(ErrB))
                              +(ScalPi-Psi)/Two*Scal(-Sup(ErrC),Sup(ErrC))
                              +(Sqr(ScalPi)*Psi/Rep(6.0)-ScalPi*Sqr(Psi)/Four+Psi**3/Rep(12.0))*Scal(-Sup(ErrD),Sup(ErrD))
                              +((ScalPi**4)*Psi/Rep(90.0)-Sqr(ScalPi)*Psi**3/Rep(36.0)+ScalPi*Psi**4/Rep(48.0)-Psi**5/Rep(240.0))*Scal(-Sup(ErrE),Sup(ErrE)));

               if Sup(EssSup)>Sup(EsSup) then
                  EsSup:=EssSup;
               end if;
               if Sup(EtaEssSup)>Sup(EtaEsSup) then
                  EtaEsSup:=EtaEssSup;
               end if;
               Psi:=Scal(Sup(Psi),Sup(Psi)+Sup(Del));
            end if;
         end loop;
         if not Trunc then
            EsSup:=EsSup+ScalPi**6/Rep(945.0)*Remain;
            EtaEsSup:=EtaEsSup+Half*ScalPi*AbsVal(AprC)+S2*AbsVal(AprA)+S4*AbsVal(AprB)+S3*AbsVal(AprD)+S5*AbsVal(AprE)+ScalPi**6/Rep(945.0)*Remain;
            Delta1(I):=ScalPi*Exp((Pex-Two)*Log(Scal(Sup(EtaEsSup))))*(E0+E1*S4+E2*S8+E3*S6+E4*S2+E5*S6+E6*S10+E7*S4+E8*S8+E9*S6+E10*Sum4+E11*Sum8+E12*Sum6+E13*Sum2+E14*Sum6+E15*Sum10+E16*Sum4+E17*Sum8+E18*Sum6);
            Delta2(I):=E19*S12;
            --            New_Line;
            --            Put("Delta1(I)=");Show(Delta1(I));
            --            Put("E0=");Show(E0);
            --            Put("E4*S2=");Show(E4*S2);
         end if;
         Ic:=(100*(I-H'First(1)))/H'Length(1);
         if Ic/=Ip then
            New_Line;
            Put("%");ShortPut(Ic);
            EndTime:=Clock;
            Put(" accomplished in ");Put(Item=>(Integer(Seconds(EndTime)-Seconds(StartTime))/60), Width =>4);Put(" minutes");
         end if;
         Ip:=Ic;

         --Multiplication proper
         if not Trunc then
            MultEssSup:=ScalZero;
            RoDiff:=(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
            L2Sum:=ScalZero;
            for J in K1+H'First(2)..H'First(2)-1 loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(H'First(2),J-K2).. IMin(H'Last(2),J-K1) loop
                  EE:=EE+H(I,L)*Belt(J-L);
               end loop;
               MultEssSup:=MultEssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
         end if;

         for J in H'First(2)..H'Last(2) loop
            if I>(H'First(1)+1) then
               H(I-1,J):=Coeff(J)+BeltP(J);
            end if;
            Coeff(J):=CoZero;
            for K in IMax(J-H'Last(2),K1)..IMin(J-H'First(2),K2) loop
               Coeff(J):=Coeff(J)+H(I,J-K)*Belt(K);
            end loop;
         end loop;

         if not Trunc  then
            for J in H'Last(2)+1..K2+H'Last(2) loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(H'First(2),J-K2).. IMin(H'Last(2),J-K1) loop
                  EE:=EE+H(I,L)*Belt(J-L);
               end loop;
               MultEssSup:=MultEssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
            if Sup(MultEssSup)>Zero then
               MultError:=MultError+ScalPi*Exp((Pex-Two)*Log(Scal(Sup(MultEssSup))))*RoDiff*L2Sum;
            end if;
         end if;
         BeltP:=Belt;
      end loop;
      for J in H'Range(2) loop
         H(H'Last(1),J):=Coeff(J)+Belt(J);
      end loop;
   end ProdAddBeltramiF;


   procedure ProdAddBeltrami(NumErr,Pex: in Rep; Ro,ThickRad: in ScalArray; Q: in Taylor;H: in out CompMatrix;
                             Delta1,Delta2: out ScalArray; EsSup,MultError: out Scalar; IsPoly: in Boolean:=True) is
      use Ada.Calendar;
      --mu:=e^(2 I Ang)*(A*Ang+B+C)/(A*Ang+B-C)=e^(2 I Ang) -e^(2 I Ang)*(2*C/A)/(Ang+(B-C)/A)
       AprA,AprB,AprC,AprD,AprE,CC1,CC2,C1,C2,Appro,D,DD,RD,RRD,RDD,RRDD,RDP,RDDP,DerF,DerIF,DerDerF,DerDerIF,InIAp,InIAm,IAp,IAm,XiOverKappa,C2PC2,C1PC1,L,Bp,Bm,AmOverAp,A,B,Mu_2,Co1,Co2,C,E,AlphaP,AlphaM,Di,EE: Comp;
      ZetaM,ZetaP,ZetaMP,ZetaPP,Xi,XiP,DerC,DerA,DerB,DerD,DerE,Kappa,KappaP,Der_Mu_2: Comp;
      ErrB,ErrA,ErrC,ErrD,ErrE,Psi,E0,E1,E2,E3,E4,E5,E6,E7,E8,E9,E10,E11,E12,E13,E14,E15,E16,E17,E18,E19: Scalar;
      Remain,Err_Mu_2,RoDiff,N2,CP,CM,EtaEsSup,EtaEssSup,EssSup,Sum2,Sum3,Sum4,Sum5,Sum6,Sum7,Sum8,Sum10,Sum12,S2,S3,S4,S5,S6,S7,S8,S10,S12,R5P,R5M,ErrRo,L2Sum,MultEssSup: Scalar;
      Rho1: Rep:=Rep(0.8)*Rho;
      M: constant Integer:=4101;
      Ic,Ip: Integer;
      Del: Scalar:=Two*ScalPi/Rep(M);
      StartTime, EndTime: Time;
      SPex: constant Scalar:=Scal(Pex);
      K1: Integer:=2-(M-1)/2;
      K2:  Integer:=(M-1)/2+2;
      Belt,BeltP: CompArray(K1..K2);
      Coeff: CompArray(H'Range(2));
   begin
      StartTime:=Clock;
      Ic:=0;
      Ip:=0;
      SetZero(Delta1);
      SetZero(Delta2);
      EsSup:=ScalZero;

      if not Trunc then
         Sum2:=ScalZero;
         Sum3:=ScalZero;
         Sum4:=ScalZero;
         Sum5:=ScalZero;
         Sum6:=ScalZero;
         Sum7:=ScalZero;
         Sum8:=ScalZero;
         Sum10:=ScalZero;
         Sum12:=ScalZero;
         for J in 1..M loop
            Sum2:=Sum2+ScalOne/Sqr(Scal(J));
            Sum3:=Sum3+ScalOne/Scal(J)**3;
            Sum4:=Sum4+ScalOne/Scal(J)**4;
            Sum5:=Sum5+ScalOne/Scal(J)**5;
            Sum6:=Sum6+ScalOne/Scal(J)**6;
            Sum7:=Sum7+ScalOne/Scal(J)**7;
            Sum8:=Sum8+ScalOne/Scal(J)**8;
            Sum10:=Sum10+ScalOne/Scal(J)**10;
            Sum12:=Sum12+ScalOne/Scal(J)**12;
         end loop;
         --Remainders of Riemann zeta functions: zeta_{M+1}(n)
         S2:=Sqr(ScalPi)/Rep(6.0)-Sum2;
         S3:=Scal(Rep(1.2020569033))-Sum3;
         S4:=ScalPi**4/Rep(90.0)-Sum4;
         S5:=ScalPi**5/Rep(295.0)-Sum5;
         S6:=ScalPi**6/Rep(945.0)-Sum6;
         S7:=ScalPi**7/Rep(2995.0)-Sum7;
         S8:=ScalPi**8/Rep(9450.0)-Sum8;
         S10:=ScalPi**10/Rep(93555.0)-Sum10;
         S12:=Rep(691.0)*ScalPi**12/Rep(638512875.0)-Sum12;
      end if;

      for I in H'Range(1) loop
         EtaEsSup:=ScalZero;
         RoDiff:=(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
         ErrRo:=Scal(-Err(ThickRad(I)),Err(ThickRad(I)));
         Parametrize_2(ThickRad(I),C2,D,RD,RDD,CC2,DD,RRD,RRDD); -- C2 is lambda(r), D is lambda'(r), RD is r*lambda'(r)
         if I=H'First(1) then
            if Quad then
               Appro:=ResetErr(C2);
            else
               Appro:=Complecs(-Approx(RePart(C2)),Approx(ImPart(C2)));
            end if;
         end if;
         C1:=Appro;
         Newton(1,Rho,C1,Q,C2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
         DerF:=DerVal(1,Rho,SupMod(C1),C1,Q);--inverse of Df^{-q_n}(lambda(r))
         DerIF:=Inv(DerF);

         C2PC2:=(C2-P)*C2; C1PC1:=(C1-P)*C1;
         L:=Log((C1-P)*C2/(C1*(C2-P)));
         RDP:=RD*P;--r*lambda'(r)*p
         InIAp:=ResetErr((DerIF/C1PC1-Inv(C2PC2))/(Two*ScalPi*IBall/C2PC2+L/RDP)); --1/(i*alpha_+)
         InIAm:=ResetErr((Inv(C1PC1)-DerF/C2PC2)/(Two*ScalPi*IBall/C1PC1+DerF*L/RDP)); --1/(i*alpha_-)
         AlphaP:=(Two*ScalPi*Inv(C2PC2)-IBall*L/RDP)/(DerIF/C1PC1-Inv(C2PC2)); --i*alpha_+
         AlphaM:=(Two*ScalPi*Inv(C1PC1)-IBall*DerF*L/RDP)/(Inv(C1PC1)-DerF/C2PC2); --i*alpha_-
         IAp:=ResetErr(IBall*AlphaP); --i*alpha_+
         IAm:=ResetErr(IBall*AlphaM); --i*alpha_-
         AmOverAp:=(Two*ScalPi*DerIF/C1PC1-IBall*L/RDP)/(Two*ScalPi*Inv(C2PC2)-IBall*L/RDP);   --alpha_- / alpha_+
         XiOverKappa:= IBall*C2PC2*C1PC1*L/(RDP*(C2PC2*DerIF-C1PC1)); --xi/kappa

         --Stuff for L-p error and essential supremum
         if not Trunc then
            Bp:=Neg(Inv(CoOne+Two*ScalPi*IBall*RDP/(C2PC2*L))); --xi/(zeta_+ - xi)
            Bm:=Neg(Inv(CoOne+Two*ScalPi*IBall*RDP*DerIF/(C1PC1*L))); --xi/(zeta_- - xi)

            A:=Two*(Bp/AlphaP-Bm/AlphaM)/ScalPi;  --A(r)
            B:=Rep(6.0)*(Bm/(AlphaM**3)-Bp/(AlphaP**3))/ScalPi;  --B(r)
            C:=Two*(Bp-Bm)/ScalPi; --C(r)
            Di:=Four*(Bm/Sqr(AlphaM)-Bp/Sqr(AlphaP))/ScalPi; --D(r)
            E:=Rep(8.0)*(Bp/(AlphaP**4)-Bm/(AlphaM**4))/ScalPi;  --E(r)

            CC1:=Appro;
            Newton(1,Rho,CC1,Q,CC2,IsPoly);  -- C1 is f^{-q_n}(lambda(r)
            DerF:=DerVal(1,Rho,SupMod(CC1),CC1,Q);--inverse of Df^{-q_n}(lambda(r))
            DerIF:=Inv(DerF);
            DerDerF:=DerDerVal(1,Rho,SupMod(CC1),CC1,Q);
            DerDerIF:=Neg(DerDerF)*Inv(Sqr(DerF)*DerF);
            C2PC2:=(CC2-P)*CC2; C1PC1:=(CC1-P)*CC1;
            L:=Log((CC1-P)*CC2/(CC1*(CC2-P)));
            RDP:=RRD*P;--r*lambda'(r)*p
            RDDP:=RRDD*P;

            Xi:=IBall*L/(Two*ScalPi); --i*a*xi
            XiP:=IBall*DD*(P*DerIF/C1PC1-P/C2PC2)/(Two*ScalPi); --i*a*xi'
            ZetaP:=RDP/C2PC2;
            ZetaM:=RDP*DerIF/C1PC1;
            Kappa:=(ZetaM-ZetaP)/(Two*ScalPi);
            ZetaPP:=DD*P/C2PC2+RDDP/C2PC2+RDP*DD*(P-Two*CC2)/Sqr(C2PC2);
            ZetaMP:=DD*P*DerIF/C1PC1+RDDP*DerIF/C1PC1+RDP*DD*(P-Two*CC1)*Sqr(DerIF)/Sqr(C1PC1)+RDP*DD*DerDerIF/C1PC1;
            KappaP:=(ZetaMP-ZetaPP)/(Two*ScalPi);

            DerC:=Two*((XiP*ZetaP-Xi*ZetaPP)/Sqr(ZetaP-Xi)-(XiP*ZetaM-Xi*ZetaMP)/Sqr(ZetaM-Xi))/ScalPi; --C(r)'
            DerA:=Two*(XiP*Kappa+KappaP*Xi)*(Sqr(Inv(ZetaP-Xi))-Sqr(Inv(ZetaM-Xi)))/ScalPi-Four*Xi*Kappa*((ZetaPP-XiP)/(ZetaP-Xi)**3-(ZetaMP-XiP)/(ZetaM-Xi)**3)/ScalPi; --A(r)'
            DerB:=Rep(6.0)*(XiP*Kappa**3+Three*Sqr(Kappa)*KappaP*Xi)*(Inv(ZetaM-Xi)**4-Inv(ZetaP-Xi)**4)/ScalPi-Rep(24.0)*Xi*Kappa**3*((ZetaMP-XiP)/(ZetaM-Xi)**5-(ZetaPP-XiP)/(ZetaP-Xi)**5)/ScalPi; --B(r)'
            DerD:=Four*(XiP*Kappa**2+Two*Kappa*KappaP*Xi)*(Inv(ZetaM-Xi)**3-Inv(ZetaP-Xi)**3)/ScalPi-Rep(12.0)*Xi*Kappa**2*((ZetaMP-XiP)/(ZetaM-Xi)**4-(ZetaPP-XiP)/(ZetaP-Xi)**4)/ScalPi; --D(r)'
            DerE:=Rep(8.0)*(XiP*Kappa**4+Four*Kappa**3*KappaP*Xi)*(Inv(ZetaP-Xi)**5-Inv(ZetaM-Xi)**5)/ScalPi-Rep(40.0)*Xi*Kappa**4*((ZetaPP-XiP)/(ZetaP-Xi)**6-(ZetaMP-XiP)/(ZetaM-Xi)**6)/ScalPi; --E(r)'

            A:=A+ErrRo*DerA;
            B:=B+ErrRo*DerB;
            C:=C+ErrRo*DerC;
            Di:=Di+ErrRo*DerD;
            E:=E+ErrRo*DerE;

            ErrA:=Scal(ErrPart(A));
            AprA:=ResetErr(A);
            ErrB:=Scal(ErrPart(B));
            AprB:=ResetErr(B);
            ErrC:=Scal(ErrPart(C));
            AprC:=ResetErr(C);
            ErrD:=Scal(ErrPart(Di));
            AprD:=ResetErr(Di);
            ErrE:=Scal(ErrPart(E));
            AprE:=ResetErr(E);

            R5P:=Rep(720.0)*AbsVal(AlphaP)**(-6);--R_5(i alpha_+)
            R5M:=Rep(720.0)*AbsVal(AlphaM)**(-6);--R_5(i alpha_-)
            CP:=AbsVal(IAp)-abs(ImPart(IAp))+ScalTwo;
            CM:=AbsVal(IAm)-abs(ImPart(IAm))+ScalTwo;
            Remain:=AbsVal(CP*R5P*Bp+CM*R5M*Bm)/ScalPi; --|R_-(r)|+|R_+(r)|

            --||eta||^2_2
            E1:=RoDiff*Sqr(AbsVal(A));  --*S4
            E2:=RoDiff*Sqr(AbsVal(B));  --*S8
            E3:=Two*RoDiff*RePart(A*Conj(B)); --*S6

            E4:=RoDiff*Sqr(AbsVal(C)); --*S2
            E5:=RoDiff*Sqr(AbsVal(Di)); --*S6
            E6:=RoDiff*Sqr(AbsVal(E)); --*S10
            E7:=Two*RoDiff*RePart(C*Conj(Di)); --*S4
            E8:=Two*RoDiff*RePart(E*Conj(Di)); --*S8
            E9:=Two*RoDiff*RePart(C*Conj(E)); --*S6

            E10:=RoDiff*Sqr(ErrA);  --*S4
            E11:=RoDiff*Sqr(ErrB);  --*S8
            E12:=Two*RoDiff*ErrA*ErrB; --*S6

            E13:=RoDiff*Sqr(ErrC); --*S2
            E14:=RoDiff*Sqr(ErrD); --*S6
            E15:=RoDiff*Sqr(ErrE); --*S10
            E16:=Two*RoDiff*ErrC*ErrD; --*S4
            E17:=Two*RoDiff*ErrE*ErrD; --*S8
            E18:=Two*RoDiff*ErrC*ErrE; --*S6

            E19:=RoDiff*Sqr(Remain); --*S12
         end if;
         --mu_{2 +- k}, L-2 error and essential supremum
         Mu_2:=CoOne+XiOverKappa*Log(AmOverAp)/ScalPi;
         Der_Mu_2:=(((XiP*Kappa-Xi*KappaP)/Sqr(Kappa))*(Log(ZetaM-Xi)-Log(ZetaP-Xi))/ScalPi+
                    CoOne/Kappa*((ZetaMP-XiP)/(ZetaM/Xi-CoOne)-(ZetaPP-XiP)/(ZetaP/Xi-CoOne))/ScalPi);
         Mu_2:=Mu_2+ErrRo*Der_Mu_2;
         --         New_Line;
         --         Put("mu_2(r)="); Show(Mu_2);
         if not Trunc then
            E0:=RoDiff*Sqr(Scal(ErrPart(Mu_2)));
            Err_Mu_2:=Scal(-ErrPart(Mu_2),ErrPart(Mu_2));
            Psi:=ScalZero;
         end if;
         Belt(2):=ResetErr(Mu_2);
         for J in 1..K2-2 loop
            N2:=Scal(Rep(J));
            Co1:=XiOverKappa*(EiExp(InIAm/N2,N2*IAm,NumErr)-EiExp(InIAp/N2,N2*IAp,NumErr)); --pi*mu_(2+k)(r)
            Co2:=XiOverKappa*(EiExp(InIAm/(-N2),(-N2)*IAm,NumErr)-EiExp(InIAp/(-N2),(-N2)*IAp,NumErr)); --pi*mu_{2-k}(r)
            Belt(2-J):=ResetErr(Co1/ScalPi);
            Belt(J+2):=ResetErr(Co2/ScalPi);
            --bound on the essential supremum for I-th radius
            if not Trunc then
               EssSup:=AbsVal(Mu_2+(Sqr(ScalPi)/Rep(6.0)-ScalPi*Psi/Two+Sqr(Psi)/Four)*A
                              +(ScalPi**4/Rep(90.0)-Sqr(ScalPi)*Sqr(Psi)/Rep(12.0)+ScalPi*Psi**3/Rep(12.0)-Psi**4/Rep(48.0))*B
                              +(ScalPi-Psi)/Two*C
                              +(Sqr(ScalPi)*Psi/Rep(6.0)-ScalPi*Sqr(Psi)/Four+Psi**3/Rep(12.0))*Di
                              +((ScalPi**4)*Psi/Rep(90.0)-Sqr(ScalPi)*Psi**3/Rep(36.0)+ScalPi*Psi**4/Rep(48.0)-Psi**5/Rep(240.0))*E);
               EtaEssSup:=Abs(Err_Mu_2+(Sqr(ScalPi)/Rep(6.0)-ScalPi*Psi/Two+Sqr(Psi)/Four)*Scal(-Sup(ErrA),Sup(ErrA))
                              +(ScalPi**4/Rep(90.0)-Sqr(ScalPi)*Sqr(Psi)/Rep(12.0)+ScalPi*Psi**3/Rep(12.0)-Psi**4/Rep(48.0))*Scal(-Sup(ErrB),Sup(ErrB))
                              +(ScalPi-Psi)/Two*Scal(-Sup(ErrC),Sup(ErrC))
                              +(Sqr(ScalPi)*Psi/Rep(6.0)-ScalPi*Sqr(Psi)/Four+Psi**3/Rep(12.0))*Scal(-Sup(ErrD),Sup(ErrD))
                              +((ScalPi**4)*Psi/Rep(90.0)-Sqr(ScalPi)*Psi**3/Rep(36.0)+ScalPi*Psi**4/Rep(48.0)-Psi**5/Rep(240.0))*Scal(-Sup(ErrE),Sup(ErrE)));

               if Sup(EssSup)>Sup(EsSup) then
                  EsSup:=EssSup;
               end if;
               if Sup(EtaEssSup)>Sup(EtaEsSup) then
                  EtaEsSup:=EtaEssSup;
               end if;
               Psi:=Scal(Sup(Psi),Sup(Psi)+Sup(Del));
            end if;
         end loop;
         if not Trunc then
            EsSup:=EsSup+ScalPi**6/Rep(945.0)*Remain;
            EtaEsSup:=EtaEsSup+Half*ScalPi*AbsVal(AprC)+S2*AbsVal(AprA)+S4*AbsVal(AprB)+S3*AbsVal(AprD)+S5*AbsVal(AprE)+ScalPi**6/Rep(945.0)*Remain;
            Delta1(I):=ScalPi*Exp((Pex-Two)*Log(Scal(Sup(EtaEsSup))))*(E0+E1*S4+E2*S8+E3*S6+E4*S2+E5*S6+E6*S10+E7*S4+E8*S8+E9*S6+E10*Sum4+E11*Sum8+E12*Sum6+E13*Sum2+E14*Sum6+E15*Sum10+E16*Sum4+E17*Sum8+E18*Sum6);
            Delta2(I):=E19*S12;
            --            New_Line;
            --            Put("Ess sup=");Show(EsSup);
            --            Put("Delta1(I)=");Show(Delta1(I));
            --            Put("E0=");Show(E0);
            --            Put("E4*S2=");Show(E4*S2);
         end if;
         Ic:=(100*(I-H'First(1)))/H'Length(1);
         if Ic/=Ip then
            New_Line;
            Put("%");ShortPut(Ic);
            EndTime:=Clock;
            Put(" accomplished in ");Put(Item=>(Integer(Seconds(EndTime)-Seconds(StartTime))/60), Width =>4);Put(" minutes");
         end if;
         Ip:=Ic;

         if not Trunc then
            MultEssSup:=ScalZero;
            RoDiff:=(Ro(I)-Ro(I-1))*(Ro(I)+Ro(I-1));
            L2Sum:=ScalZero;
            for J in K1+H'First(2)..H'First(2)-1 loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(H'First(2),J-K2).. IMin(H'Last(2),J-K1) loop
                  EE:=EE+H(I,L)*Belt(J-L);
               end loop;
               MultEssSup:=MultEssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
         end if;

         for J in H'First(2)..H'Last(2) loop
            if I>H'First(1) then
               H(I-1,J):=Coeff(J)+BeltP(J);
            end if;
            Coeff(J):=CoZero;
            for K in IMax(J-H'Last(2),K1)..IMin(J-H'First(2),K2) loop
               Coeff(J):=Coeff(J)+H(I,J-K)*Belt(K);
            end loop;
         end loop;

         if not Trunc  then
            for J in H'Last(2)+1..K2+H'Last(2) loop
               --Computing the J-th coeeficient of xi
               EE:=CoZero;
               for L in IMax(H'First(2),J-K2).. IMin(H'Last(2),J-K1) loop
                  EE:=EE+H(I,L)*Belt(J-L);
               end loop;
               MultEssSup:=MultEssSup+AbsVal(EE);
               L2Sum:=L2Sum+Sqr(AbsVal(EE));
            end loop;
            if Sup(MultEssSup)>Zero then
               MultError:=MultError+ScalPi*Exp((Pex-Two)*Log(Scal(Sup(MultEssSup))))*RoDiff*L2Sum;
            end if;
         end if;
         BeltP:=Belt;
      end loop;
      for J in H'Range(2) loop
         H(H'Last(1),J):=Coeff(J)+Belt(J);
      end loop;
   end ProdAddBeltrami;


   --HILBERT AND CAUCHY TRANSPORMS
   procedure Lin_T_Transform1(Iter: in Integer; R: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      -- V is the vector of values from the first radius of the next block
      pragma Suppress(Storage_Check);
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      C1,C2,C3,Eps: Scalar;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" & NM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" & CM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" & NM;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" & CM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  CM;
   begin
      if H'Last(1)>=-1 then
         Message("RG_Ops.Lin_T_Transform1",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_T_Transform1",Index_Error);
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-1 loop
         H(H'First(1),J):=CoZero;
         --I=H'First(1)+1
         Eps:=R(H'First(1)+1)-R(H'First(1));
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps) ;
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         H(H'First(1)+1,J):=H(H'First(1)+1,J+2)+R(H'First(1)+1)*C1*H(H'First(1),J+2)+R(H'First(1)+1)*C2*(H(H'First(1)+1,J+2)-H(H'First(1),J+2));
         --I<0
         for I in H'First(1)+2..H'Last(1) loop
            Eps:=R(I)-R(I-1);
            C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
            C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
            C3:=(R(I-1)/R(I))**(-J);
            H(I,J):=C3*( H(I-1,J)-H(I-1,J+2))+H(I,J+2)+C1*(ScalOne-C3)*( R(I)*H(I-1,J+2)-R(I-1)*H(I,J+2) )+C2*(R(I)/R(I-1)-C3)*R(I-1)*(H(I,J+2)-H(I-1,J+2));
         end loop;
      end loop;
      for J in Wn'Range loop
         Wn(J):=H(H'Last(1)-1,J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NONNEGATIVE J's
      --J=0 and J=1
      Eps:=R(H'Last(1)+1)-R(H'Last(1));
      C1:=Four/Eps;
      C2:=R(H'Last(1)+1)/R(H'Last(1));
      H(H'Last(1),0):=Wp(0)-Three*(V(2)-H(H'Last(1),2))-((Two/Eps)*Log(C2)*(R(H'Last(1)+1)*H(H'Last(1),2)-R(H'Last(1))*V(2)));
      H(H'Last(1),1):=(Wp(1)-V(3)-(C1*((C2-ScalOne)*(R(H'Last(1)+1)*H(H'Last(1),3)-R(H'Last(1))*V(3))+R(H'Last(1)+1)*Log(C2)*(V(3)-H(H'Last(1),3)) )))/C2+H(H'Last(1),3);
      for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
         Eps:=R(I+1)-R(I);
         C1:=Four/Eps;
         C2:=R(I+1)/R(I);
         H(I,0):=H(I+1,0)-H(I+1,2)+H(I,2)-((Two/Eps)*Log(C2)*(R(I+1)*H(I,2)-R(I)*H(I+1,2)) + Two*(H(I+1,2)-H(I,2)));
         H(I,1):=(H(I+1,1)-H(I+1,3)-(C1*((C2-ScalOne)*(R(I+1)*H(I,3)-R(I)*H(I+1,3))+R(I+1)*Log(C2)*(H(I+1,3)-H(I,3)) )))/C2+H(I,3);
      end loop;
      H(H'First(1),0):=H(H'First(1)+1,0)-Three*H(H'First(1)+1,2);
      H(H'First(1),1):=CoZero;
      --J>=2
      for J in 2..H'Last(2)-2 loop --nonnegative J's
         Eps:=R(H'Last(1)+1)-R(H'Last(1));
         C1:=Two*Scal(J+1)/(Scal(J)*Eps);
         C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
         C3:=(R(H'Last(1)+1)/R(H'Last(1)))**J;
         H(H'Last(1),J):=(Wp(J)-V(J+2)-(C1*(C3-ScalOne)*(R(H'Last(1)+1)*H(H'Last(1),J+2)-R(H'Last(1))*V(J+2))+C2*(C3-R(H'Last(1)+1)/R(H'Last(1)))*R(H'Last(1))*(V(J+2)-H(H'Last(1),J+2))))/C3+H(H'Last(1),J+2);
         for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            Eps:=R(I+1)-R(I);
            C1:=Two*Scal(J+1)/(Scal(J)*Eps);
            C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=(H(I+1,J)-H(I+1,J+2)-(C1*(C3-ScalOne)*(R(I+1)*H(I,J+2)-R(I)*H(I+1,J+2))+C2*(C3-R(I+1)/R(I))*R(I)*(H(I+1,J+2)-H(I,J+2))))/C3+H(I,J+2);
         end loop;
         H(H'First(1),J):=CoZero;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop --nonnegative J's
         C3:=(R(H'Last(1)+1)/R(H'Last(1)))**J;
         H(H'Last(1),J):=Wp(J)/C3;
         for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=H(I+1,J)/C3;
         end loop;
         H(H'First(1),J):=CoZero;
      end loop;
   end Lin_T_Transform1;


   procedure Const_T_Transform1(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      -- V is the vector of values from the first radius of the next block
      pragma Suppress(Storage_Check);
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      B: Comp;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" & NM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" & CM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" & NM;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" & CM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  CM;
   begin
      if H'Last(1)>=-1 then
         Message("RG_Ops.Const_T_Transform1",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_T_Transform1",Index_Error);
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-1 loop
         H(H'First(1),J):=CoZero;
         --I=H'First(1)+1
         C2:=(Ro(H'First(1))/ThickR( H'First(1)+1))**(-J);
         C4:=(Ro(H'First(1))/R(H'First(1)+1))**(-J);
         B:=Two*Scal(J+1)/(Scal(J))*((C2-ScalOne)*H(H'First(1)+1,J+2)-C2*H(H'First(1),J+2));
         H(H'First(1)+1,J):=H(H'First(1)+1,J+2)+B;
         B:=Two*Scal(J+1)/(Scal(J))*((C4-ScalOne)*H(H'First(1)+1,J+2)-C4*H(H'First(1),J+2));
         PH(J):=H(H'First(1)+1,J+2)+B; --exact c_k(r_i}
                                       --I<0
         for I in H'First(1)+2..H'Last(1) loop
            C1:=(R(I-1)/ThickR(I))**(-J);
            C2:=(Ro(I-1)/ThickR(I))**(-J);
            C3:=(R(I-1)/R(I))**(-J);
            C4:=(Ro(I-1)/R(I))**(-J);
            B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*H(I-1,J+2)+(C2-ScalOne)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I-1,J+2))+H(I,J+2)+B;
            B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*H(I-1,J+2)+(C4-ScalOne)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I-1,J+2))+H(I,J+2)+B; --exact c_k(r_i}
         end loop;
      end loop;
      for J in Wn'Range loop
         Wn(J):=PH(J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NONNEGATIVE J's
      --J=0
      C1:=R(H'Last(1)+1)/Ro(H'Last(1));
      C2:=Ro(H'Last(1))/ThickR(H'Last(1));
      C3:=Ro(H'Last(1))/R(H'Last(1));
      H(H'Last(1),0):=Wp(0)-V(2)-Two*Log(C1)*V(2)-Two*Log(C2)*H(H'Last(1),2)+H(H'Last(1),2);
      PH(0):=Wp(0)-V(2)-Two*Log(C1)*V(2)-Two*Log(C3)*H(H'Last(1),2)+H(H'Last(1),2);
      for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
         C1:=R(I+1)/Ro(I);
         C2:=Ro(I)/ThickR(I);
         C3:=Ro(I)/R(I);
         H(I,0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C2)*H(I,2)+H(I,2);
         PH(0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C3)*H(I,2)+H(I,2);
      end loop;
      C1:=R(H'First(1)+1)/Ro(H'First(1));
      H(H'First(1),0):=PH(0)-H(H'First(1)+1,2)-Two*Log(C1)*H(H'First(1)+1,2);
      --J>=1
      for J in 1..H'Last(2)-2 loop --nonnegative J's
         C1:=(ThickR(H'Last(1))/R(H'Last(1)+1))**J;
         C2:=(ThickR(H'Last(1))/Ro(H'Last(1)))**J;
         C3:=(R(H'Last(1))/R(H'Last(1)+1))**J;
         C4:=(R(H'Last(1))/Ro(H'Last(1)))**J;
         B:=Two*Scal(J+1)/(Scal(J))*((C2-C1)*V(J+2)+(ScalOne-C2)*H(H'Last(1),J+2));
         H(H'Last(1),J):=C1*(Wp(J)-V(J+2))+H(H'Last(1),J+2)-B;
         B:=Two*Scal(J+1)/(Scal(J))*((C4-C3)*V(J+2)+(ScalOne-C4)*H(H'Last(1),J+2));
         PH(J):=C3*(Wp(J)-V(J+2))+H(H'Last(1),J+2)-B; --exact c_k(r_i}
         for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            C1:=(ThickR(I)/R(I+1))**J;
            C2:=(ThickR(I)/Ro(I))**J;
            C3:=(R(I)/R(I+1))**J;
            C4:=(R(I)/Ro(I))**J;
            B:=Two*Scal(J+1)/(Scal(J))*((C2-C1)*H(I+1,J+2)+(ScalOne-C2)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I+1,J+2))+H(I,J+2)-B;
            B:=Two*Scal(J+1)/(Scal(J))*((C4-C3)*H(I+1,J+2)+(ScalOne-C4)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I+1,J+2))+H(I,J+2)-B; --exact c_k(r_i}
         end loop;
         H(H'First(1),J):=CoZero;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop --nonnegative J's
         C1:=(ThickR(H'Last(1))/R(H'Last(1)+1))**J;
         C3:=(R(H'Last(1))/R(H'Last(1)+1))**J;
         H(H'Last(1),J):=C1*Wp(J);
         PH(J):=C3*Wp(J);
         for I in reverse H'First(1)+1..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            C1:=(ThickR(I)/R(I+1))**J;
            C3:=(R(I)/R(I+1))**J;
            H(I,J):=C1*PH(J);
            PH(J):=C3*PH(J);
         end loop;
         H(H'First(1),J):=CoZero;
      end loop;
   end Const_T_Transform1;


   procedure Lin_T_Transform2(Iter: in Integer; R: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompMatrix(H'Range(1),0..1);
      Wp1,Wp2: CompArray(0..H'Last(2));
      Wn1,Wn2: CompArray(H'First(2)..-1);
      C1,C2,C3,Eps: Scalar;
      JJ: Integer;
      Wp2_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn2_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp2_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn2_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp2_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn2_Name: String:=Out_Dir & "vecs/n_" &  CM;
      Wp1_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn1_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp1_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn1_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp1_Name: String:=Out_Dir & "vecs/p_" &  CM;
      Wn1_Name: String:=Out_Dir & "vecs/n_" &  PM;
   begin
      if  H'Last(1)>=-1 then
         Message("RG_Ops.Lin_T_Transform2",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_T_Transform2",Index_Error);
      end if;

      for I in H'Range(1) loop
         P(I,0):=H(I,0);
         P(I,1):=H(I,1);
      end loop;

      --NONNEGATIVE J's
      --J=0 and J=1
      <<AGAIN1>> Read_T(Iter,Wp2_RLog,Wp2_WLog,Wp2_Name,Wp2,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN1;
      end if;
      Eps:=R(H'Last(1)+1)-R(H'Last(1));
      C1:=Four/Eps;
      C2:=R(H'Last(1)+1)/R(H'Last(1));
      H(H'Last(1),0):=Wp2(0)-Three*(V2(2)-H(H'Last(1),2))-((Two/Eps)*Log(C2)*(R(H'Last(1)+1)*H(H'Last(1),2)-R(H'Last(1))*V2(2)));
      H(H'Last(1),1):=(Wp2(1)-V2(3)-(C1*((C2-ScalOne)*(R(H'Last(1)+1)*H(H'Last(1),3)-R(H'Last(1))*V2(3))+R(H'Last(1)+1)*Log(C2)*(V2(3)-H(H'Last(1),3)) )))/C2+H(H'Last(1),3);
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=R(I+1)-R(I);
         C1:=Four/Eps;
         C2:=R(I+1)/R(I);
         H(I,0):=H(I+1,0)-H(I+1,2)+H(I,2)-((Two/Eps)*Log(C2)*(R(I+1)*H(I,2)-R(I)*H(I+1,2)) + Two*(H(I+1,2)-H(I,2)));
         H(I,1):=(H(I+1,1)-H(I+1,3)-(C1*((C2-ScalOne)*(R(I+1)*H(I,3)-R(I)*H(I+1,3))+R(I+1)*Log(C2)*(H(I+1,3)-H(I,3)) )))/C2+H(I,3);
      end loop;
      --J>=2
      for J in 2..H'Last(2)-2 loop
         JJ:=J+2;
         Eps:=R(H'Last(1)+1)-R(H'Last(1));
         C1:=Two*Scal(J+1)/(Scal(J)*Eps);
         C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
         C3:=(R(H'Last(1)+1)/R(H'Last(1)))**J;
         H(H'Last(1),J):=(Wp2(J)-V2(JJ)-(C1*(C3-ScalOne)*(R(H'Last(1)+1)*H(H'Last(1),JJ)-R(H'Last(1))*V2(JJ))+C2*(C3-R(H'Last(1)+1)/R(H'Last(1)))*R(H'Last(1))*(V2(JJ)-H(H'Last(1),JJ))))/C3+H(H'Last(1),JJ);
         for I in reverse H'First(1)..H'Last(1)-1 loop
            Eps:=R(I+1)-R(I);
            C1:=Two*Scal(J+1)/(Scal(J)*Eps);
            C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=(H(I+1,J)-H(I+1,JJ)-(C1*(C3-ScalOne)*(R(I+1)*H(I,JJ)-R(I)*H(I+1,JJ))+C2*(C3-R(I+1)/R(I))*R(I)*(H(I+1,JJ)-H(I,JJ))))/C3+H(I,JJ);
         end loop;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop
         C3:=(R(H'Last(1)+1)/R(H'Last(1)))**J;
         H(H'Last(1),J):=Wp2(J)/C3;
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=H(I+1,J)/C3;
         end loop;
      end loop;
      for J in Wp1'Range loop
         Wp1(J):=H(H'First(1),J);
      end loop;
      <<AGAIN2>> Write_T(Iter,Wp1_RLog,Wp1_WLog,Wp1_Name,Wp1 ,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN2;
      end if;
      <<AGAIN3>> Read_T(Iter,Wn1_RLog,Wn1_WLog,Wn1_Name,Wn1 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN3;
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-3 loop
         Eps:=R(H'First(1))-R(H'First(1)-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         H(H'First(1),J):=C3*( Wn1(J)-V1(J+2))+H(H'First(1),J+2)+C1*(ScalOne-C3)*( R(H'First(1))*V1(J+2)-R(H'First(1)-1)*H(H'First(1),J+2) )+C2*(R(H'First(1))/R(H'First(1)-1)-C3)*R(H'First(1)-1)*(H(H'First(1),J+2)-V1(J+2));
         --I<0
         for I in H'First(1)+1..H'Last(1) loop
            Eps:=R(I)-R(I-1);
            C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
            C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
            C3:=(R(I-1)/R(I))**(-J);
            H(I,J):=C3*( H(I-1,J)-H(I-1,J+2))+H(I,J+2)+C1*(ScalOne-C3)*( R(I)*H(I-1,J+2)-R(I-1)*H(I,J+2) )+C2*(R(I)/R(I-1)-C3)*R(I-1)*(H(I,J+2)-H(I-1,J+2));
         end loop;
      end loop;
      for J in  -2 .. -1 loop
         Eps:=R(H'First(1))-R(H'First(1)-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         H(H'First(1),J):=C3*(Wn1(J)-V1(J+2))+P(H'First(1),J+2)+C1*(ScalOne-C3)*( R(H'First(1))*V1(J+2)-R(H'First(1)-1)*P(H'First(1),J+2))+
           C2*(R(H'First(1))/R(H'First(1)-1)-C3)*R(H'First(1)-1)*(P(H'First(1),J+2)-V1(J+2));
         for I in H'First(1)+1..H'Last(1) loop
            Eps:=R(I)-R(I-1);
            C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
            C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
            C3:=(R(I-1)/R(I))**(-J);
            H(I,J):=C3*( H(I-1,J)-P(I-1,J+2))+P(I,J+2)+C1*(ScalOne-C3)*( R(I)*P(I-1,J+2)-R(I-1)*P(I,J+2) )+C2*(R(I)/R(I-1)-C3)*R(I-1)*(P(I,J+2)-P(I-1,J+2));
         end loop;
      end loop;
      for J in Wn2'Range loop
         Wn2(J):=H(H'Last(1),J);
      end loop;
      <<AGAIN4>> Write_T(Iter,Wn2_RLog,Wn2_WLog,Wn2_Name,Wn2,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN4;
      end if;
   end Lin_T_Transform2;


   procedure Const_T_Transform2(Iter: in Integer; R,Ro,ThickR: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompMatrix(H'Range(1),0..1);
      Wp1,Wp2: CompArray(0..H'Last(2));
      Wn1,Wn2: CompArray(H'First(2)..-1);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      B: Comp;
      Wp2_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn2_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp2_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn2_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp2_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn2_Name: String:=Out_Dir & "vecs/n_" &  CM;
      Wp1_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn1_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp1_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn1_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp1_Name: String:=Out_Dir & "vecs/p_" &  CM;
      Wn1_Name: String:=Out_Dir & "vecs/n_" &  PM;
   begin
      if  H'Last(1)>=-1 then
         Message("RG_Ops.Const_T_Transform2",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_T_Transform2",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I,0):=H(I,0);
         P(I,1):=H(I,1);
      end loop;

      --NONNEGATIVE J's
      --J=0 and J=1
      <<AGAIN1>> Read_T(Iter,Wp2_RLog,Wp2_WLog,Wp2_Name,Wp2,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN1;
      end if;
      --J=0
      C1:=R(H'Last(1)+1)/Ro(H'Last(1));
      C2:=Ro(H'Last(1))/ThickR(H'Last(1));
      C3:=Ro(H'Last(1))/R(H'Last(1));
      H(H'Last(1),0):=Wp2(0)-V2(2)-Two*Log(C1)*V2(2)-Two*Log(C2)*H(H'Last(1),2)+H(H'Last(1),2);
      PH(0):=Wp2(0)-V2(2)-Two*Log(C1)*V2(2)-Two*Log(C3)*H(H'Last(1),2)+H(H'Last(1),2);
      for I in reverse H'First(1)..H'Last(1)-1 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
         C1:=R(I+1)/Ro(I);
         C2:=Ro(I)/ThickR(I);
         C3:=Ro(I)/R(I);
         H(I,0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C2)*H(I,2)+H(I,2);
         PH(0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C3)*H(I,2)+H(I,2);
      end loop;
      --J>=1
      for J in 1..H'Last(2)-2 loop
         C1:=(ThickR(H'Last(1))/R(H'Last(1)+1))**J;
         C2:=(ThickR(H'Last(1))/Ro(H'Last(1)))**J;
         C3:=(R(H'Last(1))/R(H'Last(1)+1))**J;
         C4:=(R(H'Last(1))/Ro(H'Last(1)))**J;
         B:=Two*Scal(J+1)/(Scal(J))*((C2-C1)*V2(J+2)+(ScalOne-C2)*H(H'Last(1),J+2));
         H(H'Last(1),J):=C1*(Wp2(J)-V2(J+2))+H(H'Last(1),J+2)-B;
         B:=Two*Scal(J+1)/(Scal(J))*((C4-C3)*V2(J+2)+(ScalOne-C4)*H(H'Last(1),J+2));
         PH(J):=C3*(Wp2(J)-V2(J+2))+H(H'Last(1),J+2)-B; --exact c_k(r_i}
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/R(I+1))**J;
            C2:=(ThickR(I)/Ro(I))**J;
            C3:=(R(I)/R(I+1))**J;
            C4:=(R(I)/Ro(I))**J;
            B:=Two*Scal(J+1)/(Scal(J))*((C2-C1)*H(I+1,J+2)+(ScalOne-C2)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I+1,J+2))+H(I,J+2)-B;
            B:=Two*Scal(J+1)/(Scal(J))*((C4-C3)*H(I+1,J+2)+(ScalOne-C4)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I+1,J+2))+H(I,J+2)-B; --exact c_k(r_i}
         end loop;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop --nonnegative J's
         C1:=(ThickR(H'Last(1))/R(H'Last(1)+1))**J;
         C3:=(R(H'Last(1))/R(H'Last(1)+1))**J;
         H(H'Last(1),J):=C1*Wp2(J);
         PH(J):=C3*Wp2(J);
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/R(I+1))**J;
            C3:=(R(I)/R(I+1))**J;
            H(I,J):=C1*PH(J);
            PH(J):=C3*PH(J);
         end loop;
      end loop;
      for J in Wp1'Range loop
         Wp1(J):=PH(J);
      end loop;
      <<AGAIN2>> Write_T(Iter,Wp1_RLog,Wp1_WLog,Wp1_Name,Wp1 ,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN2;
      end if;
      <<AGAIN3>> Read_T(Iter,Wn1_RLog,Wn1_WLog,Wn1_Name,Wn1 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN3;
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-3 loop
         C1:=(R(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C2:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         C4:=(Ro(H'First(1)-1)/R(H'First(1)))**(-J);
         B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*V1(J+2)+(C2-ScalOne)*H(H'First(1),J+2));
         H(H'First(1),J):=C1*(Wn1(J)-V1(J+2))+H(H'First(1),J+2)+B;
         B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*V1(J+2)+(C4-ScalOne)*H(H'First(1),J+2));
         PH(J):=C3*(Wn1(J)-V1(J+2))+H(H'First(1),J+2)+B; --exact c_k(r_i}
                                                         --I<0
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(R(I-1)/ThickR(I))**(-J);
            C2:=(Ro(I-1)/ThickR(I))**(-J);
            C3:=(R(I-1)/R(I))**(-J);
            C4:=(Ro(I-1)/R(I))**(-J);
            B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*H(I-1,J+2)+(C2-ScalOne)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I-1,J+2))+H(I,J+2)+B;
            B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*H(I-1,J+2)+(C4-ScalOne)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I-1,J+2))+H(I,J+2)+B; --exact c_k(r_i}
         end loop;

      end loop;


      for J in  -2 .. -1 loop
         C1:=(R(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C2:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         C4:=(Ro(H'First(1)-1)/R(H'First(1)))**(-J);
         B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*V1(J+2)+(C2-ScalOne)*P(H'First(1),J+2));
         H(H'First(1),J):=C1*(Wn1(J)-V1(J+2))+P(H'First(1),J+2)+B;
         B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*V1(J+2)+(C4-ScalOne)*P(H'First(1),J+2));
         PH(J):=C3*(Wn1(J)-V1(J+2))+P(H'First(1),J+2)+B; --exact c_k(r_i}
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(R(I-1)/ThickR(I))**(-J);
            C2:=(Ro(I-1)/ThickR(I))**(-J);
            C3:=(R(I-1)/R(I))**(-J);
            C4:=(Ro(I-1)/R(I))**(-J);
            B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*P(I-1,J+2)+(C2-ScalOne)*P(I,J+2));
            H(I,J):=C1*(PH(J)-P(I-1,J+2))+P(I,J+2)+B;
            B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*P(I-1,J+2)+(C4-ScalOne)*P(I,J+2));
            PH(J):=C3*(PH(J)-P(I-1,J+2))+P(I,J+2)+B; --exact c_k(r_i}
         end loop;
      end loop;
      for J in Wn2'Range loop
         Wn2(J):=PH(J);
      end loop;
      <<AGAIN4>> Write_T(Iter,Wn2_RLog,Wn2_WLog,Wn2_Name,Wn2,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN4;
      end if;
   end Const_T_Transform2;


   procedure Lin_T_Transform3(Iter: in Integer; R: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompMatrix(H'Range(1),0..1);
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      C1,C2,C3,Eps: Scalar;
      JJ: Integer;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  PM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  CM;
   begin
      if H'First(1)>=-1 or H'Last(1)/=0 then
         Message("RG_Ops.Lin_T_Transform3",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_T_Transform3",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I,0):=H(I,0);
         P(I,1):=H(I,1);
      end loop;

      --NONNEGATIVE J's
      --I=0
      H(0,0):=CoZero;
      H(0,1):=CoZero;
      --I=-1;
      Eps:=R(0)-R(-1);
      C1:=Four/Eps;
      C2:=R(0)/R(-1);
      H(-1,0):=H(-1,2)-((Two/Eps)*Log(C2)*(R(0)*H(-1,2)-R(-1)*H(0,2)) + Two*(H(0,2)-H(-1,2)));
      H(-1,1):=H(-1,3)-(  C1*( (C2-ScalOne)*(R(0)*H(-1,3)-R(-1)*H(0,3))+R(0)*Log(C2)*(H(0,3)-H(-1,3)) ))/C2;
      --I<-1
      for I in reverse H'First(1)..-2 loop
         Eps:=R(I+1)-R(I);
         C1:=Four/Eps;
         C2:=R(I+1)/R(I);
         H(I,0):=H(I+1,0)-Three*(H(I+1,2)-H(I,2))-((Two/Eps)*Log(C2)*(R(I+1)*H(I,2)-R(I)*H(I+1,2)));
         H(I,1):=(H(I+1,1)-H(I+1,3)-(C1*((C2-ScalOne)*(R(I+1)*H(I,3)-R(I)*H(I+1,3))+R(I+1)*Log(C2)*(H(I+1,3)-H(I,3)) )))/C2+H(I,3);
      end loop;
      --J>=2
      for J in 2..H'Last(2)-2 loop --nonnegative J's
         JJ:=J+2;
         H(0,J):=CoZero;
         --I=-1
         Eps:=R(0)-R(-1);
         C1:=Two*Scal(J+1)/(Scal(J)*Eps);
         C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
         C3:=(R(0)/R(-1))**J;
         H(-1,J):=H(-1,JJ)-(C1*(C3-ScalOne)*(R(0)*H(-1,JJ)-R(-1)*H(0,JJ))+C2*(C3-R(0)/R(-1))*R(-1)*(H(0,JJ)-H(-1,JJ)))/C3;
         --I<-1
         for I in reverse H'First(1)..-2 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            Eps:=R(I+1)-R(I);
            C1:=Two*Scal(J+1)/(Scal(J)*Eps);
            C2:=Two*Scal(J+1)/(Scal(J-1)*Eps);
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=(H(I+1,J)-H(I+1,JJ)-(C1*(C3-ScalOne)*(R(I+1)*H(I,JJ)-R(I)*H(I+1,JJ))+C2*(C3-R(I+1)/R(I))*R(I)*(H(I+1,JJ)-H(I,JJ))))/C3+H(I,JJ);
         end loop;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop --nonnegative J's
         H(0,J):=CoZero;
         H(-1,J):=CoZero;
         --I<-1
         for I in reverse H'First(1)..-2 loop -- values for J>=0 inside  the circle minus zero, R(I)>0
            C3:=(R(I+1)/R(I))**J;
            H(I,J):=H(I+1,J)/C3;
         end loop;
      end loop;
      for J in Wp'Range loop
         Wp(J):=H(H'First(1),J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp ,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-3 loop
         --I=H'First(1)
         Eps:=R(H'First(1))-R(H'First(1)-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         H(H'First(1),J):=C3*( Wn(J)-V(J+2))+H(H'First(1),J+2)+C1*(ScalOne-C3)*( R(H'First(1))*V(J+2)-R(H'First(1)-1)*H(H'First(1),J+2) )+C2*(R(H'First(1))/R(H'First(1)-1)-C3)*R(H'First(1)-1)*(H(H'First(1),J+2)-V(J+2));
         for I in H'First(1)+1..-1 loop
            Eps:=R(I)-R(I-1);
            C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
            C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
            C3:=(R(I-1)/R(I))**(-J);
            H(I,J):=C3*( H(I-1,J)-H(I-1,J+2))+H(I,J+2)+C1*(ScalOne-C3)*( R(I)*H(I-1,J+2)-R(I-1)*H(I,J+2) )+C2*(R(I)/R(I-1)-C3)*R(I-1)*(H(I,J+2)-H(I-1,J+2));
         end loop;
         --I=0
         Eps:=R(0)-R(-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(-1)/R(0))**(-J);
         H(0,J):=C3*(H(-1,J)-H(-1,J+2))+C1*(ScalOne-C3)*( R(0)*H(-1,J+2)-R(-1)*H(0,J+2))  + C2*(R(0)/R(-1)-C3)*R(-1)*( H(0,J+2)-H(-1,J+2));
      end loop;
      --J:=-2,-1
      for J in -2 .. -1 loop
         --I=H'First(1)
         Eps:=R(H'First(1))-R(H'First(1)-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         H(H'First(1),J):=C3*( Wn(J)-V(J+2))+P(H'First(1),J+2)+C1*(ScalOne-C3)*( R(H'First(1))*V(J+2)-R(H'First(1)-1)*P(H'First(1),J+2) )+C2*(R(H'First(1))/R(H'First(1)-1)-C3)*R(H'First(1)-1)*(P(H'First(1),J+2)-V(J+2));
         for I in H'First(1)+1..-1 loop
            Eps:=R(I)-R(I-1);
            C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
            C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
            C3:=(R(I-1)/R(I))**(-J);
            H(I,J):=C3*( H(I-1,J)-P(I-1,J+2))+P(I,J+2)+C1*(ScalOne-C3)*( R(I)*P(I-1,J+2)-R(I-1)*P(I,J+2) )+C2*(R(I)/R(I-1)-C3)*R(I-1)*(P(I,J+2)-P(I-1,J+2));
         end loop;
         --I=0
         Eps:=R(0)-R(-1);
         C1:=Two*Scal(J+1)/(Scal(abs(J))*Eps);
         C2:=Two*Scal(J+1)/(Scal(abs(J)+1)*Eps);
         C3:=(R(-1)/R(0))**(-J);
         H(0,J):=C3*(H(-1,J)-P(-1,J+2))+C1*(ScalOne-C3)*( R(0)*P(-1,J+2)-R(-1)*P(0,J+2))  + C2*(R(0)/R(-1)-C3)*R(-1)*(P(0,J+2)-P(-1,J+2));
      end loop;
   end Lin_T_Transform3;


   procedure Const_T_Transform3(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompMatrix(H'Range(1),0..1);
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      B: Comp;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  PM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  CM;
   begin
      if H'First(1)>=-1 or H'Last(1)/=0 then
         Message("RG_Ops.Const_T_Transform3",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_T_Transform3",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I,0):=H(I,0);
         P(I,1):=H(I,1);
      end loop;

      --NONNEGATIVE J's
      --J=0
      C2:=Ro(H'Last(1))/ThickR(H'Last(1));
      C3:=Ro(H'Last(1))/R(H'Last(1));
      H(H'Last(1),0):=(-Two)*Log(C2)*H(H'Last(1),2)+H(H'Last(1),2);
      PH(0):=(-Two)*Log(C3)*H(H'Last(1),2)+H(H'Last(1),2);
      for I in reverse H'First(1)..H'Last(1)-1 loop
         C1:=R(I+1)/Ro(I);
         C2:=Ro(I)/ThickR(I);
         C3:=Ro(I)/R(I);
         H(I,0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C2)*H(I,2)+H(I,2);
         PH(0):=PH(0)-H(I+1,2)-Two*Log(C1)*H(I+1,2)-Two*Log(C3)*H(I,2)+H(I,2);
      end loop;
      --J>=1
      for J in 1..H'Last(2)-2 loop
         C2:=(ThickR(H'Last(1))/Ro(H'Last(1)))**J;
         C4:=(R(H'Last(1))/Ro(H'Last(1)))**J;
         B:=Two*Scal(J+1)/(Scal(J))*(ScalOne-C2)*H(H'Last(1),J+2);
         H(H'Last(1),J):=H(H'Last(1),J+2)-B;
         B:=Two*Scal(J+1)/(Scal(J))*(ScalOne-C4)*H(H'Last(1),J+2);
         PH(J):=H(H'Last(1),J+2)-B; --exact c_k(r_i}
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/R(I+1))**J;
            C2:=(ThickR(I)/Ro(I))**J;
            C3:=(R(I)/R(I+1))**J;
            C4:=(R(I)/Ro(I))**J;
            B:=Two*Scal(J+1)/(Scal(J))*((C2-C1)*H(I+1,J+2)+(ScalOne-C2)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I+1,J+2))+H(I,J+2)-B;
            B:=Two*Scal(J+1)/(Scal(J))*((C4-C3)*H(I+1,J+2)+(ScalOne-C4)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I+1,J+2))+H(I,J+2)-B; --exact c_k(r_i}
         end loop;
      end loop;
      for J in H'Last(2)-1..H'Last(2) loop --nonnegative J's
         H(H'Last(1),J):=CoZero;
         PH(J):=CoZero;
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/R(I+1))**J;
            C3:=(R(I)/R(I+1))**J;
            H(I,J):=C1*PH(J);
            PH(J):=C3*PH(J);
         end loop;
      end loop;
      for J in Wp'Range loop
         Wp(J):=PH(J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp ,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-3 loop
         C1:=(R(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C2:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         C4:=(Ro(H'First(1)-1)/R(H'First(1)))**(-J);
         B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*V(J+2)+(C2-ScalOne)*H(H'First(1),J+2));
         H(H'First(1),J):=C1*(Wn(J)-V(J+2))+H(H'First(1),J+2)+B;
         B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*V(J+2)+(C4-ScalOne)*H(H'First(1),J+2));
         PH(J):=C3*(Wn(J)-V(J+2))+H(H'First(1),J+2)+B; --exact c_k(r_i}
                                                       --I<0
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(R(I-1)/ThickR(I))**(-J);
            C2:=(Ro(I-1)/ThickR(I))**(-J);
            C3:=(R(I-1)/R(I))**(-J);
            C4:=(Ro(I-1)/R(I))**(-J);
            B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*H(I-1,J+2)+(C2-ScalOne)*H(I,J+2));
            H(I,J):=C1*(PH(J)-H(I-1,J+2))+H(I,J+2)+B;
            B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*H(I-1,J+2)+(C4-ScalOne)*H(I,J+2));
            PH(J):=C3*(PH(J)-H(I-1,J+2))+H(I,J+2)+B; --exact c_k(r_i}
         end loop;
      end loop;
      for J in  -2 .. -1 loop
         C1:=(R(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C2:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(-J);
         C3:=(R(H'First(1)-1)/R(H'First(1)))**(-J);
         C4:=(Ro(H'First(1)-1)/R(H'First(1)))**(-J);
         B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*V(J+2)+(C2-ScalOne)*P(H'First(1),J+2));
         H(H'First(1),J):=C1*(Wn(J)-V(J+2))+P(H'First(1),J+2)+B;
         B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*V(J+2)+(C4-ScalOne)*P(H'First(1),J+2));
         PH(J):=C3*(Wn(J)-V(J+2))+P(H'First(1),J+2)+B; --exact c_k(r_i}
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(R(I-1)/ThickR(I))**(-J);
            C2:=(Ro(I-1)/ThickR(I))**(-J);
            C3:=(R(I-1)/R(I))**(-J);
            C4:=(Ro(I-1)/R(I))**(-J);
            B:=Two*Scal(J+1)/(Scal(J))*((C1-C2)*P(I-1,J+2)+(C2-ScalOne)*P(I,J+2));
            H(I,J):=C1*(PH(J)-P(I-1,J+2))+P(I,J+2)+B;
            B:=Two*Scal(J+1)/(Scal(J))*((C3-C4)*P(I-1,J+2)+(C4-ScalOne)*P(I,J+2));
            PH(J):=C3*(PH(J)-P(I-1,J+2))+P(I,J+2)+B; --exact c_k(r_i}
         end loop;
      end loop;
   end Const_T_Transform3;


   procedure Lin_P_Transform1(Iter: in Integer; Rad: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --    pragma Suppress(Storage_Check);
      C: Comp;
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      Eps: Scalar;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  CM;
   begin
      if H'Last(1)>=0 then
         Message("RG_Ops.Lin_P_Transform1",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_P_Transform1",Index_Error);
      end if;

      --NEGATIVE J's
      for J in H'First(2)..-1 loop
         H(H'First(1),J):=CoZero;--value at zero
         for I in H'First(1)+1..H'Last(1) loop
            Eps:=Rad(I)-Rad(I-1);
            C:=(Two*Rad(I))/Scal(abs(J)+1)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+1))*(Rad(I)*H(I-1,J+1)-Rad(I-1)*H(I,J+1))/Eps+(Two*Sqr(Rad(I)))/Scal(abs(J)+2)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+2))*(H(I,J+1)-H(I-1,J+1))/Eps;
            if I=H'First(1)+1 then
               H(I,J):=C;
            else
               H(I,J):=(Rad(I-1)/Rad(I))**(-J)*H(I-1,J)+C;
            end if;
         end loop;
      end loop;
      for J in Wn'Range loop
         Wn(J):=H(H'Last(1),J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NONNEGATIVE J's
      --J=0,1,1
      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      C:=Two*(Rad(H'Last(1)+1)*H(H'Last(1),1)-Rad(H'Last(1))*V(1)) +(Sqr(Rad(H'Last(1)+1))-Sqr(Rad(H'Last(1))))*(V(1)-H(H'Last(1),1))/Eps;
      H(H'Last(1),0):=Wp(0)-C;
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=Two*(Rad(I+1)*H(I,1)-Rad(I)*H(I+1,1)) +(Sqr(Rad(I+1))-Sqr(Rad(I)))*(H(I+1,1)-H(I,1))/Eps;
         H(I,0):=H(I+1,0)-C;
      end loop;
      Eps:=Rad(H'First(1)+1)-Rad(H'First(1));
      C:=Two*(Rad(H'First(1)+1)*H(H'First(1),1)-Rad(H'First(1))*H(H'First(1)+1,1))+(Sqr(Rad(H'First(1)+1))-Sqr(Rad(H'First(1))))*(H(H'First(1)+1,1)-H(H'First(1),1))/Eps;
      H(H'First(1),0):=H(H'First(1)+1,0)-C;
      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      C:=(Two*Rad(H'Last(1)))*Log(Rad(H'Last(1)+1)/Rad(H'Last(1)))*(Rad(H'Last(1)+1)*H(H'Last(1),2)-Rad(H'Last(1))*V(2))/Eps+Two*Rad(H'Last(1))*(V(2)-H(H'Last(1),2));
      H(H'Last(1),1):=(Rad(H'Last(1))/Rad(H'Last(1)+1))*Wp(1)-C;
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=(Two*Rad(I))*Log(Rad(I+1)/Rad(I))*(Rad(I+1)*H(I,2)-Rad(I)*H(I+1,2))/Eps+Two*Rad(I)*(H(I+1,2)-H(I,2));
         H(I,1):=(Rad(I)/Rad(I+1))*H(I+1,1)-C;
      end loop;
      H(H'First(1),1):=CoZero;

      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      C:=(Two*Rad(H'Last(1)))*(ScalOne-Rad(H'Last(1))/Rad(H'Last(1)+1))*(Rad(H'Last(1)+1)*H(H'Last(1),3)-Rad(H'Last(1))*V(3))/Eps+Two*Sqr(Rad(H'Last(1)))*Log(Rad(H'Last(1)+1)/Rad(H'Last(1)))*(V(3)-H(H'Last(1),3))/Eps;
      H(H'Last(1),2):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**2*Wp(2)-C;
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=(Two*Rad(I))*(ScalOne-Rad(I)/Rad(I+1))*(Rad(I+1)*H(I,3)-Rad(I)*H(I+1,3))/Eps+Two*Sqr(Rad(I))*Log(Rad(I+1)/Rad(I))*(H(I+1,3)-H(I,3))/Eps;
         H(I,2):=(Rad(I)/Rad(I+1))**2*H(I+1,2)-C;
      end loop;
      H(H'First(1),2):=CoZero;
      --J>=3
      for J in 3..H'Last(2)-1 loop
         Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
         H(H'Last(1),J):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**J*Wp(J)-((Two*Rad(H'Last(1)))/Scal(J-1)*(ScalOne-(Rad(H'Last(1))/Rad(H'Last(1)+1))**(J-1))*(Rad(H'Last(1)+1)*H(H'Last(1),J+1)-Rad(H'Last(1))*V(J+1))/Eps+
                                                                     (Two*Sqr(Rad(H'Last(1))))/Scal(J-2)*(ScalOne-(Rad(H'Last(1))/Rad(H'Last(1)+1))**(J-2))*(V(J+1)-H(H'Last(1),J+1))/Eps);
         for I in reverse H'First(1)+1..H'Last(1)-1 loop
            Eps:=Rad(I+1)-Rad(I);
            H(I,J):=(Rad(I)/Rad(I+1))**J*H(I+1,J)-((Two*Rad(I))/Scal(J-1)*(ScalOne-(Rad(I)/Rad(I+1))**(J-1))*(Rad(I+1)*H(I,J+1)-Rad(I)*H(I+1,J+1))/Eps+(Two*Sqr(Rad(I)))/Scal(J-2)*(ScalOne-(Rad(I)/Rad(I+1))**(J-2))*(H(I+1,J+1)-H(I,J+1))/Eps);
         end loop;
         H(H'First(1),J):=CoZero;
      end loop;
      H(H'Last(1),H'Last(2)):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**(H'Last(2))*Wp(H'Last(2));
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         H(I,H'Last(2)):=(Rad(I)/Rad(I+1))**(H'Last(2))*H(I+1,H'Last(2));
      end loop;
      H(H'First(1),H'Last(2)):=CoZero;
   end Lin_P_Transform1;


   procedure Const_P_Transform1(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      Wp: CompArray(1..H'Last(2));
      Wn: CompArray(H'First(2)..0);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  CM;
   begin
      if  H'Last(1)>=-1 then
         Message("RG_Ops.Const_P_Transform1",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_P_Transform1",Index_Error);
      end if;

      --NONPOSITIVE J's
      for J in H'First(2)..0 loop
         H(H'First(1),J):=CoZero;
         PH(J):=CoZero;
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(Ro(I-1)/ThickR(I))**(1-J);
            C2:=(R(I-1)/ThickR(I))**(1-J);
            C3:=(Ro(I-1)/R(I))**(1-J);
            C4:=(R(I-1)/R(I))**(1-J);
            H(I,J):=(R(I-1)/ThickR(I))**(-J)*PH(J)+Two*ThickR(I)*((C1-C2)*H(I-1,J+1)+(ScalOne-C1)*H(I,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I-1)/R(I))**(-J)*PH(J)+Two*R(I)*((C3-C4)*H(I-1,J+1)+(ScalOne-C3)*H(I,J+1))/Scal(Rep(1-J));
         end loop;
      end loop;
      for J in Wn'Range loop
         Wn(J):=PH(J);
      end loop;
      <<AGAIN4>> Write_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN4;
      end if;
      <<AGAIN1>> Read_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN1;
      end if;

      --POSITIVE J's
      --J=1
      H(H'Last(1),1):=(ThickR(H'Last(1))/R(H'Last(1)+1))*Wp(1)-Two*ThickR(H'Last(1))*(Log(Ro(H'Last(1))/ThickR(H'Last(1)))*H(H'Last(1),2)+Log(R(H'Last(1)+1)/Ro(H'Last(1)))*V(2));
      PH(1):=(R(H'Last(1))/R(H'Last(1)+1))*Wp(1)-Two*R(H'Last(1))*(Log(Ro(H'Last(1))/R(H'Last(1)))*H(H'Last(1),2)+Log(R(H'Last(1)+1)/Ro(H'Last(1)))*V(2));
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         C1:=Log(Ro(I)/ThickR(I));
         C2:=Log(R(I+1)/Ro(I));
         C3:=Log(Ro(I)/R(I));
         H(I,1):=(ThickR(I)/R(I+1))*PH(1)-Two*ThickR(I)*(C1*H(I,2)+C2*H(I+1,2));
         PH(1):=(R(I)/R(I+1))*PH(1)-Two*R(I)*(C3*H(I,2)+C2*H(I+1,2));
      end loop;
      H(H'First(1),1):=CoZero;
      PH(1):=CoZero;
      --J>1
      for J in 2..H'Last(2)-1 loop
         C1:=(ThickR(H'Last(1))/Ro(H'Last(1)))**(J-1);
         C2:=(ThickR(H'Last(1))/R(H'Last(1)+1))**(J-1);
         C3:=(R(H'Last(1))/Ro(H'Last(1)))**(J-1);
         C4:=(R(H'Last(1))/R(H'Last(1)+1))**(J-1);
         H(H'Last(1),J):=(ThickR(H'Last(1))/R(H'Last(1)+1))**J*Wp(J)-Two*ThickR(H'Last(1))*((C1-ScalOne)*H(H'Last(1),J+1)+(C2-C1)*V(J+1))/Scal(Rep(1-J));
         PH(J):=(R(H'Last(1))/R(H'Last(1)+1))**J*Wp(J)-Two*R(H'Last(1))*((C3-ScalOne)*H(H'Last(1),J+1)+(C4-C3)*V(J+1))/Scal(Rep(1-J));
         for I in reverse H'First(1)+1..H'Last(1)-1 loop
            C1:=(ThickR(I)/Ro(I))**(J-1);
            C2:=(ThickR(I)/R(I+1))**(J-1);
            C3:=(R(I)/Ro(I))**(J-1);
            C4:=(R(I)/R(I+1))**(J-1);
            H(I,J):=(ThickR(I)/R(I+1))**J*PH(J)-Two*ThickR(I)*((C1-ScalOne)*H(I,J+1)+(C2-C1)*H(I+1,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I)/R(I+1))**J*PH(J)-Two*R(I)*((C3-ScalOne)*H(I,J+1)+(C4-C3)*H(I+1,J+1))/Scal(Rep(1-J));
         end loop;
         H(H'First(1),J):=CoZero;
         PH(J):=CoZero;
      end loop;
      H(H'Last(1),H'Last(2)):=(ThickR(H'Last(1))/R(H'Last(1)+1))**(H'Last(2))*Wp(H'Last(2));
      PH(H'Last(2)):=(R(H'Last(1))/R(H'Last(1)+1))**(H'Last(2))*Wp(H'Last(2));
      for I in reverse H'First(1)+1..H'Last(1)-1 loop
         H(I,H'Last(2)):=(ThickR(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
         PH(H'Last(2)):=(R(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
      end loop;
      H(H'First(1),H'Last(2)):=CoZero;
      PH(H'Last(2)):=CoZero;
   end Const_P_Transform1;


   procedure Lin_P_Transform2(Iter: in Integer; Rad: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix;  Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --    pragma Suppress(Storage_Check);
      P: CompArray(H'Range(1));
      Wp1,Wp2: CompArray(0..H'Last(2));
      Wn1,Wn2: CompArray(H'First(2)..-1);
      Eps: Scalar;
      JJ: Integer;
      Wp2_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn2_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp2_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn2_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp2_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn2_Name: String:=Out_Dir & "vecs/n_" &  CM;
      Wp1_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn1_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp1_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn1_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp1_Name: String:=Out_Dir & "vecs/p_" &  CM;
      Wn1_Name: String:=Out_Dir & "vecs/n_" &  PM;
   begin
      if H'Last(1)>=0 then
         Message("RG_Ops.Lin_P_Transform2",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_P_Transform2",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I):=H(I,0);
      end loop;

      --NONNEGATIVE J's
      --J=0,1,2
      <<AGAIN1>> Read_T(Iter,Wp2_RLog,Wp2_WLog,Wp2_Name,Wp2 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN1;
      end if;
      --J=0
      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      H(H'Last(1),0):=Wp2(0)-(Two*(Rad(H'Last(1)+1)*H(H'Last(1),1)-Rad(H'Last(1))*V2(1)) +(Sqr(Rad(H'Last(1)+1))-Sqr(Rad(H'Last(1))))*(V2(1)-H(H'Last(1),1))/Eps);
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         H(I,0):=H(I+1,0)-(Two*(Rad(I+1)*H(I,1)-Rad(I)*H(I+1,1)) +(Sqr(Rad(I+1))-Sqr(Rad(I)))*(H(I+1,1)-H(I,1))/Eps);
      end loop;
      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      H(H'Last(1),1):=(Rad(H'Last(1))/Rad(H'Last(1)+1))*Wp2(1)-((Two*Rad(H'Last(1)))*Log(Rad(H'Last(1)+1)/Rad(H'Last(1)))*(Rad(H'Last(1)+1)*H(H'Last(1),2)-Rad(H'Last(1))*V2(2))/Eps+Two*Rad(H'Last(1))*(V2(2)-H(H'Last(1),2)));
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         H(I,1):=(Rad(I)/Rad(I+1))*H(I+1,1)-((Two*Rad(I))*Log(Rad(I+1)/Rad(I))*(Rad(I+1)*H(I,2)-Rad(I)*H(I+1,2))/Eps+Two*Rad(I)*(H(I+1,2)-H(I,2)));
      end loop;
      Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
      H(H'Last(1),2):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**2*Wp2(2)-((Two*Rad(H'Last(1)))*(ScalOne-Rad(H'Last(1))/Rad(H'Last(1)+1))*(Rad(H'Last(1)+1)*H(H'Last(1),3)-Rad(H'Last(1))*V2(3))/Eps+
                                                                   Two*Sqr(Rad(H'Last(1)))*Log(Rad(H'Last(1)+1)/Rad(H'Last(1)))*(V2(3)-H(H'Last(1),3))/Eps);
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         H(I,2):=(Rad(I)/Rad(I+1))**2*H(I+1,2)-((Two*Rad(I))*(ScalOne-Rad(I)/Rad(I+1))*(Rad(I+1)*H(I,3)-Rad(I)*H(I+1,3))/Eps+Two*Sqr(Rad(I))*Log(Rad(I+1)/Rad(I))*(H(I+1,3)-H(I,3))/Eps);
      end loop;
      --J>=3
      for J in 3..H'Last(2)-1 loop
         JJ:=J+1;
         Eps:=Rad(H'Last(1)+1)-Rad(H'Last(1));
         H(H'Last(1),J):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**J*Wp2(J)-((Two*Rad(H'Last(1)))/Scal(J-1)*(ScalOne-(Rad(H'Last(1))/Rad(H'Last(1)+1))**(J-1))*(Rad(H'Last(1)+1)*H(H'Last(1),JJ)-Rad(H'Last(1))*V2(JJ))/Eps+
                                                                      (Two*Sqr(Rad(H'Last(1))))/Scal(J-2)*(ScalOne-(Rad(H'Last(1))/Rad(H'Last(1)+1))**(J-2))*(V2(JJ)-H(H'Last(1),JJ))/Eps);
         for I in reverse H'First(1)..H'Last(1)-1 loop
            Eps:=Rad(I+1)-Rad(I);
            H(I,J):=(Rad(I)/Rad(I+1))**J*H(I+1,J)-((Two*Rad(I))/Scal(J-1)*(ScalOne-(Rad(I)/Rad(I+1))**(J-1))*(Rad(I+1)*H(I,JJ)-Rad(I)*H(I+1,JJ))/Eps+(Two*Sqr(Rad(I)))/Scal(J-2)*(ScalOne-(Rad(I)/Rad(I+1))**(J-2))*(H(I+1,JJ)-H(I,JJ))/Eps);
         end loop;
      end loop;
      H(H'Last(1),H'Last(2)):=(Rad(H'Last(1))/Rad(H'Last(1)+1))**(H'Last(2))*Wp2(H'Last(2));
      for I in reverse H'First(1)..H'Last(1)-1 loop
         H(I,H'Last(2)):=(Rad(I)/Rad(I+1))**(H'Last(2))*H(I+1,H'Last(2));
      end loop;
      for J in Wp1'Range loop
         Wp1(J):=H(H'First(1),J);
      end loop;
      <<AGAIN2>> Write_T(Iter,Wp1_RLog,Wp1_WLog,Wp1_Name,Wp1,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN2;
      end if;
      <<AGAIN3>> Read_T(Iter,Wn1_RLog,Wn1_WLog,Wn1_Name,Wn1 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN3;
      end if;

      --NEGATIVE J's
      --J<=-2
      for J in H'First(2)..-2 loop
         Eps:=Rad(H'First(1))-Rad(H'First(1)-1);
         H(H'First(1),J):=(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J)*Wn1(J)+(Two*Rad(H'First(1)))/Scal(abs(J)+1)*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J+1))*(Rad(H'First(1))*V1(J+1)-Rad(H'First(1)-1)*H(H'First(1),J+1))/Eps+
           (Two*Sqr(Rad(H'First(1))))/Scal(abs(J)+2)*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J+2))*(H(H'First(1),J+1)-V1(J+1))/Eps;
         for I in H'First(1)+1..H'Last(1) loop
            Eps:=Rad(I)-Rad(I-1);
            H(I,J):=(Rad(I-1)/Rad(I))**(-J)*H(I-1,J)+(Two*Rad(I))/Scal(abs(J)+1)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+1))*(Rad(I)*H(I-1,J+1)-Rad(I-1)*H(I,J+1))/Eps+
              (Two*Sqr(Rad(I)))/Scal(abs(J)+2)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+2))*(H(I,J+1)-H(I-1,J+1))/Eps;
         end loop;
      end loop;
      --J=-1
      Eps:=Rad(H'First(1))-Rad(H'First(1)-1);
      H(H'First(1),-1):=(Rad(H'First(1)-1)/Rad(H'First(1)))*Wn1(-1)+Rad(H'First(1))*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**2)*(Rad(H'First(1))*V1(0)-Rad(H'First(1)-1)*P(H'First(1)))/Eps+
        (Two*Sqr(Rad(H'First(1))))/Three*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**3)*(P(H'First(1))-V1(0))/Eps;
      for I in H'First(1)+1..H'Last(1) loop
         Eps:=Rad(I)-Rad(I-1);
         H(I,-1):=(Rad(I-1)/Rad(I))*H(I-1,-1)+Rad(I)*(ScalOne-(Rad(I-1)/Rad(I))**2)*(Rad(I)*P(I-1)-Rad(I-1)*P(I))/Eps+(Two*Sqr(Rad(I)))/Three*(ScalOne-(Rad(I-1)/Rad(I))**3)*(P(I)-P(I-1))/Eps;
      end loop;
      for J in Wn2'Range loop
         Wn2(J):=H(H'Last(1),J);
      end loop;
      <<AGAIN4>> Write_T(Iter,Wn2_RLog,Wn2_WLog,Wn2_Name,Wn2,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN4;
      end if;
   end Lin_P_Transform2;


   procedure Const_P_Transform2(Iter: in Integer; R,Ro,ThickR: in ScalArray; V1,V2: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompArray(H'Range(1));
      Wp1,Wp2: CompArray(1..H'Last(2));
      Wn1,Wn2: CompArray(H'First(2)..0);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      Wp2_RLog: String:=Out_Dir & "logs/r_p_" &  NM;
      Wn2_WLog: String:=Out_Dir & "logs/w_n_" &  CM;
      Wp2_WLog: String:=Out_Dir & "logs/w_p_" &  NM;
      Wn2_RLog: String:=Out_Dir & "logs/r_n_" &  CM;
      Wp2_Name: String:=Out_Dir & "vecs/p_" &  NM;
      Wn2_Name: String:=Out_Dir & "vecs/n_" &  CM;
      Wp1_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn1_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp1_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn1_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp1_Name: String:=Out_Dir & "vecs/p_" &  CM;
      Wn1_Name: String:=Out_Dir & "vecs/n_" &  PM;
   begin
      if  H'Last(1)>=-1 then
         Message("RG_Ops.Const_P_Transform2",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_P_Transform2",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I):=H(I,1);
      end loop;

      --POSITIVE J's
      <<AGAIN1>> Read_T(Iter,Wp2_RLog,Wp2_WLog,Wp2_Name,Wp2 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN1;
      end if;
      --J=1
      H(H'Last(1),1):=(ThickR(H'Last(1))/R(H'Last(1)+1))*Wp2(1)-Two*ThickR(H'Last(1))*(Log(Ro(H'Last(1))/ThickR(H'Last(1)))*H(H'Last(1),2)+Log(R(H'Last(1)+1)/Ro(H'Last(1)))*V2(2));
      PH(1):=(R(H'Last(1))/R(H'Last(1)+1))*Wp2(1)-Two*R(H'Last(1))*(Log(Ro(H'Last(1))/R(H'Last(1)))*H(H'Last(1),2)+Log(R(H'Last(1)+1)/Ro(H'Last(1)))*V2(2));
      for I in reverse H'First(1)..H'Last(1)-1 loop
         C1:=Log(Ro(I)/ThickR(I));
         C2:=Log(R(I+1)/Ro(I));
         C3:=Log(Ro(I)/R(I));
         H(I,1):=(ThickR(I)/R(I+1))*PH(1)-Two*ThickR(I)*(C1*H(I,2)+C2*H(I+1,2));
         PH(1):=(R(I)/R(I+1))*PH(1)-Two*R(I)*(C3*H(I,2)+C2*H(I+1,2));
      end loop;
      --J>1
      for J in 2..H'Last(2)-1 loop
         C1:=(ThickR(H'Last(1))/Ro(H'Last(1)))**(J-1);
         C2:=(ThickR(H'Last(1))/R(H'Last(1)+1))**(J-1);
         C3:=(R(H'Last(1))/Ro(H'Last(1)))**(J-1);
         C4:=(R(H'Last(1))/R(H'Last(1)+1))**(J-1);
         H(H'Last(1),J):=(ThickR(H'Last(1))/R(H'Last(1)+1))**J*Wp2(J)-Two*ThickR(H'Last(1))*((C1-ScalOne)*H(H'Last(1),J+1)+(C2-C1)*V2(J+1))/Scal(Rep(1-J));
         PH(J):=(R(H'Last(1))/R(H'Last(1)+1))**J*Wp2(J)-Two*R(H'Last(1))*((C3-ScalOne)*H(H'Last(1),J+1)+(C4-C3)*V2(J+1))/Scal(Rep(1-J));
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/Ro(I))**(J-1);
            C2:=(ThickR(I)/R(I+1))**(J-1);
            C3:=(R(I)/Ro(I))**(J-1);
            C4:=(R(I)/R(I+1))**(J-1);
            H(I,J):=(ThickR(I)/R(I+1))**J*PH(J)-Two*ThickR(I)*((C1-ScalOne)*H(I,J+1)+(C2-C1)*H(I+1,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I)/R(I+1))**J*PH(J)-Two*R(I)*((C3-ScalOne)*H(I,J+1)+(C4-C3)*H(I+1,J+1))/Scal(Rep(1-J));
         end loop;
      end loop;
      H(H'Last(1),H'Last(2)):=(ThickR(H'Last(1))/R(H'Last(1)+1))**(H'Last(2))*Wp2(H'Last(2));
      PH(H'Last(2)):=(R(H'Last(1))/R(H'Last(1)+1))**(H'Last(2))*Wp2(H'Last(2));
      for I in reverse H'First(1)..H'Last(1)-1 loop
         H(I,H'Last(2)):=(ThickR(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
         PH(H'Last(2)):=(R(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
      end loop;
      for J in Wp1'Range loop
         Wp1(J):=PH(J);
      end loop;
      <<AGAIN2>> Write_T(Iter,Wp1_RLog,Wp1_WLog,Wp1_Name,Wp1 ,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN2;
      end if;
      <<AGAIN3>> Read_T(Iter,Wn1_RLog,Wn1_WLog,Wn1_Name,Wn1 ,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN3;
      end if;

      --NONPOSITIVE J's
      --J<=-1
      for J in H'First(2)..-1 loop
         C1:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(1-J);
         C2:=(R(H'First(1)-1)/ThickR(H'First(1)))**(1-J);
         C3:=(Ro(H'First(1)-1)/R(H'First(1)))**(1-J);
         C4:=(R(H'First(1)-1)/R(H'First(1)))**(1-J);
         H(H'First(1),J):=(ThickR(H'First(1))/R(H'First(1)-1))**J*Wn1(J)+Two*ThickR(H'First(1))*((C1-C2)*V1(J+1)+(ScalOne-C1)*H(H'First(1),J+1))/Scal(Rep(1-J));
         PH(J):=(R(H'First(1))/R(H'First(1)-1))**J*Wn1(J)+Two*R(H'First(1))*((C3-C4)*V1(J+1)+(ScalOne-C3)*H(H'First(1),J+1))/Scal(Rep(1-J));
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(Ro(I-1)/ThickR(I))**(1-J);
            C2:=(R(I-1)/ThickR(I))**(1-J);
            C3:=(Ro(I-1)/R(I))**(1-J);
            C4:=(R(I-1)/R(I))**(1-J);
            H(I,J):=(ThickR(I)/R(I-1))**J*PH(J)+Two*ThickR(I)*((C1-C2)*H(I-1,J+1)+(ScalOne-C1)*H(I,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I)/R(I-1))**(J)*PH(J)+Two*R(I)*((C3-C4)*H(I-1,J+1)+(ScalOne-C3)*H(I,J+1))/Scal(Rep(1-J));
         end loop;
      end loop;
      --J=0
      H(H'First(1),0):=Wn1(0)+Two*((Ro(H'First(1)-1)-R(H'First(1)-1))*V1(1)+(ThickR(H'First(1))-Ro(H'First(1)-1))*P(H'First(1)));
      PH(0):=Wn1(0)+Two*((Ro(H'First(1)-1)-R(H'First(1)-1))*V1(1)+(R(H'First(1))-Ro(H'First(1)-1))*P(H'First(1)));
      for I in H'First(1)+1..H'Last(1) loop
         H(I,0):=PH(0)+Two*((Ro(I-1)-R(I-1))*P(I-1)+(ThickR(I)-Ro(I-1))*P(I));
         PH(0):=PH(0)+Two*((Ro(I-1)-R(I-1))*P(I-1)+(R(I)-Ro(I-1))*P(I));
      end loop;
      for J in Wn2'Range loop
         Wn2(J):=PH(J);
      end loop;
      <<AGAIN4>> Write_T(Iter,Wn2_RLog,Wn2_WLog,Wn2_Name,Wn2,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN4;
      end if;
   end Const_P_Transform2;


   procedure Lin_P_Transform3(Iter: in Integer; Rad: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --    pragma Suppress(Storage_Check);
      C: Comp;
      P: CompArray(H'Range(1));
      Wp: CompArray(0..H'Last(2));
      Wn: CompArray(H'First(2)..-1);
      Eps: Scalar;
      JJ: Integer;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  PM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  CM;
   begin
      if H'Last(1)/=0 then
         Message("RG_Ops.Lin_P_Transform3",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Lin_P_Transform3",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I):=H(I,0);
      end loop;

      --NONNEGATIVE
      --J=0
      H(H'Last(1),0):=CoZero;--due to the second part of the  Cauchy Transfrom
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=Two*(Rad(I+1)*H(I,1)-Rad(I)*H(I+1,1)) +(Sqr(Rad(I+1))-Sqr(Rad(I)))*(H(I+1,1)-H(I,1))/Eps;
         H(I,0):=H(I+1,0)-C;
      end loop;
      --J=1
      H(H'Last(1),1):=CoZero;--due to the second part of the  Cauchy Transfrom
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=(Two*Rad(I))*Log(Rad(I+1)/Rad(I))*(Rad(I+1)*H(I,2)-Rad(I)*H(I+1,2))/Eps+Two*Rad(I)*(H(I+1,2)-H(I,2));
         H(I,1):=(Rad(I)/Rad(I+1))*H(I+1,1)-C;
      end loop;
      --J=2
      H(H'Last(1),2):=CoZero;--due to the second part of the  Cauchy Transfrom
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         C:=(Two*Rad(I))*(ScalOne-Rad(I)/Rad(I+1))*(Rad(I+1)*H(I,3)-Rad(I)*H(I+1,3))/Eps+Two*Sqr(Rad(I))*Log(Rad(I+1)/Rad(I))*(H(I+1,3)-H(I,3))/Eps;
         H(I,2):=(Rad(I)/Rad(I+1))**2*H(I+1,2)-C;
      end loop;
      --J>=3
      for J in 3..H'Last(2)-1 loop
         JJ:=J+1;
         H(H'Last(1),J):=CoZero;--due to the second part of the  Cauchy Transfrom
         for I in reverse H'First(1)..H'Last(1)-1 loop
            Eps:=Rad(I+1)-Rad(I);
            C:=(Two*Rad(I))/Scal(J-1)*(ScalOne-(Rad(I)/Rad(I+1))**(J-1))*(Rad(I+1)*H(I,JJ)-Rad(I)*H(I+1,JJ))/Eps+(Two*Sqr(Rad(I)))/Scal(J-2)*(ScalOne-(Rad(I)/Rad(I+1))**(J-2))*(H(I+1,JJ)-H(I,JJ))/Eps;
            if I=-1 then
               H(I,J):=Neg(C);
            else
               H(I,J):=(Rad(I)/Rad(I+1))**J*H(I+1,J)-C;
            end if;
         end loop;
      end loop;
      H(H'Last(1),H'Last(2)):=CoZero;
      for I in reverse H'First(1)..H'Last(1)-1 loop
         Eps:=Rad(I+1)-Rad(I);
         if I=-1 then
            H(I,H'Last(2)):=CoZero;
         else
            H(I,H'Last(2)):=(Rad(I)/Rad(I+1))**(H'Last(2))*H(I+1,H'Last(2));
         end if;
      end loop;
      for J in Wp'Range loop
         Wp(J):=H(H'First(1),J);
      end loop;
      <<AGAIN1>> Write_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr); --Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN1;
      end if;
      <<AGAIN2>> Read_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr); --Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN2;
      end if;

      --NEGATIVE J's
      --H'First(2)<=J<=-2
      for J in H'First(2)..-2 loop
         Eps:=Rad(H'First(1))-Rad(H'First(1)-1);
         H(H'First(1),J):=(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J)*Wn(J)+(Two*Rad(H'First(1)))/Scal(abs(J)+1)*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J+1))*(Rad(H'First(1))*V(J+1)-
                          Rad(H'First(1)-1)*H(H'First(1),J+1))/Eps+(Two*Sqr(Rad(H'First(1))))/Scal(abs(J)+2)*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**(-J+2))*(H(H'First(1),J+1)-V(J+1))/Eps;
         for I in H'First(1)+1..H'Last(1) loop
            Eps:=Rad(I)-Rad(I-1);
            H(I,J):=(Rad(I-1)/Rad(I))**(-J)*H(I-1,J)+(Two*Rad(I))/Scal(abs(J)+1)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+1))*(Rad(I)*H(I-1,J+1)-
                     Rad(I-1)*H(I,J+1))/Eps+(Two*Sqr(Rad(I)))/Scal(abs(J)+2)*(ScalOne-(Rad(I-1)/Rad(I))**(-J+2))*(H(I,J+1)-H(I-1,J+1))/Eps;
         end loop;
      end loop;
      --J=-1
      Eps:=Rad(H'First(1))-Rad(H'First(1)-1);
      H(H'First(1),-1):=(Rad(H'First(1)-1)/Rad(H'First(1)))*Wn(-1)+Rad(H'First(1))*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**2)*(Rad(H'First(1))*V(0)-
                         Rad(H'First(1)-1)*P(H'First(1)))/Eps+(Two*Sqr(Rad(H'First(1))))/Three*(ScalOne-(Rad(H'First(1)-1)/Rad(H'First(1)))**3)*(P(H'First(1))-V(0))/Eps;
      for I in H'First(1)+1..H'Last(1) loop
         Eps:=Rad(I)-Rad(I-1);
         H(I,-1):=(Rad(I-1)/Rad(I))*H(I-1,-1)+Rad(I)*(ScalOne-(Rad(I-1)/Rad(I))**2)*(Rad(I)*P(I-1)-Rad(I-1)*P(I))/Eps+(Two*Sqr(Rad(I)))/Three*(ScalOne-(Rad(I-1)/Rad(I))**3)*(P(I)-P(I-1))/Eps;
      end loop;
   end Lin_P_Transform3;



   procedure Const_P_Transform3(Iter: in Integer; R,Ro,ThickR: in ScalArray; V: in  CompArray; H: in out CompMatrix; Out_Dir,CM,PM,NM: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)  is
      --used for solving the Beltrami equation on a compact disk of radius R_0,
      -- negative I's coresspond to the inside of the disk,
      -- positive I's - to the otside
      pragma Suppress(Storage_Check);
      P: CompArray(H'Range(1));
      Wp: CompArray(1..H'Last(2));
      Wn: CompArray(H'First(2)..0);
      PH: CompArray(H'Range(2));
      C1,C2,C3,C4: Scalar;
      Wn_RLog: String:=Out_Dir & "logs/r_n_" &  PM;
      Wp_WLog: String:=Out_Dir & "logs/w_p_" &  CM;
      Wn_WLog: String:=Out_Dir & "logs/w_n_" &  PM;
      Wp_RLog: String:=Out_Dir & "logs/r_p_" &  CM;
      Wn_Name: String:=Out_Dir & "vecs/n_" &  PM;
      Wp_Name: String:=Out_Dir & "vecs/p_" &  CM;
   begin
      if H'First(1)>=-1 or H'Last(1)/=0 then
         Message("RG_Ops.Const_P_Transform3",Index_Error);
      end if;
      if H'Length(2)<4 then
         Message("RG_Ops.Const_P_Transform3",Index_Error);
      end if;
      for I in H'Range(1) loop
         P(I):=H(I,1);
      end loop;

      --POSITIVE J's
      --J=1
      H(H'Last(1),1):=(-Two)*ThickR(H'Last(1))*Log(Ro(H'Last(1))/ThickR(H'Last(1)))*H(H'Last(1),2);
      PH(1):=(-Two)*R(H'Last(1))*Log(Ro(H'Last(1))/R(H'Last(1)))*H(H'Last(1),2);
      for I in reverse H'First(1)..H'Last(1)-1 loop
         C1:=Log(Ro(I)/ThickR(I));
         C2:=Log(R(I+1)/Ro(I));
         C3:=Log(Ro(I)/R(I));
         H(I,1):=(ThickR(I)/R(I+1))*PH(1)-Two*ThickR(I)*(C1*H(I,2)+C2*H(I+1,2));
         PH(1):=(R(I)/R(I+1))*PH(1)-Two*R(I)*(C3*H(I,2)+C2*H(I+1,2));
      end loop;
      --J>1
      for J in 2..H'Last(2)-1 loop
         C1:=(ThickR(H'Last(1))/Ro(H'Last(1)))**(J-1);
         C3:=(R(H'Last(1))/Ro(H'Last(1)))**(J-1);
         H(H'Last(1),J):=(-Two)*ThickR(H'Last(1))*(C1-ScalOne)*H(H'Last(1),J+1)/Scal(Rep(1-J));
         PH(J):=(-Two)*R(H'Last(1))*(C3-ScalOne)*H(H'Last(1),J+1)/Scal(Rep(1-J));
         for I in reverse H'First(1)..H'Last(1)-1 loop
            C1:=(ThickR(I)/Ro(I))**(J-1);
            C2:=(ThickR(I)/R(I+1))**(J-1);
            C3:=(R(I)/Ro(I))**(J-1);
            C4:=(R(I)/R(I+1))**(J-1);
            H(I,J):=(ThickR(I)/R(I+1))**J*PH(J)-Two*ThickR(I)*((C1-ScalOne)*H(I,J+1)+(C2-C1)*H(I+1,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I)/R(I+1))**J*PH(J)-Two*R(I)*((C3-ScalOne)*H(I,J+1)+(C4-C3)*H(I+1,J+1))/Scal(Rep(1-J));
         end loop;
      end loop;
      H(H'Last(1),H'Last(2)):=CoZero;
      PH(H'Last(2)):=CoZero;
      for I in reverse H'First(1)..H'Last(1)-1 loop
         H(I,H'Last(2)):=(ThickR(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
         PH(H'Last(2)):=(R(I)/R(I+1))**(H'Last(2))*PH(H'Last(2));
      end loop;

      for J in Wp'Range loop
         Wp(J):=PH(J);
      end loop;
      <<AGAIN2>> Write_T(Iter,Wp_RLog,Wp_WLog,Wp_Name,Wp,Brackets,Decimal,ShowErr);--Write only if Wn is read by a previous itteration
      if EX=1 then goto AGAIN2;
      end if;
      <<AGAIN3>> Read_T(Iter,Wn_RLog,Wn_WLog,Wn_Name,Wn,Brackets,Decimal,ShowErr);--Read only if Wp is written by the current iteration
      if EX=1 then goto AGAIN3;
      end if;

      --NONPOSITIVE J's
      --J<=-1
      for J in H'First(2)..-1 loop
         C1:=(Ro(H'First(1)-1)/ThickR(H'First(1)))**(1-J);
         C2:=(R(H'First(1)-1)/ThickR(H'First(1)))**(1-J);
         C3:=(Ro(H'First(1)-1)/R(H'First(1)))**(1-J);
         C4:=(R(H'First(1)-1)/R(H'First(1)))**(1-J);
         H(H'First(1),J):=(ThickR(H'First(1))/R(H'First(1)-1))**J*Wn(J)+Two*ThickR(H'First(1))*((C1-C2)*V(J+1)+(ScalOne-C1)*H(H'First(1),J+1))/Scal(Rep(1-J));
         PH(J):=(R(H'First(1))/R(H'First(1)-1))**J*Wn(J)+Two*R(H'First(1))*((C3-C4)*V(J+1)+(ScalOne-C3)*H(H'First(1),J+1))/Scal(Rep(1-J));
         for I in H'First(1)+1..H'Last(1) loop
            C1:=(Ro(I-1)/ThickR(I))**(1-J);
            C2:=(R(I-1)/ThickR(I))**(1-J);
            C3:=(Ro(I-1)/R(I))**(1-J);
            C4:=(R(I-1)/R(I))**(1-J);
            H(I,J):=(ThickR(I)/R(I-1))**J*PH(J)+Two*ThickR(I)*((C1-C2)*H(I-1,J+1)+(ScalOne-C1)*H(I,J+1))/Scal(Rep(1-J));
            PH(J):=(R(I)/R(I-1))**(J)*PH(J)+Two*R(I)*((C3-C4)*H(I-1,J+1)+(ScalOne-C3)*H(I,J+1))/Scal(Rep(1-J));
         end loop;
      end loop;
      --J=0
      H(H'First(1),0):=Wn(0)+Two*((Ro(H'First(1)-1)-R(H'First(1)-1))*V(1)+(ThickR(H'First(1))-Ro(H'First(1)-1))*P(H'First(1)));
      PH(0):=Wn(0)+Two*((Ro(H'First(1)-1)-R(H'First(1)-1))*V(1)+(R(H'First(1))-Ro(H'First(1)-1))*P(H'First(1)));
      for I in H'First(1)+1..H'Last(1) loop
         H(I,0):=PH(0)+Two*((Ro(I-1)-R(I-1))*P(I-1)+(ThickR(I)-Ro(I-1))*P(I));
         PH(0):=PH(0)+Two*((Ro(I-1)-R(I-1))*P(I-1)+(R(I)-Ro(I-1))*P(I));
      end loop;
   end Const_P_Transform3;


   procedure  Iter_Approx_Sol(N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer;
                              Iter: in out Integer;
                              Belt: in out CompMatrix;
                              F:  out CompMatrix;
                              Rad: in ScalArray;
                              ThickRad: in ScalArray;
                              Ro: in ScalArray;
                              Center: in Comp;
                              Con_File,Out_Dir: in String;
                              Read_Approx: in Boolean;
                              Write_H: in Boolean;
                              Brackets: in Boolean:=False;
                              Decimal: in Boolean := True;
                              ShowErr: in  Boolean:=True)  is
      use Ada.Strings.Unbounded;
      K1: constant Integer:=Belt'First(2);
      K2: constant Integer:=Belt'Last(2);
      N1: constant Integer:=Belt'First(1);
      N2: constant Integer:=Belt'Last(1);
      Err: Rep;
      Del: constant Scalar:=Two*ScalPi/Rep(K2-K1+1);

      V1,V2,V1b,V2b: CompArray(F'Range(2));
      F1,F2,F3,F4: File_Type;
      Start_Mark,Int1,Int2,Int3,Int4: Integer;
      SM,CM,PM,NM: Unbounded_String;
      P_File,C_File: String:=Out_Dir & "c_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      G_File: String:=Out_Dir & "g/approx_g_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      H_File: String:=Out_Dir & "h/approx_h_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Mult_File: String:=Out_Dir & "mult/approx_mult_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      I1_File,I2_File,I3_File,I4_File,I1_Log,I2_Log,I3_Log,I4_Log:  String:=Out_Dir &  "norm/vec_" & "1";
      Read1,Read2,Write1,Write2: String:=Out_Dir & "vecs/l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_RLog,Read2_RLog,Write1_RLog,Write2_RLog: String:=Out_Dir & "logs/r_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_WLog,Read2_WLog,Write1_WLog,Write2_WLog: String:=Out_Dir & "logs/w_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
   begin

      SetZero(F);

      CM:=To_Unbounded_String(Integer'Image(Current_Machine)(2..Integer'Image(Current_Machine)'Last));
      Int1:= Integer'Image(Current_Machine)'Length;
      Int2:= Integer'Image(Num_Of_Machines)'Length-1;
      Int3:= Integer'Image(Current_Machine-1)'Length;
      Int4:= Integer'Image(Current_Machine+1)'Length;
      for I in Int1..Int2 loop
         CM:=To_Unbounded_String("0") & CM;
      end loop;
      PM:=To_Unbounded_String(Integer'Image(Current_Machine-1)(2..Integer'Image(Current_Machine-1)'Last));
      for I in Int3..Int2 loop
         PM:=To_Unbounded_String("0") & PM;
      end loop;
      NM:=To_Unbounded_String(Integer'Image(Current_Machine+1)(2..Integer'Image(Current_Machine+1)'Last));
      for I in Int4..Int2 loop
         NM:=To_Unbounded_String("0") & NM;
      end loop;

      H_File:=Out_Dir & "h/approx_h_" &  To_String(CM);
      G_File:=Out_Dir & "g/approx_g_" &  To_String(CM);
      Mult_File:=Out_Dir & "mult/approx_mult_" &  To_String(CM);
      C_File:=Out_Dir & "c_" &  To_String(CM);
      P_File:=Out_Dir & "p_" &  To_String(CM);

      Read1_RLog:=Out_Dir &  "logs/r_l_" &  To_String(PM);
      Read2_RLog:=Out_Dir &  "logs/r_f_" &  To_String(NM);
      Write1_WLog:=Out_Dir &  "logs/w_f_" &  To_String(CM);
      Write2_WLog:=Out_Dir &  "logs/w_l_" &  To_String(CM);

      Read1_WLog:=Out_Dir &  "logs/w_l_" &  To_String(PM);
      Read2_WLog:=Out_Dir &  "logs/w_f_" &  To_String(NM);
      Write1_RLog:=Out_Dir &  "logs/r_f_" &  To_String(CM);
      Write2_RLog:=Out_Dir &  "logs/r_l_" &  To_String(CM);


      Read1:=Out_Dir &  "vecs/l_" &  To_String(PM);
      Read2:=Out_Dir &  "vecs/f_" &  To_String(NM);
      Write1:=Out_Dir &  "vecs/f_" &  To_String(CM);
      Write2:=Out_Dir &  "vecs/l_" &  To_String(CM);


      I1_File:=Out_Dir &  "norm/vec_" &  "1";
      I2_File:=Out_Dir &  "norm/vec_" &  "2";
      I3_File:=Out_Dir &  "norm/vec_" &  "3";
      I4_File:=Out_Dir &  "norm/vec_" &  "4";

      I1_Log:=Out_Dir &  "norm/log_" &  "1";
      I2_Log:=Out_Dir &  "norm/log_" &  "2";
      I3_Log:=Out_Dir &  "norm/log_" &  "3";
      I4_Log:=Out_Dir &  "norm/log_" &  "4";

      --Creating the RLog's: info read from into RLog's by iteration -1
      Create(F1,Out_File,Read1_RLog);
      Create(F2,Out_File,Read2_RLog);
      Create(F3,Out_File,Write1_RLog);
      Create(F4,Out_File,Write2_RLog);
      Put(F1,-1);Put(F2,-1); Put(F3,-1); Put(F4,-1);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the RLog's: info read from into RLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/r_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/r_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/r_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/r_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      SetZero(V1);
      SetZero(V2);
      Create(F1,Out_File,Write1);
      Create(F2,Out_File,Write2);
      for J in F'Range(2) loop
         Put(F1,CoZero,Brackets,Decimal,ShowErr);Put(F2,CoZero,Brackets,Decimal,ShowErr);
      end loop;
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Read1_WLog);
      Create(F2,Out_File,Read2_WLog);
      Create(F3,Out_File,Write1_WLog);
      Create(F4,Out_File,Write2_WLog);
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/w_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/w_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/w_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/w_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the W_WLog's: writing info into Vec_WLog's by iteration 0
      Create(F1,Out_File,Out_Dir & "vecs/n_" &  To_String(PM));
      Create(F2,Out_File,Out_Dir & "vecs/n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir & "vecs/p_" &  To_String(NM));
      Create(F4,Out_File,Out_Dir & "vecs/p_" &  To_String(CM));
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      if Current_Machine=1 then
         --Creating I_Log's
         Create(F1,Out_File,I1_Log);
         Create(F2,Out_File,I2_Log);
         Create(F3,Out_File,I3_Log);
         Create(F4,Out_File,I4_Log);
         Put(F1,0); Put(F2,0); Put(F3,0); Put(F4,0);
         Close(F4);
         Close(F3);
         Close(F2);
         Close(F1);
      end if;

      New_Line;
      New_Line;
      Put("Reading files:");
      New_Line;
      Put(Read1);
      New_Line;
      Put(Read2);
      New_Line;
      New_Line;
      Put("Logging the read info into files:");
      New_Line;
      Put(Read1_RLog);
      New_Line;
      Put(Read2_RLog);
      New_Line;
      Put(Write1_RLog);
      New_Line;
      Put(Write2_RLog);
      New_Line;
      New_Line;
      Put("Writing files:");
      New_Line;
      Put(Write1);
      New_Line;
      Put(Write2);
      New_Line;
      New_Line;
      Put("Logging the write info into files:");
      New_Line;
      Put(Read1_WLog);
      New_Line;
      Put(Read2_WLog);
      New_Line;
      Put(Write1_WLog);
      New_Line;
      Put(Write2_WLog);

      if Read_Approx then
         New_Line;
         New_Line;
         Put("Reading and writing approximation ...");
         Read_SB(F,H_File,Brackets,Decimal,ShowErr); --reading an approximation
         Create(F1,Out_File,Write1);
         Create(F2,Out_File,Write2);
         for J in F'Range(2) loop
            Put(F1,F(F'First(1),J),Brackets,Decimal,ShowErr);Put(F2,F(F'Last(1),J),Brackets,Decimal,ShowErr);
         end loop;
         Close(F2);
         Close(F1);
         Put(" done");
      end if;

      Create(F1,Out_File,Out_Dir & "logs/start_" &  To_String(CM));
      Put(F1,1);
      Close(F1);

      New_Line;
      Put("Waiting for other programs to arrive...");
      <<RESTART>> null;
      for I in 1..Num_Of_Machines loop
         SM:=To_Unbounded_String(Integer'Image(I)(2..Integer'Image(I)'Last));
         Int1:=Integer'Image(I)'Length;
         Int2:= Integer'Image(Num_Of_Machines)'Length-1;
         for J in Int1..Int2 loop
            SM:=To_Unbounded_String("0") & SM;
         end loop;

         Start_Mark:=0;
         Read_Int(Out_Dir & "logs/start_"  & To_String(SM),Start_Mark);
         if EX=1 or Start_Mark=0 then
            EX:=0;
            delay 0.1;
            goto RESTART;
         end if;
      end loop;
      Put(" done");

      -- Hilbert Transforms
      New_Line;
      New_Line;
      Put("Iterations:");

      Err:=Rep(100.0);
      for I in 1..Iter loop
         New_Line;
         Put("Iteration #"); ShortPut(I);

         if N1=N1min then
            <<AGAIN1>> Read(I,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr); --radius immidiately "above" the annulus
            if EX=1 then goto AGAIN1;
            end if;
            for J in F'Range(2) loop
               V2b(J):=F(F'Last(1),J);
               V1b(J):=F(F'First(1),J);
            end loop;

            if I=Iter then
                 Const_P_Transform1(I,Rad,Ro,ThickRad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
                  if Write_H then
                     New_Line;
                     Put("Writing the approximate solution:");
                     Write_SB(F,G_File,Brackets,Decimal,ShowErr); --series
                     Put(" done");
                  end if;
                  return;
            end if;
            --Lin_T_Transform1(I,Rad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
            Const_T_Transform1(I,Rad,Ro,ThickRad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
            if  Trunc then
               New_Line;
               Put(" Doing mu*(h+1) by FFT...");
               FT_Mod(F,True); --point values
               PointsProdAdd(Belt,F);
               FT_Mod(F);
               Put("done");
            else
               New_Line;
               Put(" Doing mu*(h+1) by multiplication...");
               ProdAdd(Belt,F);
               Put("done");
            end if;
            for J in F'Range(2) loop
               V2(J):=F(F'Last(1),J);
               V1(J):=F(F'First(1),J);
            end loop;
            <<AGAIN2>> Write(I,Write2_RLog,Write2_WLog,Write2,V2,Brackets,Decimal,ShowErr); --last radius of the annulus
            if EX=1 then goto AGAIN2;
            end if;
         elsif N2=0 then
            <<AGAIN3>> Read(I,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
            if EX=1 then goto AGAIN3;
            end if;
            for J in F'Range(2) loop
               V2b(J):=F(F'Last(1),J);
               V1b(J):=F(F'First(1),J);
            end loop;
            if I=Iter then
                 Const_P_Transform3(I,Rad,Ro,ThickRad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
                  if Write_H then
                     New_Line;
                     Put("Writing the approximate solution:");
                     Write_SB(F,G_File,Brackets,Decimal,ShowErr); --series
                     Put(" done");
                  end if;
                  return;
            end if;
            -- Lin_T_Transform3(I,Rad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
            Const_T_Transform3(I,Rad,Ro,ThickRad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
            if  Trunc then
               New_Line;
               Put(" Doing mu*(h+1) by FFT...");
               FT(F,True); --point values
               PointsProdAdd(Belt,F);
               FT(F);
            else
               New_Line;
               Put(" Doing mu*(h+1) by multiplication...");
               ProdAdd(Belt,F);
               Put("done");
            end if;
            for J in F'Range(2) loop
               V1(J):=F(F'First(1),J);
               V2(J):=F(F'Last(1),J);
            end loop;

            <<AGAIN4>> Write(I,Write1_RLog,Write1_WLog,Write1,V1,Brackets,Decimal,ShowErr);
            if EX=1 then goto AGAIN4;
            end if;
         else
            <<AGAIN5>> Read(I,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
            if EX=1 then  goto AGAIN5;
            end if;
            <<AGAIN6>> Read(I,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr);
            if EX=1 then  goto AGAIN6;
            end if;

            for J in F'Range(2) loop
               V2b(J):=F(F'Last(1),J);
               V1b(J):=F(F'First(1),J);
            end loop;

            if I=Iter then
                 Const_P_Transform2(I,Rad,Ro,ThickRad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
                  if Write_H then
                     New_Line;
                     Put("Writing the approximate solution:");
                     Write_SB(F,G_File,Brackets,Decimal,ShowErr); --series
                     Put(" done");
                  end if;
                  return;
             end if;
              Const_T_Transform2(I,Rad,Ro,ThickRad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
             --       Lin_T_Transform2(I,Rad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
              if  Trunc then
                 New_Line;
                 Put(" Doing mu*(h+1) by FFT...");
                 FT(F,True); --point values
                 PointsProdAdd(Belt,F);
                 FT(F);
                 Put("done");
              else
               New_Line;
               Put(" Doing mu*(h+1) by multiplication...");
               ProdAdd(Belt,F);
               Put("done");
              end if;
            for J in F'Range(2) loop
               V1(J):=F(F'First(1),J);
               V2(J):=F(F'Last(1),J);
            end loop;

            <<AGAIN7>> Write(I,Write1_RLog,Write1_WLog,Write1,V1,Brackets,Decimal,ShowErr);
            if EX=1 then  goto AGAIN7;
            end if;
            <<AGAIN8>> Write(I,Write2_RLog,Write2_WLog,Write2,V2,Brackets,Decimal,ShowErr);
            if EX=1 then  goto AGAIN8;
            end if;
         end if;
         Err:=Min(NormInf(V1-V1b),NormInf(V2-V2b));
         Read_Integer(Con_File,Iter);
         New_Line;
         Put("Convergence estimate:=");Txt_Put(Current_Output,Err);
      end loop;
   end Iter_Approx_Sol;


   procedure  Iter_Fixed_Point(Pex: in Rep; N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer;
                                               F: in out CompMatrix;
                                               Rad: in ScalArray;
                                               ThickRad: in ScalArray;
                                               Ro: in ScalArray;
                                               Center: in Comp;
                                               Out_Dir: in String;
                                               Text_Output: in Boolean;
                                               Brackets: in Boolean:=False;
                                               Decimal: in Boolean := True;
                                               ShowErr: in  Boolean:=True) is

      use Ada.Strings.Unbounded;
      K1: constant Integer:=F'First(2);
      K2: constant Integer:=F'Last(2);
      N1: constant Integer:=F'First(1);
      N2: constant Integer:=F'Last(1);
      Del: constant Scalar:=Two*ScalPi/Rep(K2-K1+1);
      V1,V2: CompArray(F'Range(2));
      F1,F2,F3,F4: File_Type;
      Start_Mark,Int1,Int2,Int3,Int4: Integer;
      SM,CM,PM,NM: Unbounded_String;
      I1_File,I2_File,I3_File,I4_File,I1_Log,I2_Log,I3_Log,I4_Log:  String:=Out_Dir &  "norm/vec_" & "1";
      Read1,Read2,Write1,Write2: String:=Out_Dir & "vecs/l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_RLog,Read2_RLog,Write1_RLog,Write2_RLog: String:=Out_Dir & "logs/r_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_WLog,Read2_WLog,Write1_WLog,Write2_WLog: String:=Out_Dir & "logs/w_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      I: constant Integer:=1;
   begin
      CM:=To_Unbounded_String(Integer'Image(Current_Machine)(2..Integer'Image(Current_Machine)'Last));
      Int1:= Integer'Image(Current_Machine)'Length;
      Int2:= Integer'Image(Num_Of_Machines)'Length-1;
      Int3:= Integer'Image(Current_Machine-1)'Length;
      Int4:= Integer'Image(Current_Machine+1)'Length;
      for I in Int1..Int2 loop
         CM:=To_Unbounded_String("0") & CM;
      end loop;
      PM:=To_Unbounded_String(Integer'Image(Current_Machine-1)(2..Integer'Image(Current_Machine-1)'Last));
      for I in Int3..Int2 loop
         PM:=To_Unbounded_String("0") & PM;
      end loop;
      NM:=To_Unbounded_String(Integer'Image(Current_Machine+1)(2..Integer'Image(Current_Machine+1)'Last));
      for I in Int4..Int2 loop
         NM:=To_Unbounded_String("0") & NM;
      end loop;

      Read1_RLog:=Out_Dir &  "logs/r_l_" &  To_String(PM);
      Read2_RLog:=Out_Dir &  "logs/r_f_" &  To_String(NM);
      Write1_WLog:=Out_Dir &  "logs/w_f_" &  To_String(CM);
      Write2_WLog:=Out_Dir &  "logs/w_l_" &  To_String(CM);

      Read1_WLog:=Out_Dir &  "logs/w_l_" &  To_String(PM);
      Read2_WLog:=Out_Dir &  "logs/w_f_" &  To_String(NM);
      Write1_RLog:=Out_Dir &  "logs/r_f_" &  To_String(CM);
      Write2_RLog:=Out_Dir &  "logs/r_l_" &  To_String(CM);

      Read1:=Out_Dir &  "vecs/l_" &  To_String(PM);
      Read2:=Out_Dir &  "vecs/f_" &  To_String(NM);
      Write1:=Out_Dir &  "vecs/f_" &  To_String(CM);
      Write2:=Out_Dir &  "vecs/l_" &  To_String(CM);

      I1_File:=Out_Dir &  "norm/vec_" &  "1";
      I2_File:=Out_Dir &  "norm/vec_" &  "2";
      I3_File:=Out_Dir &  "norm/vec_" &  "3";
      I4_File:=Out_Dir &  "norm/vec_" &  "4";

      I1_Log:=Out_Dir &  "norm/log_" &  "1";
      I2_Log:=Out_Dir &  "norm/log_" &  "2";
      I3_Log:=Out_Dir &  "norm/log_" &  "3";
      I4_Log:=Out_Dir &  "norm/log_" &  "4";

      --Creating the RLog's: info read from into RLog's by iteration -1
      Create(F1,Out_File,Read1_RLog);
      Create(F2,Out_File,Read2_RLog);
      Create(F3,Out_File,Write1_RLog);
      Create(F4,Out_File,Write2_RLog);
      Put(F1,-1);Put(F2,-1); Put(F3,-1); Put(F4,-1);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the RLog's: info read from into RLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/r_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/r_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/r_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/r_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      SetZero(V1);
      SetZero(V2);
      Create(F1,Out_File,Write1);
      Create(F2,Out_File,Write2);
      for J in F'Range(2) loop
         Put(F1,F(F'First(1),J),Brackets,Decimal,ShowErr);Put(F2,F(F'Last(1),J),Brackets,Decimal,ShowErr);
      end loop;
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Read1_WLog);
      Create(F2,Out_File,Read2_WLog);
      Create(F3,Out_File,Write1_WLog);
      Create(F4,Out_File,Write2_WLog);
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/w_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/w_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/w_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/w_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the W_WLog's: writing info into Vec_WLog's by iteration 0
      Create(F1,Out_File,Out_Dir & "vecs/n_" &  To_String(PM));
      Create(F2,Out_File,Out_Dir & "vecs/n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir & "vecs/p_" &  To_String(NM));
      Create(F4,Out_File,Out_Dir & "vecs/p_" &  To_String(CM));
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      if Current_Machine=1 then
         --Creating I_Log's
         Create(F1,Out_File,I1_Log);
         Create(F2,Out_File,I2_Log);
         Create(F3,Out_File,I3_Log);
         Create(F4,Out_File,I4_Log);
         Put(F1,0); Put(F2,0); Put(F3,0); Put(F4,0);
         Close(F4);
         Close(F3);
         Close(F2);
         Close(F1);
      end if;

      New_Line;
      New_Line;
      Put("Reading files:");
      New_Line;
      Put(Read1);
      New_Line;
      Put(Read2);
      New_Line;
      New_Line;
      Put("Logging the read info into files:");
      New_Line;
      Put(Read1_RLog);
      New_Line;
      Put(Read2_RLog);
      New_Line;
      Put(Write1_RLog);
      New_Line;
      Put(Write2_RLog);
      New_Line;
      New_Line;
      Put("Writing files:");
      New_Line;
      Put(Write1);
      New_Line;
      Put(Write2);
      New_Line;
      New_Line;
      Put("Logging the write info into files:");
      New_Line;
      Put(Read1_WLog);
      New_Line;
      Put(Read2_WLog);
      New_Line;
      Put(Write1_WLog);
      New_Line;
      Put(Write2_WLog);

      Create(F1,Out_File,Out_Dir & "logs/start_" &  To_String(CM));
      Put(F1,1);
      Close(F1);

      New_Line;
      Put("Waiting for other programs to arrive...");
      <<RESTART>> null;
      for I in 1..Num_Of_Machines loop
         SM:=To_Unbounded_String(Integer'Image(I)(2..Integer'Image(I)'Last));
         Int1:=Integer'Image(I)'Length;
         Int2:= Integer'Image(Num_Of_Machines)'Length-1;
         for J in Int1..Int2 loop
            SM:=To_Unbounded_String("0") & SM;
         end loop;

         Start_Mark:=0;
         Read_Int(Out_Dir & "logs/start_"  & To_String(SM),Start_Mark);
         if EX=1 or Start_Mark=0 then
            EX:=0;
            goto RESTART;
         end if;
      end loop;
      Put(" done");

      -- Hilbert Transforms
      New_Line;
      New_Line;
      Put("Hilbert transform:");

      if N1=N1min then
         <<AGAIN1>> Read(1,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr); --radius immidiately "above" the annulus
         if EX=1 then goto AGAIN1;
         end if;
         --Lin_T_Transform1(I,Scal(Rad),V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         Const_T_Transform1(1,Rad,Ro,ThickRad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      elsif N2=0 then
         <<AGAIN3>> Read(1,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
         if EX=1 then goto AGAIN3;
         end if;
         -- Lin_T_Transform3(I,Scal(Rad),V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         Const_T_Transform3(1,Rad,Ro,ThickRad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      else
         <<AGAIN5>> Read(1,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
         if EX=1 then  goto AGAIN5;
         end if;
         <<AGAIN6>> Read(1,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr);
         if EX=1 then  goto AGAIN6;
         end if;
         --         Lin_T_Transform2(I,Scal(Rad),V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         Const_T_Transform2(1,Rad,Ro,ThickRad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      end if;

   end Iter_Fixed_Point;


   procedure  Iter_Cauchy(Pex: in Rep; N1min,Num_Of_Machines,Current_Machine,Cut_Output: in Integer;
                                       F: out CompMatrix;
                                       FouErr: out Scalar;
                                       Rad: in ScalArray;
                                       ThickRad: in ScalArray;
                                       Ro: in ScalArray;
                                       Out_Dir: in String;
                                       Text_Output: in Boolean;
                                       Brackets: in Boolean:=False;
                                       Decimal: in Boolean := True;
                                       ShowErr: in  Boolean:=True) is
      use Ada.Strings.Unbounded;
      K1: constant Integer:=F'First(2);
      K2: constant Integer:=F'Last(2);
      N1: constant Integer:=F'First(1);
      N2: constant Integer:=F'Last(1);
      Del: constant Scalar:=Two*ScalPi/Rep(K2-K1+1);

      V1,V2: CompArray(F'Range(2));
      F1,F2,F3,F4: File_Type;
      Start_Mark,Int1,Int2,Int3,Int4: Integer;
      SM,CM,PM,NM: Unbounded_String;
      I1_File,I2_File,I3_File,I4_File,I1_Log,I2_Log,I3_Log,I4_Log:  String:=Out_Dir &  "norm/vec_" & "1";
      Read1,Read2,Write1,Write2: String:=Out_Dir & "vecs/l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_RLog,Read2_RLog,Write1_RLog,Write2_RLog: String:=Out_Dir & "logs/r_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Read1_WLog,Read2_WLog,Write1_WLog,Write2_WLog: String:=Out_Dir & "logs/w_l_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Mult_File: String:=Out_Dir & "mult/mult_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Approx_Mult_File: String:=Out_Dir & "mult/approx_mult_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      I: constant Integer:=1;
      ProdError_File: String:=Out_Dir & "mult/prod_error_00";
   begin
      CM:=To_Unbounded_String(Integer'Image(Current_Machine)(2..Integer'Image(Current_Machine)'Last));
      Int1:= Integer'Image(Current_Machine)'Length;
      Int2:= Integer'Image(Num_Of_Machines)'Length-1;
      Int3:= Integer'Image(Current_Machine-1)'Length;
      Int4:= Integer'Image(Current_Machine+1)'Length;
      for I in Int1..Int2 loop
         CM:=To_Unbounded_String("0") & CM;
      end loop;
      PM:=To_Unbounded_String(Integer'Image(Current_Machine-1)(2..Integer'Image(Current_Machine-1)'Last));
      for I in Int3..Int2 loop
         PM:=To_Unbounded_String("0") & PM;
      end loop;
      NM:=To_Unbounded_String(Integer'Image(Current_Machine+1)(2..Integer'Image(Current_Machine+1)'Last));
      for I in Int4..Int2 loop
         NM:=To_Unbounded_String("0") & NM;
      end loop;

      Read1_RLog:=Out_Dir &  "logs/r_l_" &  To_String(PM);
      Read2_RLog:=Out_Dir &  "logs/r_f_" &  To_String(NM);
      Write1_WLog:=Out_Dir &  "logs/w_f_" &  To_String(CM);
      Write2_WLog:=Out_Dir &  "logs/w_l_" &  To_String(CM);

      Read1_WLog:=Out_Dir &  "logs/w_l_" &  To_String(PM);
      Read2_WLog:=Out_Dir &  "logs/w_f_" &  To_String(NM);
      Write1_RLog:=Out_Dir &  "logs/r_f_" &  To_String(CM);
      Write2_RLog:=Out_Dir &  "logs/r_l_" &  To_String(CM);

      Read1:=Out_Dir &  "vecs/l_" &  To_String(PM);
      Read2:=Out_Dir &  "vecs/f_" &  To_String(NM);
      Write1:=Out_Dir &  "vecs/f_" &  To_String(CM);
      Write2:=Out_Dir &  "vecs/l_" &  To_String(CM);

      I1_File:=Out_Dir &  "norm/vec_" &  "1";
      I2_File:=Out_Dir &  "norm/vec_" &  "2";
      I3_File:=Out_Dir &  "norm/vec_" &  "3";
      I4_File:=Out_Dir &  "norm/vec_" &  "4";

      I1_Log:=Out_Dir &  "norm/log_" &  "1";
      I2_Log:=Out_Dir &  "norm/log_" &  "2";
      I3_Log:=Out_Dir &  "norm/log_" &  "3";
      I4_Log:=Out_Dir &  "norm/log_" &  "4";

      --Creating the RLog's: info read from into RLog's by iteration -1
      Create(F1,Out_File,Read1_RLog);
      Create(F2,Out_File,Read2_RLog);
      Create(F3,Out_File,Write1_RLog);
      Create(F4,Out_File,Write2_RLog);
      Put(F1,-1);Put(F2,-1); Put(F3,-1); Put(F4,-1);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the RLog's: info read from into RLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/r_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/r_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/r_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/r_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      New_Line;
      Put("Reading mu*(h+1)...");
      Mult_File:=Out_Dir & "mult/mult_"  & To_String(CM);
      Approx_Mult_File:=Out_Dir & "mult/approx_mult_"  & To_String(CM);
      if not Trunc then
         Read_SB(F,Mult_File,False,False,Brackets,Decimal,False);
      else
         Read_SB(F,Approx_Mult_File,False,False,Brackets,Decimal,False);
      end if;
      Put(" done");
      if not Trunc then
         ProdError_File:=Out_Dir & "mult/prod_error_"  & To_String(CM);
         New_Line;
         Put("Reading error in mu*(h+1)...");
         Open(F1,In_File,ProdError_File);
         Get(F1,FouErr);
         Close(F1);
         Put("done");
         New_Line;
         Put("P-TH POWER OF THE L-p ERROR IN mu*(h+1)=");Show(FouErr);
      end if;

      SetZero(V1);
      SetZero(V2);
      Create(F1,Out_File,Write1);
      Create(F2,Out_File,Write2);
      for J in F'Range(2) loop
         Put(F1,F(F'First(1),J),Brackets,Decimal,ShowErr);Put(F2,F(F'Last(1),J),Brackets,Decimal,ShowErr);
      end loop;
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Read1_WLog);
      Create(F2,Out_File,Read2_WLog);
      Create(F3,Out_File,Write1_WLog);
      Create(F4,Out_File,Write2_WLog);
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the WLog's: info written into WLog's by iteration 0
      Create(F1,Out_File,Out_Dir &  "logs/w_p_" &  To_String(NM));
      Create(F2,Out_File,Out_Dir &  "logs/w_n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir &  "logs/w_n_" &  To_String(PM));
      Create(F4,Out_File,Out_Dir &  "logs/w_p_" &  To_String(CM));
      Put(F1,0);Put(F2,0); Put(F3,0); Put(F4,0);
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      --Creating the W_WLog's: writing info into Vec_WLog's by iteration 0
      Create(F1,Out_File,Out_Dir & "vecs/n_" &  To_String(PM));
      Create(F2,Out_File,Out_Dir & "vecs/n_" &  To_String(CM));
      Create(F3,Out_File,Out_Dir & "vecs/p_" &  To_String(NM));
      Create(F4,Out_File,Out_Dir & "vecs/p_" &  To_String(CM));
      Close(F4);
      Close(F3);
      Close(F2);
      Close(F1);

      if Current_Machine=1 then
         --Creating I_Log's
         Create(F1,Out_File,I1_Log);
         Create(F2,Out_File,I2_Log);
         Create(F3,Out_File,I3_Log);
         Create(F4,Out_File,I4_Log);
         Put(F1,0); Put(F2,0); Put(F3,0); Put(F4,0);
         Close(F4);
         Close(F3);
         Close(F2);
         Close(F1);
      end if;

      New_Line;
      New_Line;
      Put("Reading files:");
      New_Line;
      Put(Read1);
      New_Line;
      Put(Read2);
      New_Line;
      New_Line;
      Put("Logging the read info into files:");
      New_Line;
      Put(Read1_RLog);
      New_Line;
      Put(Read2_RLog);
      New_Line;
      Put(Write1_RLog);
      New_Line;
      Put(Write2_RLog);
      New_Line;
      New_Line;
      Put("Writing files:");
      New_Line;
      Put(Write1);
      New_Line;
      Put(Write2);
      New_Line;
      New_Line;
      Put("Logging the write info into files:");
      New_Line;
      Put(Read1_WLog);
      New_Line;
      Put(Read2_WLog);
      New_Line;
      Put(Write1_WLog);
      New_Line;
      Put(Write2_WLog);

      Create(F1,Out_File,Out_Dir & "logs/start_" &  To_String(CM));
      Put(F1,1);
      Close(F1);

      New_Line;
      Put("Waiting for other programs to arrive...");
      <<RESTART>> null;
      for I in 1..Num_Of_Machines loop
         SM:=To_Unbounded_String(Integer'Image(I)(2..Integer'Image(I)'Last));
         Int1:=Integer'Image(I)'Length;
         Int2:= Integer'Image(Num_Of_Machines)'Length-1;
         for J in Int1..Int2 loop
            SM:=To_Unbounded_String("0") & SM;
         end loop;

         Start_Mark:=0;
         Read_Int(Out_Dir & "logs/start_"  & To_String(SM),Start_Mark);
         if EX=1 or Start_Mark=0 then
            EX:=0;
            goto RESTART;
         end if;
      end loop;
      Put(" done");

      -- Cauchy Transforms
      New_Line;
      New_Line;
      Put("Cauchy transform:");

      if N1=N1min then
         <<AGAIN1>> Read(1,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr); --radius immidiately "above" the annulus
         if EX=1 then goto AGAIN1;
         end if;
         Lin_P_Transform1(1,Rad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         --Const_P_Transform1(1,Rad,Ro,ThickRad,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      elsif N2=0 then
         <<AGAIN3>> Read(1,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
         if EX=1 then goto AGAIN3;
         end if;
         Lin_P_Transform3(1,Rad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         --Const_P_Transform3(1,Rad,Ro,ThickRad,V1,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      else
         <<AGAIN5>> Read(1,Read1_RLog,Read1_WLog,Read1,V1,Brackets,Decimal,ShowErr);
         if EX=1 then  goto AGAIN5;
         end if;
         <<AGAIN6>> Read(1,Read2_RLog,Read2_WLog,Read2,V2,Brackets,Decimal,ShowErr);
         if EX=1 then  goto AGAIN6;
         end if;
         Lin_P_Transform2(1,Rad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
         --Const_P_Transform2(1,Rad,Ro,ThickRad,V1,V2,F,Out_Dir,To_String(CM),To_String(PM),To_String(NM),Brackets,Decimal,ShowErr);
      end if;

      --F2+Id
      for I in F'Range(1) loop
         F(I,1):=F(I,1)+SetBall(Rad(I),ScalZero); --series here
      end loop;
   end Iter_Cauchy;


   --READ AND WRITE PROCEDURES
   procedure   Read_Int(F_Name: in String; I: out Integer) is
      F: File_Type;
   begin
      if EX=1 then
         New_Line;
         Put("Handle is not reset"); Message("RG_Ops.Read_Integer",Parameter_Error);
      end if;
      Open(F,In_File,F_Name);
      Get(F,I);
      Close(F);
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
      when Ada.IO_Exceptions.Data_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read_Int;


   procedure   Read_Integer(F_Name: in String; I: out Integer) is
   begin
      <<REREAD>> Read_Int(F_Name,I);
      if EX=1 then
         EX:=0;
         delay 0.001;
         goto REREAD;
      end if;
   end Read_Integer;


   procedure   Read_Vec(F_Name: in String; V: out CompArray ; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)is
      F: File_Type;
   begin
      if EX=1 then
         New_Line;
         Put("Handle is not reset"); Message("RG_Ops.Read_Vector",Parameter_Error);
      end if;
      Open(F,In_File,F_Name);
      for J in V'Range loop
         Get(F,V(J),Brackets,Decimal,ShowErr);
      end loop;
      Close(F);
   exception
      when Ada.Text_IO.End_Error  =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
      when Ada.IO_Exceptions.Data_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read_Vec;


   procedure   Read_Vector(F_Name: in String; V: out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)is
   begin
      <<REREAD>> Read_Vec(F_Name,V,Brackets,Decimal,ShowErr);
      if EX=1 then
         EX:=0;
         delay 0.001;
         goto REREAD;
      end if;
   end Read_Vector;


   procedure   Read(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      --Vec_Read is the file from which the information is read
      --Vec_Log is the file to which the info is written
      F: File_Type;
      Write_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;ShortPut(I); Put("-th iteration: reading...");
      end if;
      while Write_Mark/=(I-1) loop
         <<REREAD>> Read_Integer(Write_Log,Write_Mark); --reading the Write_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;

         if Write_Mark=I-1 then
            Read_Vector(Vec_Read,V,Brackets,Decimal,ShowErr);
            Open(F,Out_File,Read_Log);
            Put(F,I);  --putting the Read_Mark
            Close(F);
         elsif  Write_Mark>=I then
            New_Line;
            Put("File already rewritten by ");ShortPut(Write_Mark);
            New_Line;
            Message("RG_Ops.Read",Parameter_Error);
         else
            delay 0.001;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read;


   procedure   Read_B(Write_Log,Comp_Read: in String; V: out Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      --Comp_Read is the file from which the information is read
      --Write_Log is the file to which the info is written
      F: File_Type;
      Write_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;
         Put("Reading in Beltrami...");
      end if;
      while Write_Mark/=0 loop
         <<REREAD>> Read_Integer(Write_Log,Write_Mark); --reading the Write_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;
         if Write_Mark=0 then
            Open(F,Out_File,Comp_Read);
            Get(F,V,Brackets,Decimal,ShowErr);
            Close(F);
         else
            delay 0.001;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read_B;


   procedure   Read_T(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)   is
      --Vec_Read is the file from which the information is read
      --Vec_Log is the file to which the info is written
      F: File_Type;
      Write_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;ShortPut(I); Put("-th iteration: reading inside the transform...");
      end if;
      while Write_Mark/=I loop
         <<REREAD>> Read_Integer(Write_Log,Write_Mark); --reading the Write_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;
         if Write_Mark=I then
            Read_Vector(Vec_Read,V,Brackets,Decimal,ShowErr);
            Create(F,Out_File,Read_Log);
            Put(F,I);  --putting the Read_Mark
            Close(F);
         elsif  Write_Mark>=I then
            New_Line;
            Put("File already rewritten by ");ShortPut(Write_Mark);
            New_Line;
            Message("RG_Ops.Read_T",Parameter_Error);
         else
            delay 0.001;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read_T;


   procedure   Read_P(I: in Integer; Read_Log,Write_Log,Vec_Read: in String; V: in out CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True)is
      --Vec_Read is the file from which the information is read
      --Vec_Log is the file to which the info is written
      F: File_Type;
      Write_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;ShortPut(I); Put("-th iteration: reading inside the transform...");
      end if;
      while Write_Mark/=I loop
         <<REREAD>> Read_Integer(Write_Log,Write_Mark); --reading the Write_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;
         if Write_Mark=I then
            Read_Vector(Vec_Read,V,Brackets,Decimal,ShowErr);
            Create(F,Out_File,Read_Log);
            Put(F,I);  --putting the Read_Mark
            Close(F);
         elsif  Write_Mark>=I then
            New_Line;
            Put("File already rewritten by ");ShortPut(Write_Mark);
            New_Line;
            Message("RG_Ops.Read_P",Parameter_Error);
         else
            delay 0.01;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Read_P;


   procedure Read_SB(H: out CompMatrix; File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      N1,N2,M: Integer;
      F: File_Type;
      C: Comp;
   begin
      Open(F,In_File,File_Name);
      Get(F,N1); Get(F,N2); Get(F,M);
      if N1/=H'First(1) or N2/=H'Last(1) or M/=H'Length(2)  then
         Message("RG_Ops.Read_SB",Index_Error);
      end if;
      for I in H'Range(1) loop
         for J in H'Range(2) loop
            Get(F,C,Brackets,Decimal,ShowErr);
            H(I,J):=C;
         end loop;
      end loop;
      Close(F);
      if In_Values=Out_Values then
         return; --in and out values or series
      elsif In_Values and not Out_Values then
         FT(H); -- in values, out series
         return;
      else
         FT(H,True);--in series, out values
      end if;
   end Read_SB;

   procedure  Read_Part(H: out CompMatrix; File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      N1,N2,M: Integer;
      F: File_Type;
      C: Comp;
   begin
      Open(F,In_File,File_Name);
      Get(F,N1); Get(F,N2); Get(F,M);
      if N1/=H'First(1) or N2/=H'Last(1) or M/=(H'Length(2)-5)  then
         Message("RG_Ops.Read_SB",Index_Error);
      end if;
      for I in H'Range(1) loop
         for J in H'First(2)..(H'Last(2)-5) loop
            Get(F,C,Brackets,Decimal,ShowErr);
            H(I,J):=C;
         end loop;
         for J in (H'Last(2)-4)..H'Last(2) loop
            H(I,J):=CoZero;
         end loop;
      end loop;
      Close(F);
      if In_Values=Out_Values then
         return; --in and out values or series
      elsif In_Values and not Out_Values then
         FT(H); -- in values, out series
         return;
      else
         FT(H,True);--in series, out values
      end if;
   end Read_Part;


   procedure  Read_Renorm(H: out CompMatrix; N: in Integer;  File_Name: in String; In_Values,Out_Values: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      use Ada.Strings.Unbounded;
      N1,N2,M,Int1,Int2: Integer;
      F: File_Type;
      C: Comp;
      NM: Unbounded_String;
   begin
      for J in 1..N loop
         NM:=To_Unbounded_String(Integer'Image(J)(2..Integer'Image(J)'Last));
         Int1:=Integer'Image(J)'Length;
         Int2:=Integer'Image(N)'Length;
         for I in Int1..Int2 loop
            NM:=To_Unbounded_String("0") & NM;
         end loop;
         Open(F,In_File,File_Name & "_" &  To_String(NM));
         Get(F,N1); Get(F,N2); Get(F,M);
         if M/=H'Length(2) then
            New_Line;
            Message("RG_Ops.Read_Renorm",Index_Error);
         end if;
         for I in N1..N2 loop
            for J in -M/2..M/2-1 loop
               Get(F,C,Brackets,Decimal,ShowErr);
               H(I,J):=C;
            end loop;
         end loop;
         Close(F);
      end loop;
      if In_Values=Out_Values then
         null;
      elsif In_Values and not Out_Values then
         FT(H); -- in values, out series
      else
         FT(H,True);--in series, out values
      end if;
      return;
   end Read_Renorm;


   procedure  Write(I: in Integer; Read_Log,Write_Log, Vec_Write: in String; V: in CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      F,FF: File_Type;
      Read_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;ShortPut(I); Put("-th iteration: writing...");
      end if;
      while Read_Mark/=I loop
         <<REREAD>> Read_Integer(Read_Log,Read_Mark); --reading the Read_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;
         if Read_Mark=I then
            Open(F,Out_File,Vec_Write);
            for J in V'Range loop
               Put(F,V(J),Brackets,Decimal,ShowErr);
            end loop;
            Close(F);
            Open(F,Out_File,Write_Log);
            Put(F,I);
            Close(F);
         elsif Read_Mark>I then
            New_Line;
            Put("File already read by ");ShortPut(Read_Mark);
            New_Line;
            Message("RG_Ops.Write",Parameter_Error);
         else
            delay 0.001;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Write;


   procedure  Write_B(Write_Log, Comp_Write: in String; V: in Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      F,FF: File_Type;
   begin
      if EX=0 then
         New_Line;
         Put("Writing in Beltrami...");
      end if;

      Open(F,Out_File,Comp_Write);
      Put(F,V,Brackets,Decimal,ShowErr);
      Close(F);
      Open(F,Out_File,Write_Log);
      Put(F,0);
      Close(F);

      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Write_B;


   procedure  Write_T(I: in Integer; Read_Log,Write_Log, Vec_Write: in String; V: in CompArray; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      F,FF: File_Type;
      Read_Mark: Integer:=-1;
   begin
      if EX=0 then
         New_Line;ShortPut(I); Put("-th iteration: writing inside the transform...");
      end if;
      while Read_Mark/=(I-1) loop
         <<REREAD>> Read_Integer(Read_Log,Read_Mark); --reading the Read_Mark
         if EX=1 then
            EX:=0;
            goto REREAD;
         end if;
         if Read_Mark=(I-1) then
            Open(F,Out_File,Vec_Write);
            for J in V'Range loop
               Put(F,V(J),Brackets,Decimal,ShowErr);
            end loop;
            Close(F);
            Create(F,Out_File,Write_Log);
            Put(F,I);
            Close(F);
         elsif Read_Mark>I then
            New_Line;
            Put("File already read by ");ShortPut(Read_Mark);
            New_Line;
            Message("RG_Ops.Write_T",Parameter_Error);
         else
            delay 0.01;
         end if;
      end loop;
      EX:=0;
      Put(" done");
   exception
      when Ada.Text_IO.End_Error =>
         Close(F);
         Put(" handling exception...");
         EX:=1;
         return;
   end Write_T;


   procedure  Write_SB(H: in CompMatrix; File_Name: in String; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in  Boolean:=True) is
      F: File_Type;
   begin
      Create(F,Out_File,File_Name);
      Put(F,H'First(1)); Put(F,H'Last(1)); Put(F,H'Length(2));
      New_Line(F);
      for I in H'Range(1) loop
         for J in H'Range(2) loop
            Put(F,H(I,J),Brackets,Decimal,ShowErr);
         end loop;
         New_Line(F);
      end loop;
      Close(F);
   end Write_SB;

end RG_Ops;



















