--with Generic_My_Elementary_Functions;
--pragma Elaborate_All(Generic_My_Elementary_Functions);

with Ada.Numerics.Generic_Elementary_Functions;

pragma Elaborate_All(Ada.Numerics.Generic_Elementary_Functions);


package body Reps.Ops is

  function Sqr(R: Rep) return Rep is
  begin
    return R*R;
  end Sqr;



  function My_Exp(R: Rep) return Rep is
  begin
     if R=Zero then return One;
     end if;
      declare
         X,Y: Rep;
      begin
         declare
            Iter: constant Integer := 200;
            K: Integer := 0;
            R1: Rep;
         begin
            R1 := abs(R);
            while R>Quarter loop
               K := K+1;
               R1 := R1*Half;
            end loop;
            X := (Half**K)*R;
            Y := Zero;
            for I in reverse 1 .. Iter loop
               Y := One+(X*Y)/Rep(I);
            end loop;
            for I in 1 .. K loop
               Y := Y*Y;
            end loop;
            return Y;
         end;
      end;
  end My_Exp;


  function Short_Exp(R: Rep; Iter: Integer) return Rep is
     Y: Rep;
  begin
     if R=Zero then return One;
     end if;
     Y := Zero;
     for I in reverse 1 .. Iter loop
        Y := One+(abs(R)*Y)/Rep(I);
     end loop;
     if R<Zero then
        Y:=One/Y;
     end if;
     return Y;
     end Short_Exp;


  function Powof2(M: Integer) return Integer is
     K: Integer;
  begin
     K:=1;
     for I in 1..M loop
        K:=2*K;
     end loop;
     return K;
  end Powof2;

  function Modulo(R: Rep; M: Rep) return Rep is
  begin
     if R=Zero then return R; end if;
     if M*Rep(Long_Long_Integer(abs(R)/M))>abs(R) then  --(K+1)*M > R> (K+1/2)*M, rounds to K+1
        if Sign(R)>=Zero then
           return  R-(M*Rep(Long_Long_Integer(abs(R)/M))-One); --positive R
        else
           return M*Rep(Long_Long_Integer(abs(R)/M))+R; -- negative R
        end if;
     else    -- (K+1/2)*M > R> K*M, rounds to K
        if Sign(R)>=Zero then
           return R-M*Rep(Long_Long_Integer(abs(R)/M));
        else
           return (M*Rep(Long_Long_Integer(abs(R)/M))+One)+R;
        end if;
     end if;
  end Modulo;


  function IntPart(R: Rep) return Integer is
     I: constant Integer:=Integer(R);
  begin
     if R>=Zero and Rep(I)>R then
        return I-1;
     elsif  R>=Zero and Rep(I)<=R then
        return I;
     elsif  R<Zero and Rep(I)<R then
        return I+1;
     else
        return I;
     end if;
  end IntPart;


--  function "**"(S: Rep; I: Integer) return Rep is
--  begin
--     if I>0 then
--        declare
--           J: Integer := I;
--           X,Y: Rep;
--        begin
--           X := S;
--           if (J rem 2)=0 then
--              Y := One;
--           else
--              Y := X;
--           end if;
--           J := J/2;
--           while J>0 loop
--              X := Sqr(X);
--              if (J rem 2)>0 then
--                 Y := X*Y;
--              end if;
--              J := J/2;
--           end loop;
--           return Y;
--        end;
--     elsif I<0 then
--        return (One/S)**(-I);
--     else
--        return One;
--     end if;
--  end "**";


  function Pouer(S: Rep; I: Integer) return Rep is
  begin
     if I>0 then
        declare
           J: Integer := I;
           X,Y: Rep;
        begin
           X := S;
           if (J rem 2)=0 then
              Y := One;
           else
              Y := X;
           end if;
           J := J/2;
           while J>0 loop
              X := Sqr(X);
           --   if X<Rep(1.0E-20) then
           --      return Rep'Small;
           --   end if;
              if (J rem 2)>0 then
                 Y := X*Y;
              end if;
              J := J/2;
           --   if Y<Rep(1.0E-20) then
           --      return Rep'Small;
           --   end if;
           end loop;
           return Y;
        end;
     elsif I<0 then
        return (One/S)**(-I);
     else
        return One;
     end if;
  end Pouer;


  procedure CosSin(S: in Rep; Sc,Ss: out Rep; Iter: in Integer:=9) is
     Co: Rep;
  begin
     if S = Zero then
        Sc := One;
        Ss := S;
     else
        declare
           K: Integer;
           R: Rep;
           X,T: Rep;
        begin
           K := 0;
           R := abs(S);
           while R>Half loop
              K := K+1;
              R := R*Half;
           end loop;
           X := (Half**K)*S;
           T := Sqr(X);
           Sc := One;
           Ss := Sc;
           if ((Iter-1) mod 2)=0 then
              Co:=One;
           else
              Co:=-One;
           end if;
           for I in reverse 1 .. Iter loop
              Sc := Co+Sc*T/Rep((2*I)*(2*I-1));
              Ss := Co+Ss*T/Rep((2*I)*(2*I+1));
              Co:=-Co;
           end loop;
           Ss := X*Ss;
           for I in 1 .. K loop
              T := Sc;
              Sc := One-Two*Sqr(Ss);
              Ss := Two*(T*Ss);
           end loop;
        end;
     end if;
     if abs(Sc)>One then Sc:=Sign(Sc)*One; end if;
     if abs(Ss)>One then Ss:=Sign(Ss)*One; end if;
  end CosSin;


  function Cos(S: Rep; Iter: Integer:=9)  return Rep is
     Sc,Ss: Rep;
  begin
     CosSin(S,Sc,Ss,Iter);
     return Sc;
  end Cos;

  function Sin(S: Rep; Iter: Integer:=9) return Rep is
     Sc,Ss: Rep;
  begin
     CosSin(S,Sc,Ss,Iter);
    return Ss;
  end Sin;


  function Max(R1,R2: Rep) return Rep is
  begin
     if R1>R2 then return R1;
     else return R2;
     end if;
  end Max;


  function Min(R1,R2: Rep) return Rep is
  begin
     if R1<R2 then return R1;
     else return R2;
     end if;
  end Min;


  function Sign(R: Rep) return Rep is
  begin
     if R>=Zero then return One;
     else return -One;
     end if;
  end Sign;


  procedure NextRandom(I: in out Long_Integer) is
     Hi,Lo: Long_Integer;
  begin
     Hi := I/127773;
     Lo := I-127773*Hi;
     I := 16807*Lo-2836*Hi;
     if I < 0 then
        I := I+2147483647;
     end if;
  end NextRandom;


  procedure RandomRep(Seed: in out Long_Integer; R: out Rep) is
  begin
     NextRandom(Seed);
     R:=(One-Two*Rep(Seed)/Rep(2147483647));
  end RandomRep;

  --  package Rep_EF is new Generic_My_Elementary_Functions(Rep);
  package Rep_EF is new Ada.Numerics.Generic_Elementary_Functions(Rep);
  function Sqrt(R: Rep) return Rep renames Rep_EF.Sqrt;
  --  function Cos(R: Rep) return Rep renames Rep_EF.Cos;
  --  function Tan(R: Rep) return Rep renames Rep_EF.Cos;
  --  function Sin(R: Rep) return Rep renames Rep_EF.Sin;
  function Log(R: Rep) return Rep renames Rep_EF.Log;
  function "**"(R1,R2: Rep) return Rep renames Rep_EF."**";
  --  function "**"(S: Rep; I: Integer) return Rep renames Rep_EF."**";
  function Cosh(R: Rep) return Rep renames Rep_EF.Cosh;
  function Sinh(R: Rep) return Rep renames Rep_EF.Sinh;
  function Tanh(R: Rep) return Rep renames Rep_EF.Tanh;
  function Exp(R: Rep) return Rep renames Rep_EF.Exp;
  function ArcCos(R: Rep) return Rep renames Rep_EF.ArcCos;
  function ArcSin(R: Rep) return Rep renames Rep_EF.ArcSin;
  function ArcTan(R: Rep; R1: Rep; Cycle: Rep) return Rep renames Rep_EF.ArcTan;
end Reps.Ops;
