with Ada.Text_IO;
use Ada.Text_IO;

  pragma Elaborate_All (Ada.Text_IO);

package Reps.IO is

  procedure Txt_Get(F: in File_Type; R: out Rep; Decimal: in Boolean := True);
  procedure Txt_Get(F: in File_Type; R1,R2: out Rep; Decimal: in Boolean := True);
  procedure Txt_Get(F: in File_Type; R1,R2,R3: out Rep; Decimal: in Boolean := True);
  procedure Txt_Put(F: in File_Type; R: in Rep; Decimal: in Boolean := True);
  procedure Txt_ShortPut(F: in File_Type; R: in Rep; Decimal: in Boolean := True);
  procedure Txt_Put(F: in File_Type; R1,R2: in Rep; Decimal: in Boolean := True);
  procedure Txt_Put(F: in File_Type; R1,R2,R3: in Rep; Decimal: in Boolean := True);
  procedure ShortPut(I: in Integer; F: in File_Type:=Current_Output);
  function Count_Lines(Max_Line_Length: Integer; File_Name : String ) return Integer;
  procedure Copy_File (Original, Copy: in String);
private

   function Val(S: String) return Rep;        -- convert Hex String to Rep
   function HexStr(I: Integer) return String; -- convert Integer to Hex String
   function HexStr(R: Rep) return String;     -- convert Rep to Hex String

end Reps.IO;
