with Reps;
use Reps;

package Numerics is

  pragma Pure;

  type Numeric is new Rep;

  function IsNumeric(S: Numeric) return Boolean;
  function Scal(K: Integer) return Numeric;
  function Scal(R: Rep) return Numeric;
  function Ball(R: Rep) return Numeric;
  function Err0(S: Numeric) return Boolean renames IsNumeric;
  function Approx(S: Numeric) return Rep;
  function Err(S: Numeric) return Rep;
  function Center(S: Numeric) return Numeric;
  procedure ResetCenter(S: in out Numeric);
  function ResetCenter(S: Numeric) return Numeric;
  procedure Split(S: in Numeric; S0,SE: out Numeric);

  pragma Inline (IsNumeric,Scal,Scal,Ball,Err0,Approx,Center,ResetCenter,Split);
  pragma Inline_Always (IsNumeric,Scal,Scal,Ball,Err0,Approx,Center,ResetCenter,Split);

end Numerics;
