with Reps.Ops, Ada.Numerics.Generic_Elementary_Functions;
use Reps.Ops;
package Numerics.Ops is

  pragma Elaborate_Body;

  package Numeric_EF is new Ada.Numerics.Generic_Elementary_Functions(Numeric);
  use Numeric_EF;

  function Contains(R1,R2: Numeric) return Boolean;
  function Scal(R1,R2: Rep) return Numeric;
  function Ball(S: Numeric) return Numeric;
  function Inf(S: Numeric) return Rep renames Approx;
  function Sup(S: Numeric) return Rep renames Approx;
  function SupAbs(S: Numeric) return Rep;
  function IntFloor(S: Numeric) return Integer;
  function IntCeiling(S: Numeric) return Integer;
  function Min(S1,S2: Numeric) return Numeric renames Numeric'Min;
  function Max(S1,S2: Numeric) return Numeric renames Numeric'Max;
  function Cap(R: Radius; S: Numeric) return Numeric;
  function Up(R: Rep; Dummy: Numeric) return Rep;
  function Widen(S: Numeric) return Numeric renames Center;
  procedure ErrMult(R: in Rep; S: in out Numeric);

  function "*"(R: Rep; S: Numeric) return Numeric;
  function "*"(S: Numeric; R: Rep) return Numeric;
  function Inv(S: Numeric) return Numeric;
  function "/"(S: Numeric; R: Rep) return Numeric;
  function "/"(R: Rep; S: Numeric) return Numeric;
  function Sqr(S: Numeric) return Numeric;
  function Short_Exp(R: Numeric; Iter: Integer) return Numeric;

  function MinusPi_Pi(S: Numeric) return Numeric;
  function Cosh(S: Numeric) return Numeric renames Numeric_EF.Cosh;
  function Sinh(S: Numeric) return Numeric renames Numeric_EF.Sinh;
  function Sin(S: Numeric) return Numeric;
  function Cos(S: Numeric) return Numeric;
  function Exp(S: Numeric) return Numeric renames Numeric_EF.Exp;
  function Log(S: Numeric) return Numeric renames Numeric_EF.Log;
  function Sqrt(S: Numeric) return Numeric renames Numeric_EF.Sqrt;
  procedure CosSin(S: in Numeric; Sc,Ss: out Numeric);

  pragma Inline (Ball,Inf,Sup,SupAbs,ErrMult,Sqr,Inv);
  pragma Inline_Always (Ball,Inf,Sup,SupAbs,ErrMult,Sqr,Inv);

private

end Numerics.Ops;
