package body Messages is

   procedure Message(Where: in String; What: in Problem) is
   begin
      case What is

         when Division_By_Zero =>
            Put(Where);
            Put(": Division_By_Zero");
            New_Line;
            raise Leaving;

         when Matrix_Singular =>
            Put(Where);
            Put(": Singular_Matrix");
            New_Line;
            raise Leaving;

         when Nonzero_Im_Error =>
            Put(Where);
            Put(": Nonzero imaginary part in error");
            New_Line;
            raise Leaving;


         when Zero_In_Log =>
            Put(Where);
            Put(": Zero_In_Log");
            New_Line;
            raise Leaving;

         when Positive_Real_In_Ei =>
            Put(Where);
            Put(": Positive_Real_In_Ei");
            New_Line;
            raise Leaving;

         when Reading_Error =>
            Put(Where);
            Put(": Reading_Error");
            New_Line;
            raise Leaving;

         when Index_Error =>
            Put(Where);
            Put(": Index_Error");
            New_Line;
            raise Leaving;

         when Parity_Error =>
            Put(Where);
            Put(": Parity_Error");
            New_Line;
            raise Constraint_Error;

         when Parameter_Error =>
            Put(Where);
            Put(": Parameter_Error");
            New_Line;
            raise Constraint_Error;

         when Domain_Error =>
            Put(Where);
            Put(": Domain_Violation");
            New_Line;
            raise Constraint_Error;

         when Domain_Violation =>
            Put(Where);
            Put(": Domain_Violation");
            New_Line;

         when Numeric_Only =>
            Put(Where);
            Put(": Numeric_Only");
            New_Line;

         when Not_Implemented =>
            Put(Where);
            Put(": Not_Implemented");
            New_Line;

         when Giving_Up =>
            Put(Where);
            Put(": Giving_Up");
            New_Line;
            raise Leaving;

      end case;


   end Message;

end Messages;













