with Reps;
use Reps;

package Intervals is

  pragma Pure;

  type Interval is private;

  function IsNumeric(S: Interval) return Boolean;
  function Scal(K: Integer) return Interval;
  function Scal(R: Rep) return Interval;
  function Ball(R: Rep) return Interval;
  function Err0(S: Interval) return Boolean;
  function Approx(S: Interval) return Rep;
  function Err(S: Interval) return Rep;
  function "-"(S: Interval) return Interval;
  function Center(S: Interval) return Interval;
  procedure ResetCenter(S: in out Interval);
  function ResetCenter(S: Interval) return Interval;
  procedure Split(S: in Interval; S0,SE: out Interval);

  pragma Inline (IsNumeric,Scal,Scal,Ball,Err0,Approx,"-",Center,ResetCenter,Split);
  pragma Inline_Always (IsNumeric,Scal,Scal,Ball,Err0,Approx,"-",Center,ResetCenter,Split);

private

  type Interval is  -- also used for balls in other spaces
    record
      C: Rep;       -- center of ball
      R: Rep;       -- radius of ball
    end record;

end Intervals;
