
package Intervals.Ops is

  pragma Elaborate_Body;

  function Contains(R1,R2: Interval) return Boolean;
  function Scal(R1,R2: Rep) return Interval;
  function Ball(S: Interval) return Interval;
  function Inf(S: Interval) return Rep;
  function Sup(S: Interval) return Rep;
  function SupAbs(S: Interval) return Rep;
  function "<"(S1,S2: Interval) return Boolean;
  function IntFloor(S: Interval) return Integer;
  function IntCeiling(S: Interval) return Integer;
  function "abs"(S: Interval) return Interval;
  function Min(S1,S2: Interval) return Interval;
  function Max(S1,S2: Interval) return Interval;
  function Cap(R: Radius; S: Interval) return Interval;
  function Up(R: Rep; Dummy: Interval) return Rep;
  function Widen(S: Interval) return Interval;
  procedure ErrMult(R: in Rep; S: in out Interval);

  function "+"(S,T: Interval) return Interval;
  function "-"(S,T: Interval) return Interval;
  function "*"(R: Rep; S: Interval) return Interval;
  function "*"(S: Interval; R: Rep) return Interval;
  function "*"(S,T: Interval) return Interval;
  function Inv(S: Interval) return Interval;
  function "/"(S: Interval; R: Rep) return Interval;
  function "/"(R: Rep; S: Interval) return Interval;
  function "/"(S,T: Interval) return Interval;
  function Sqr(S: Interval) return Interval;
  function "**"(S: Interval; I: Integer) return Interval;
  function Short_Exp(R: Interval; Iter: Integer) return Interval;

  function MinusPi_Pi(S: Interval) return Interval;
  function Cosh(S: Interval) return Interval;
  function Sinh(S: Interval) return Interval;
  function Sin(S: Interval) return Interval;
  function Cos(S: Interval) return Interval;
  function Exp(S: Interval) return Interval;
  function Log(S: Interval) return Interval;
  function Sqrt(S: Interval) return Interval;
  procedure CosSin(S: in Interval; Sc,Ss: out Interval);

  pragma Inline (Ball,Inf,Sup,SupAbs,ErrMult,"abs","+","-","*",Sqr,Inv);
  pragma Inline_Always (Ball,Inf,Sup,SupAbs,ErrMult,"abs","+","-","*",Sqr,Inv);

private

   procedure CoshSinh(S: in Interval; Sc,Ss: out Interval);

end Intervals.Ops;
