with Reps.Ops, Messages, Conumbers.IO;
use  Reps.Ops, Messages;
with Ada.Text_IO,Ada.Float_Text_IO,Reps.IO;
use Ada.Text_IO,Ada.Float_Text_IO,Reps.IO;

pragma Elaborate_All (Reps.Ops);

package body CoNumbers.Ops is

   CoNumber_One: constant CoNumber:=Complecs(One,Zero);
   CoNumber_Zero: constant CoNumber:=Complecs(Zero,Zero);

   pragma Suppress(Storage_Check);

   function Contains(S: CoNumber; C: CoNumber) return  Boolean is
   begin  --here ball is really a rectangle
      return  S=C;
   end Contains;


   function Intersects(S: CoNumber; T: CoNumber) return Boolean is
   begin  --here ball is really a rectangle
      return  S=T;
   end Intersects;


   function SetBall(R1,R2: Numeric) return CoNumber is
   begin
      return Complecs(Rep(R1),Rep(R2));
   end SetBall;


   function RePart(C: CoNumber) return Numeric is
   begin
      return Scal(Re(C));
   end RePart;


   function ImPart(C: CoNumber) return Numeric is
   begin
      return Scal(Im(C));
   end ImPart;


   function AbsBall(S: CoNumber) return CoNumber is
   begin
      return Complecs(abs(S),Zero);
   end AbsBall;


   function AbsVal(S: CoNumber) return Numeric is
   begin
      return  Scal(abs(S));
   end AbsVal;


   function Cap(R: Radius; S: CoNumber) return CoNumber is
      -- bound on characteristic_function for closed ball of radius R
   begin
      if SupMod(S) <= R then
         return S;
      else
         return Complecs(Zero,Zero);
      end if;
   end Cap;


   function MaxMod(S1,S2: CoNumber) return CoNumber is
   begin
      if AbsVal(S1)<AbsVal(S2) then return AbsBall(S2);
      else return AbsBall(S1);
      end if;
   end MaxMod;


   procedure ErrMult(R: in Rep; S: in out CoNumber) is
   begin
      null;
   end ErrMult;


   procedure RandomBall(Seed: in out Long_Integer; C: out CoNumber) is
      Re,Im: Rep;
   begin
      NextRandom(Seed);
      Re:=One-Two*Rep(Seed)/Rep(2147483647);
      NextRandom(Seed);
      Im:=One-Two*Rep(Seed)/Rep(2147483647);
      C:=Complecs(Re,Im);
   end RandomBall;


   function Sqr(S: CoNumber) return CoNumber is
   begin
      return S*S;
   end Sqr;


   function PiBall return CoNumber is
   begin
      return Complecs(Pi,Zero);
   end PiBall;


   function Inv(S: CoNumber) return CoNumber is
   begin
      return  One/S;
   end Inv;


   function Long_Inv(S: CoNumber) return CoNumber is
   begin
      return  One/S;
   end Long_Inv;


   function "*"(R: Numeric; S: CoNumber) return CoNumber is
   begin
      return Rep(R)*S;
   end "*";


   function "/"(S: CoNumber; R: Numeric) return CoNumber is
   begin
      return Complecs(Re(S)/Rep(R),Im(S)/Rep(R));
   end "/";


   function Arg(S: CoNumber) return Numeric is
   begin
      return Scal(Argument(S));
   end Arg;


   function Exp(S: CoNumber) return CoNumber is
   begin
      if S=Complecs(Zero,Zero) then return Complecs(One,Zero); end if;   -- S=0
      declare
         X,Y: CoNumber;
      begin
         declare
            Iter: constant Integer := 32;
            K: Integer := 0;
            R: Rep;
         begin
            R := Rep(AbsVal(S));
            while R>Quarter loop
               K := K+1;
               R := R*Half;
            end loop;
            X := (Complecs(Half,Zero)**K)*S;
            Y := Complecs(Zero,Zero);
            for I in reverse 1 .. Iter loop
               Y := Complecs(One,Zero)+(X*Y)/Rep(I);
            end loop;
            for I in 1 .. K loop
               Y := Y*Y;
            end loop;
            return Y;
         end;
      end;
   end Exp;


   function EiExp(S1,S2: CoNumber; NumErr: Rep:=Rep(1.0E-15)) return CoNumber is
      G: constant CoNumber:=Complecs(Rep(0.57721566490153285),Zero);
      Y,X: CoNumber;
      C,C1: Rep;
      K: Integer:=0;
      J: Integer;
      Er: Rep:=Rep(1.0E+100);
      Co: CoNumber:=CoNumber_One;
   begin
      Y:=CoNumber_One;
      X:=CoNumber_One;
      J:=1;
      while Er>SupMod(NumErr*Y) loop
         X:=Rep(J)*X*S1;
         Y:=Y+X;
         J:=J+1;
         Er:=SupMod(X);
         if Er>Rep(1.0E+100) then goto SECOND; end if;
      end loop;
      return Y*S1;
      <<SECOND>> null;
      Y:=CoNumber_Zero;
      X:=CoNumber_One;
      C1:=One;
      J:=1;
      while Er>SupMod(NumErr*Y) loop
         C1:=C1/Rep(J);
         C:=C1/Rep(J);
         X:=X*S2;
         Y:=Y+C*X;
         J:=J+1;
         Er:=SupMod(C*X);
      end loop;
      return  Exp(Neg(S2))*(G+Log(Neg(S2))+Y);
   end EiExp;


   function Log(S: CoNumber) return CoNumber is
   begin
      if Contains(S,Complecs(Zero,Zero)) then
         Message("CoNumbers.Ops.Log",Zero_In_Log);
      end if;
      if S=Complecs(One,Zero) then return Complecs(Zero,Zero); end if;
      declare
         Iter: constant Integer := 64;
         S0,LogS0,X,Y: CoNumber;
      begin
         LogS0 := Complecs(Half*Log(Re(S)*Re(S)+Im(S)*Im(S)),Argument(S));   --- guess
         S0 := Exp(LogS0);
         X := (S0-S)/S0;
         Y := Complecs(Zero,Zero);
         for I in reverse 1 .. Iter loop
            Y := Complecs(One,Zero)/Rep(I)+X*Y;
         end loop;
         return LogS0-X*Y;
      end;
   end Log;


   function Csgn(S: CoNumber) return Integer is
   begin
      if Re(S)>Zero or (Re(S)=Zero and Im(S)>Zero) then
         return  1;
      elsif  Re(S)<Zero or (Re(S)=Zero and Im(S)<Zero) then
         return -1;
      else
         return 0;
      end if;
   end Csgn;
end CoNumbers.Ops;
