with Reps,Ada.Numerics.Generic_Complex_Types,Intervals;
use Reps,Intervals;

package CoBalls is

   pragma Pure;

   package Complex_Types is new Ada.Numerics.Generic_Complex_Types(Rep);
   use Complex_Types;

   subtype CoNum is Complex_Types.Complex;
   type CoBall is private;

   function Conj(C: CoBall) return CoBall;
   function SetBall(C: CoBall;R: Rep:=Zero) return CoBall;
   function IsCoNumber(S: CoBall) return Boolean;               --returns False
   function IsBall(S: CoBall) return Boolean;                   --returns True
   function Complecs(Re,Im: Rep) return CoBall;                 --returns a ball with the specified center and zero radius
   function Ball0(R: Rep) return CoBall;                        --returns a ball with the zero center and specified radius
   function Ball0(R: CoBall) return CoBall;                     --returns a ball with the zero center and radius equal to sup(abs(R))
   function Center0(S: CoBall) return Boolean;                  --checks if the center is zero
   function Err0(S: CoBall) return Boolean;                     --checks if the radius is zero
   function ErrPart(S: CoBall) return Rep;                      --returns the radius
   procedure ResetCenter(S: in out CoBall);                     --zeros the center
   function ResetCenter(S: CoBall) return CoBall;               --zeros the center
   procedure Split(S: in CoBall; Sr,Se: out CoBall);            --splits a ball into a ball with the original center a nd zero radius and a ball with the zero center and the original radius
   procedure ResetErr(S: in out CoBall);                        --sets error equal to zero
   function ResetErr(S: CoBall) return CoBall;                  --returns a coball with zero error
   function CenterBall(S: CoBall) return CoBall;                --returns the center

   pragma Inline (Conj,Ball0,Ball0,SetBall,IsCoNumber,IsBall,Complecs,Center0,Err0,ErrPart, ResetCenter, ResetCenter,Split,ResetErr, CenterBall,SetBall);
   pragma Inline_Always (Conj,Ball0,Ball0,SetBall,IsCoNumber,IsBall,Complecs,Center0,Err0,ErrPart, ResetCenter, ResetCenter,Split,ResetErr,CenterBall,SetBall);

private
   type CoBall is
      record
         C: CoNum;
         R: Rep;
      end record;
end CoBalls;

