with Reps, Reps.Ops, Reps.IO, Messages, RG_Ops, Ada.Numerics.Generic_Elementary_Functions,Ada.Characters.Latin_1, Round_Up,Numerics, Numerics.Ops, Numerics.IO;
with CoNumbers, CoNumbers.Ops, CoNumbers.IO, Ada.Text_IO,Ada.Float_Text_IO, GetOpt, Ada.Command_Line,Ada.Strings.Unbounded;
use Reps, Reps.Ops, Reps.IO, Messages, Numerics, Numerics.Ops, Numerics.IO,CoNumbers, CoNumbers.Ops, CoNumbers.IO, Ada.Text_IO,Ada.Float_Text_IO, GetOpt, Ada.Command_Line, Ada.Strings.Unbounded;

pragma Elaborate_All(Numerics.Ops);
pragma Elaborate_All(CoNumbers.Ops,CoNumbers.IO);
pragma Elaborate_All(Reps.Ops);
pragma Elaborate_All (RG_Ops);

procedure Approx_Sol is

   pragma Suppress(Storage_Check);

   Pdeg:constant Positive:=1000;
   Dho: constant Natural:=1000;
   subtype Scalar is Numeric;
   subtype Comp is CoNumber;
   package Current_RG is new RG_Ops(Pdeg,Dho,Scalar,Comp);
   use Current_RG;
   use RG_Tay, RG_Tay_Ops,RG_Tay_IO;
   package Txt_Int_IO is new Ada.Text_IO.Integer_IO(Integer);
   use Txt_Int_IO;

   Pex: constant Rep:=Rep(2.2);
   Test_String : String := "l:g:h:b:x:i:k:t:o:q:r:y:e:f:";
   Roo,NumErr: Rep;
   Read_B,Q,N1,N2,Cut_Output,Write_H,Read_A,Write_B,Va,Iter,M,K,Np1,Np2,Num_Of_Machines,This_Machine: Integer;
   Optchar : character;
   Tay_File,Out_Dir,CM: Unbounded_String;
   Read_Beltrami,Read_Approx,Write_Sol,Write_Beltrami,ShowErr: Boolean;
   IsPoly: Boolean:=True;
   GetPoly: constant Boolean:=True;
   Decimal: constant Boolean:=True;
   Brackets: constant Boolean:=False;
begin
   --DEAFULT OPTION
   K:=1;
   Num_Of_Machines:=2;
   This_Machine:=1;
   Iter:=100;
   Write_B:=1;
   Read_B:=1;
   Read_A:=0; --do not read approximation
   Write_H:=1; --save inside the iteration cycle
   Cut_Output:=6;
   Out_Dir:=To_Unbounded_String("/home/gaidash/numerics_data/");
   Tay_File:=To_Unbounded_String("/home/gaidash/numerics_data/taylor");
   Rho:=Rep(2.2);
   Q:=0;
   NumErr:=Rep(1.0E-5);

   --OPTIONS
   Getopt.Opterr := 1;
   loop
      Va := Getopt.Getopt( Test_String );
      exit when Va = -1;
      optchar :=  Character'Val( Va );
      case optchar is
         when 'o' =>
            Out_Dir:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'f' =>
            Tay_File:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'l' =>
            Cut_Output:=Integer'Value(To_String(Getopt.Optarg));
         when 'g' =>
            Read_A:=Integer'Value(To_String(Getopt.Optarg));
         when 'h' =>
            Write_H:=Integer'Value(To_String(Getopt.Optarg));
         when 'y' =>
            Read_B:=Integer'Value(To_String(Getopt.Optarg));
         when 'b' =>
            Write_B:=Integer'Value(To_String(Getopt.Optarg));
         when 'x' =>
            Num_Of_Machines:=Integer'Value(To_String(Getopt.Optarg));
         when 'i' =>
            Iter:=Integer'Value(To_String(Getopt.Optarg));
         when 'k' =>
            K:=Integer'Value(To_String(Getopt.Optarg));
         when 't' =>
            This_Machine:=Integer'Value(To_String(Getopt.Optarg));
         when 'r' =>
            Rho:=Rep'Value(To_String(Getopt.Optarg));
         when 'e' =>
            NumErr:=Rep'Value(To_String(Getopt.Optarg));
         when 'q' =>
            Q:=Integer'Value(To_String(Getopt.Optarg));
         when others =>
            New_Line;
            Message("Wrong option in Approx_Sol",Parameter_Error);
      end case;
   end loop;

   --UPDATING OPTIONS
   if Q=1 then
      Quad:=True;
   elsif Q=0 then
      Quad:=False;
   else
      New_Line;
      Message("Wrong option in Approx_Sol",Parameter_Error);
   end if;
   if Read_A=1 then
      Read_Approx:=True;
   elsif Read_A=0 then
      Read_Approx:=False;
   else
      New_Line;
      Message("Wrong option in Approx_Sol",Parameter_Error);
   end if;
   if Read_B=1 then
      Read_Beltrami:=True;
   elsif Read_B=0 then
      Read_Beltrami:=False;
   else
      New_Line;
      Message("Wrong option in Approx_Sol",Parameter_Error);
   end if;
   if Write_H=1 then
      Write_Sol:=True;
   elsif Write_H=0 then
      Write_Sol:=False;
   else
      New_Line;
      Message("Wrong option in Approx_Sol",Parameter_Error);
   end if;
   if Write_B=1 then
      Write_Beltrami:=True;
   elsif Write_B=0 then
      Write_Beltrami:=False;
   else
      New_Line;
      Message("Wrong option in Approx_Sol",Parameter_Error);
   end if;

   declare
      Dir: String:=To_String(Out_Dir);
      Radial_Grid: String:=Dir & "rads/radii";
      RadScal_Grid: String:=Dir & "rads/thick_radii";
      Rho_Grid: String:=Dir & "rads/rhos";
      Con_File: String:=Dir & "con_file";
      SolZeroValue_File: String:=Dir & "points/sol_val_at_zero";
      P_File: String:=Dir & "points/periodic_point";
      Cr_File: String:=Dir & "points/cr_point";
      Cn_File: String:=Dir & "points/cn_point";
      Cn2_File: String:=Dir & "points/cn2_point";
      Cn2n_File: String:=Dir & "points/cn2n_point";
      G_File: String:=Dir & "g/approx_g_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Approx_Belt_File: String:=Dir & "beltrami/approx_belt_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Belt_File: String:=Dir & "beltrami/belt_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      RN1,RN2,K1,K2,Qnmin1,Qnmin2,Qnplus1,Qnplus2,Int1,Int2: Integer;
      Cn,CrPointt,Ind_P: Comp;
      F,F1,F2: File_Type;
      Tmp,DerIterTay,Tay,IterTay: Taylor;
   begin
      New_Line;
      ShortPut(This_Machine);Put("-TH MACHINE OUT OF ");ShortPut(Num_Of_Machines);

      Qnmin1:=0;
      Qn:=1;
      Qnplus1:=2;
      Qnplus2:=3;
      for I in 2..K loop
         if I=2 then
            Qnmin2:=0;
            Qnmin1:=1;
            Qn:=2;
            Qnplus1:=3;
            Qnplus2:=5;
         else
            Qnmin2:=Qnmin1;
            Qnmin1:=Qn;
            Qn:=Qnmin2+Qnmin1;
            Qnplus1:=Qn+Qnmin1;
            Qnplus2:=Qnplus1+Qn;
         end if;
      end loop;

      --BULDING THE OUTPUT
      Int1:=Integer'Image(This_Machine)'Length;
      Int2:=Integer'Image(Num_Of_Machines)'Length-1;
      CM:=To_Unbounded_String(Integer'Image(This_Machine)(2..Integer'Image(This_Machine)'Last));
      for I in Int1..Int2 loop
         CM:=To_Unbounded_String("0") & CM;
      end loop;
      G_File:=Dir & "g/approx_g_" & To_String(CM);
      Approx_Belt_File:=Dir & "beltrami/approx_belt_" & To_String(CM);
      Belt_File:=Dir & "beltrami/belt_" & To_String(CM);

      --READING TAYLOR
      New_Line;
      Put("Reading the Taylor series ...");
      ShowErr:=False;
      Open(F,In_File,To_String(Tay_File));
      Get(Rho,F,Tay,IsPoly,GetPoly,Brackets,Decimal,ShowErr);
      Close(F);
      Put(" done");
      IterTay:=Tay;
      for I in 1..Qn-1 loop
         IterTay:=Compose(IterTay,Tay);
      end loop;
      New_Line;
      Put("Itterated Taylor series:");
      New_Line;
      Show(IterTay);

      --READING AND COMPUTING POINTS
      Put("Reading points ...");
      Ind_P:=CoZero;
      ShowErr:=False;
      Open(F,In_File,P_File);
      Get(F,P,Brackets,Decimal,ShowErr);
      Close(F);
      Open(F,In_File,Cr_File);
      Get(F,CrPointt,Brackets,Decimal,ShowErr);
      Close(F);
      CrPointt:=Neg(ExpTheta)/Two;
      Der(Rho,Rep(0.95)*Rho,IterTay,DerIterTay,IsPoly);
      Newton(1,Rho,CrPointt,DerIterTay,CoZero,IsPoly);
      Tmp:=IterTay;
      AddComponent(1,Neg(CoOne),Tmp);
      Newton(1,Rho,P,Tmp,CoZero,IsPoly);

      Open(F,In_File,Cn_File);
      Get(F,Cn,Brackets,Decimal,ShowErr);
      Close(F);
      Open(F,In_File,Cn2_File);
      Get(F,Cn2,Brackets,Decimal,ShowErr);
      Close(F);
      Open(F,In_File,Cn2n_File);
      Get(F,Cn2n,Brackets,Decimal,ShowErr);
      Close(F);
      LogB:=Neg(IBall)*Log(CoOne-P/Cn2);--image of C_{n+2} under inverse tau
      LogA:=AbsVal( Log(  (Cn2n-P)*Cn2/((Cn2-P)*Cn2n)  )  );
      LogBB:=LogB;
      Put(" done");


      --READING THE DIMENSIONS OF THE  RADIAL GRID
      Open(F,In_File,Radial_Grid);
      Get(F,N1);  Get(F,N2); Get(F,M);
      Close(F);
      if This_Machine=1 then
         Np1:=N1+(This_Machine-1)*Integer((-N1)/Num_Of_Machines);
         Np2:=N1+This_Machine*Integer((-N1)/Num_Of_Machines)-1;
         RN1:=Np1;RN2:=Np2+1;
      elsif This_Machine=Num_Of_Machines then
         Np1:=N1+(This_Machine-1)*Integer((-N1)/Num_Of_Machines);
         Np2:=0;
         RN1:=Np1-1;RN2:=Np2;
      else
         Np1:=N1+(This_Machine-1)*Integer((-N1)/Num_Of_Machines);
         Np2:=N1+This_Machine*Integer((-N1)/Num_Of_Machines)-1;
         RN1:=Np1-1;RN2:=Np2+1;
      end if;
      K1:=-M/2;
      K2:=M/2-1;

      declare
         Rad: ScalArray(RN1..RN2);
         Ro: ScalArray(RN1-1..RN2);
         Belt,H: CompMatrix(Np1..Np2,K1..K2);
       begin

         --READING THE RADIAL GRID
         New_Line;
         Put("Reading grid ...");
         Open(F,In_File,Radial_Grid);
         Open(F2,In_File,Rho_Grid);
         Set_Line(F,Ada.Text_IO.Count(2+RN1-N1));
         Set_Line(F2,Ada.Text_IO.Count(2+RN1-N1));
         for I in Rad'Range loop
            Txt_Get(F,Roo);
            Rad(I):=Scal(Roo);
         end loop;
         for I in Ro'Range loop
            Txt_Get(F2,Roo);
            Ro(I):=Scal(Roo);
         end loop;
         Close(F2);
         Close(F);
         Put("done");

         --DISPLAYING INFO
         New_Line;
         New_Line;
         Put("q_n=");ShortPut(Qn);
         New_Line;
         Put("c=");Show(CrPointt);
         New_Line;
         Put("p=");Show(P);
         New_Line;
         Put("ind. point=");Show(Ind_P);
         New_Line;
         Put("f^(q_(n+2))(c)=");Show(Cn2);
         New_Line;
         Put("f^(q_(n+2)+q_n)(c)=");Show(Cn2n);
         New_Line;
         Put("Iterations in T_Transfrom=");ShortPut(Iter);
         New_Line;
         Put("Maximal radius=");Txt_Put(Current_Output,Approx(Rad(Rad'Last)));
         New_Line;
         Put("Radial grid dimensions=(");ShortPut(N1);Put(",");ShortPut(N2);Put(")");
         New_Line;
         Put("Angular grid dimensions=(");ShortPut(K1);Put(",");ShortPut(K2);Put(")");
         New_Line;
         Put("Radial grid dimensions on this machine=(");ShortPut(Np1);Put(",");ShortPut(Np2);Put(")");

         Create(F,Out_File,Dir & "logs/start_" & To_String(CM));
         Put(F,0);
         Close(F);

         --READING/COMPUTING AND WRITING THE BELTRAMI DIFFERENTIAL
         if Read_Beltrami then
            New_Line;
            New_Line;
            Put("Reading the differential...");
            ShowErr:=False;
            Read_SB(Belt,Belt_File,False,False,Brackets,Decimal,ShowErr);
            Put(" done");
         else
            New_Line;
            New_Line;
            Put("Forming the Beltrami differential...");
            if This_Machine=1 and This_Machine<=(Num_Of_Machines) then
               BeltramiF(1,NumErr,Rad,IterTay,Belt);
            else
               Beltrami(1,NumErr,Rad,IterTay,Belt);
            end if;
            New_Line;
            Put(" done");
            if Write_Beltrami then
               New_Line;
               Put("Writing the Beltrami differential...");
               ShowErr:=False;
               Write_SB(Belt,Approx_Belt_File,Brackets,Decimal,ShowErr); --series
               Put(" done");
            end if;
         end if;

         Con_File:=Dir & "con_file";
         if This_Machine=1 then
            Create(F,Out_File,Con_File);
            Put(F,Iter);
            Close(F);
         end if;

         ShowErr:=False;
         SetZero(H);

         --ITERATING
         Iter_Approx_Sol(N1,Num_Of_Machines,This_Machine,Cut_Output,Iter,Belt,H,Rad,Rad,Ro,CoZero,Con_File,Dir,Read_Approx,Write_Sol,Brackets,Decimal,ShowErr);
        if  This_Machine=1 then
            Create(F,Out_File,SolZeroValue_File);
            Put(F,H(H'First(1),0),Brackets,Decimal,ShowErr);
            Close(F);
         end if;
      end;
   end;
end Approx_Sol;



























