#!/usr/local/bin/perl -w

$course = "MAT1301S - Algebraic Topology";
$year = "2025-26";
$yr = "2526";

print "Making $year ($yr): $course...\n";

$Essentials = "";
until (($line = <DATA>) eq "EOT\n") {
  $line =~ s/\$\$(.+)\$\$/eval($1)/ge;
  $Essentials=$Essentials.$line;
}

sub framed_page {
  my $args = $_[0];
  my $name = $args->{'name'};
  my $title = $args->{'title'};
  my $titcom = $args->{'titcom'};
  my $url = $args->{'url'};
  my $silent = $args->{'silent'};
  my $external = $args->{'external'};
  my $comment = $args->{'comment'};

  my $href_class="";
  my $copyleft="";
  if ($external) {
    $href_class="class=external";
  } else {
    $copyleft="<a href=/~drorbn/Copyleft/index.html>&copy;</a> |";
  }

  my $top_frame_height=60;
  if ($comment) {
    $top_frame_height=90;
  } else {$comment= "";}

  unless ($titcom) {$titcom = "";}

  unless ($silent) {
    $n++;
    $pages[$n]{"name"} = $name;
    $pages[$n]{"title"} = $title;
  }


  if ($pass) {
    print $n.": Creating ".$title."...\n";
    open (Fout, '>web/'.$name.'.html');
    open (Ftop, '>web/'.$name.'-top.html');

    print Fout <<"EOT";
<! Script generated - do not edit! >
<html>
<head>
  <link rel="stylesheet" type="text/css" href="/~drorbn/global.css">
  <title>Dror Bar-Natan: Classes: $year: $course: $title</title>
</head>

<frameset rows="$top_frame_height,*">
  <frame name="top" src="$name-top.html" marginwidth=5 marginheight=5>
  <frame name="main" src="$url" marginwidth=10 marginheight=5>
</frameset>
</html>
EOT

    print Ftop <<"EOT";
<! Script generated - do not edit! >
<html><base target="_parent">

<head>
  <link rel="stylesheet" type="text/css" href="/~drorbn/global.css">
  <link rel="stylesheet" type="text/css" href="../local.css">
  <title>Dror Bar-Natan: Classes: $year: $course: $title</title>
</head>

<body bgcolor="FFFFFF">

<table border=0 width=100%><tr>
<td width=46% align=left>
  $copyleft
  <a href="/~drorbn/">Dror Bar-Natan</a>:
  <a href="/~drorbn/classes/index.html">Classes</a>:
  <a href="/~drorbn/classes/index.html#$yr">$year</a>:
  <a href="index.html">$course</a>:
  <br><b>$title</b> $titcom
</td>
<td width=8% align=center>
  ($n)
  <br>(<a $href_class href="$url">deframe</a>)
</td>
<td width=46% align=right>
  <a href="$pages[$n+1]{"name"}\.html">Next: $pages[$n+1]{"title"}</a>
  <br><a href="$pages[$n-1]{"name"}\.html">Previous: $pages[$n-1]{"title"}</a>
</td>
</tr></table>

$comment
EOT
    close Ftop; close Fout;
  }

  if ($silent) {
    return "";
  } else {
    return '<a href='.$name.'.html>'.$title.'</a>';
  }
}

sub make_page {
  my $args = $_[0];
  my $name = $args->{'name'};
  my $title = $args->{'title'};
  my $collapse_title = $args->{'collapse_title'};
  my $silent = $args->{'silent'};

  if ($collapse_title) {
    $centered_title = '';
    $inline_title = '<br><b>'.$title.'</b>';
  } else {
    $centered_title = '<center><h1>'.$title.'</h1></center>';
    $inline_title = '';
  }

  unless ($silent) {
    $n++;
    $pages[$n]{"name"} = $name;
    $pages[$n]{"title"} = $title;
  }

  if ($pass) {
    print $n.": Creating ".$title."...\n";
    open (Fin, '<'.$name.'.html'); open (Fout, '>web/'.$name.'.html');
    print Fout "<! Script generated - do not edit! >\n";
    my $line;

    while ($line = <Fin>) {
      chomp $line;
      if ($line eq "TOPMATTER") {
        print Fout <<"EOT";
<html>

<head>
  <link rel="stylesheet" type="text/css" href="/~drorbn/global.css">
  <link rel="stylesheet" type="text/css" href="../local.css">
  <title>Dror Bar-Natan: Classes: $year: $course: $title</title>
</head>

<script type="text/javascript"
  src="https://cdn.mathjax.org/mathjax/latest/MathJax.js">
  MathJax.Hub.Config({
    extensions: ["tex2jax.js","TeX/AMSmath.js","TeX/AMSsymbols.js"],
    jax: ["input/TeX","output/HTML-CSS"],
    tex2jax: {
        inlineMath: [['\$','\$'], ['\\\\(','\\\\)']],
        processEscapes: true
    }
  });
</script>

<body bgcolor="FFFFFF">

\\(
  \\def\\bbN{{\\mathbb N}}
  \\def\\bbQ{{\\mathbb Q}}
  \\def\\bbR{{\\mathbb R}}
  \\def\\bbZ{{\\mathbb Z}}
  \\def\\calA{{\\mathcal A}}
  \\def\\calD{{\\mathcal D}}
  \\def\\calT{{\\mathcal T}}
  \\def\\Lim{{\\operatorname{Lim}}}
\\)

EOT
      } elsif ($line eq "NAVIGATOR") {
        print Fout <<"EOT";
<table border=0 width=100%><tr>
<td width=46% align=left>
  <a href="/~drorbn/Copyleft/index.html">&copy;</a> |
  <a href="/~drorbn/">Dror Bar-Natan</a>:
  <a href="/~drorbn/classes/index.html">Classes</a>:
  <a href="/~drorbn/classes/index.html#$yr">$year</a>:
  <a href="index.html">$course</a>: $inline_title
</td>
<td width=8% align=center> ($n) </td>
<td width=46% align=right>
  <a href="$pages[$n+1]{"name"}\.html">Next: $pages[$n+1]{"title"}</a>
  <br><a href="$pages[$n-1]{"name"}\.html">Previous: $pages[$n-1]{"title"}</a>
</td>
</tr></table>

$centered_title

EOT
      } elsif ($line eq "ESSENTIALS") {
        print Fout $Essentials;
      } elsif ($line eq "INPREPARATION") {
        print Fout <<"EOT";
<center>
<div style="font-size:162%;color:red; margin:0; padding:0"><b>
  In Preparation
</b></div>
<span style="color:red; margin:0; padding:0">
  The information below is preliminary and cannot be trusted!
</span>
</center>
<p>

EOT
      } else {
        print Fout $line."\n";
      }
    }

    close Fin; close Fout;
  }
  if ($silent) {
    return "";
  } else {
    return '<a href='.$name.'.html>'.$title.'</a>';
  }
}

sub classnotes {
  my $args = $_[0];
  my $name = $args->{'name'};
  my $date = $args->{'date'};
  my $count = $args->{'count'};
  my $author = $args->{'author'};
  my $topics = $args->{'topics'};

  $n++;
  $pages[$n]{"name"} = 'Classnotes/'.$name;
  $title = $pages[$n]{"title"} = 'Class Notes for '.$date;

  if ($pass) {
    print $n.": Creating ".$title."...\n";
    open (Fout, '>web/Classnotes/'.$name.'.html');
    print Fout <<"EOT";
<! Script generated - do not edit! >

<html>

<head>
  <link rel="stylesheet" type="text/css" href="/~drorbn/global.css">
  <title>Dror Bar-Natan: Classes: $year: $course: $title</title>
</head>

<body bgcolor="FFFFFF">

<table border=0 width=100%><tr>
<td width=46% align=left>
  <a href="/~drorbn/Copyleft/index.html">&copy;</a> |
  <a href="/~drorbn/">Dror Bar-Natan</a>:
  <a href="/~drorbn/classes/index.html">Classes</a>:
  <a href="/~drorbn/classes/index.html#$yr">$year</a>:
  <a href="index.html">$course</a>:
</td>
<td width=8% align=center> ($n) </td>
<td width=46% align=right>
  <a href="$pages[$n+1]{"name"}\.html">Next: $pages[$n+1]{"title"}</a>
  <br><a href="$pages[$n-1]{"name"}\.html">Previous: $pages[$n-1]{"title"}</a>
</td>
</tr></table>

<center>
  <h1>$title</h1>
  <h3>($topics)</h3>
  <p>by $author
</center>

<p><hr>
<b><font color=red> WARNING:</font></b> These notes are provided "as
is", with absolutely no warranty. They can not be assumed to be
complete, correct, reliable or relevant. If you don't like them, don't
read them. It is a bad idea to stop taking your own notes thinking that
these notes can be a total replacement - there's nothing like one's own
handwriting!
<hr>

EOT
    for ($i=1; $i <= $count; $i++) {
      my $img=$name.'-'.$i;
      print Fout '<p><b>Page '.$i.' of '.$count.":</b>\n";
      print Fout '<br><center><img src='.$img.'.jpg alt='.$img."></center>\n";
    }
print Fout <<"EOT";
</center>

<p>

<table border=0 width=100%><tr>
<td width=46% align=left>
  <a href="/~drorbn/Copyleft/index.html">&copy;</a> |
  <a href="/~drorbn/">Dror Bar-Natan</a>:
  <a href="/~drorbn/classes/index.html">Classes</a>:
  <a href="/~drorbn/classes/index.html#$yr">$year</a>:
  <a href="index.html">$course</a>:
</td>
<td width=8% align=center> ($n) </td>
<td width=46% align=right>
  <a href="$pages[$n+1]{"name"}\.html">Next: $pages[$n+1]{"title"}</a>
  <br><a href="$pages[$n-1]{"name"}\.html">Previous: $pages[$n-1]{"title"}</a>
</td>
</tr></table>

</body></html>
EOT
    close Fout;
  }
  return 'Class notes for <a href=Classnotes/'.$name.'.html>'.$date.'</a> ('.$topics.')';
}

foreach $pass ((0,1)) {
  $n = 0;
  open (In, "< index.html");
  if ($pass) {
    open (Out, ">web/index.html");
    print Out "<! Script generated - do not edit! >\n\n";
  }
  while ($line = <In>) {
    $line =~ s/\$\$(.+)\$\$/eval($1)/ge;
    if ($pass) {print Out $line;}
  }
  ++$n;
  $pages[$n]{"name"} = $pages[0]{"name"} = 'index';
  $pages[$n]{"title"} = $pages[0]{"title"} = 'Class Home';
  close In;
  if ($pass) {
    close Out;
    print $n." documents created...\n";
  }
}

__END__

<p><b>Agenda.</b> Learn about the surprising relation between the easily
deformed (topology) and the most rigid (algebra).

<p><b>Ambition.</b> Get to the Wirtinger presentation of the fundamental
group of knot complements and to the definition of the Alexander
polynomial as the order ideal of the first homology of the universal
Abelian cover of a knot complement. Both of these goals are just a bit too
far, yet they can serve as perfect motivators for all that isn't too far.

<p><b>Instructor.</b> <a href="/~drorbn/">Dror Bar-Natan</a>, <a
href="mailto:drorbn@math.toronto.edu">drorbn@math.toronto.edu</a>
(for course administration matters only; math on email is
slow and prone to misunderstandings, so I generally
avoid it). Office: Bahen 6178.

<div style="float: left; padding: 10px; width: 8%; text-align: center;">
<img style="max-height:500px; max-width:500px; height:auto; width:auto;" src=https://drorbn.net/AcademicPensieve/Classes/26-1301-AlgebraicTopology/Charlie_Wu.jpg>
<br>Charlie Wu
</div>

<p><b>Teaching Assistant.</b> Charlie Wu, charliec.wu@mail.utoronto.ca.

<p><b>Classes.</b> Mondays 10-11am and Tuesdays 4-6pm, at Bahen 6183.

<P><b>Office Time.</b> Wednesdays 2-3:30pm at Bahen 6178 and online
  at <a href="https://drorbn.net/vchat">https://drorbn.net/vchat</a>.

<p><b>Text.</b> Mostly Alan Hacther's <a class=external
href="https://pi.math.cornell.edu/~hatcher/AT/ATpage.html">Algebraic
Topology</a>, but also several specialized sources for specialized topics.

<p><b>URL.</b> <a href=https://drorbn.net/26-1301>https://drorbn.net/26-1301</a>.

EOT
